/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.debug.Debug;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

class CertificateInfo {
    private static ArrayList _keys = new ArrayList(8);
    private String _subjectName;
    private String _issuerName;
    private Date _expirationDate;
    private Date _startDate;
    private Certificate _certificate;

    private CertificateInfo(X509Certificate x509Certificate) {
        this._certificate = x509Certificate;
        this._subjectName = this.getDisplayName(x509Certificate.getSubjectDN().getName());
        this._issuerName = this.getDisplayName(x509Certificate.getIssuerDN().getName());
        this._expirationDate = x509Certificate.getNotAfter();
        this._startDate = x509Certificate.getNotBefore();
    }

    private String getDisplayName(String string) {
        String string2 = CertificateInfo.parseString(string, "CN");
        if (string2 == null || string2.length() == 0) {
            string2 = CertificateInfo.parseString(string, "O");
        }
        return string2;
    }

    String getSubjectName() {
        return this._subjectName;
    }

    String getIssuerName() {
        return this._issuerName;
    }

    Date getExpirationDate() {
        return this._expirationDate;
    }

    Date getStartDate() {
        return this._startDate;
    }

    Certificate getCertificate() {
        return this._certificate;
    }

    Iterator getKeys() {
        return _keys.iterator();
    }

    String getValue(Object object) {
        return ((X509KeyLookup)object).getValue(this._certificate);
    }

    static CertificateInfo getCertificateInfo(Certificate certificate) throws CertificateException {
        if (certificate instanceof X509Certificate) {
            return new CertificateInfo((X509Certificate)certificate);
        }
        throw new CertificateException("Unknown kind of certificate");
    }

    private static String parseString(String string, String string2) {
        int n;
        int n2 = string.indexOf(string2 + "=");
        if (n2 == -1) {
            return "";
        }
        String string3 = string.substring(n2 += string2.length() + 1).trim();
        if (string3.startsWith("\"") && (n = string3.indexOf("\"", 1)) > 0) {
            return string3.substring(1, n);
        }
        n = string.indexOf(44, n2);
        if (n != -1) {
            return string.substring(n2, n);
        }
        return string.substring(n2);
    }

    static {
        _keys.add(new X509KeyLookup("Issuer ID", "getIssuerUniqueID"));
        _keys.add(new X509KeyLookup("Issuer", "getIssuerDN"));
        _keys.add(new X509KeyLookup("Valid From", "getNotBefore"));
        _keys.add(new X509KeyLookup("Valid To", "getNotAfter"));
        _keys.add(new X509KeyLookup("Serial Number", "getSerialNumber"));
        _keys.add(new X509KeyLookup("Subject", "getSubjectDN"));
        _keys.add(new X509KeyLookup("Subject ID", "getSubjectUniqueID"));
        _keys.add(new X509KeyLookup("Version", "getVersion"));
    }

    private static class X509KeyLookup {
        private String _key;
        private Method _method;
        private String _methodName;

        X509KeyLookup(String string, String string2) {
            this._key = string;
            this._methodName = string2;
        }

        public String getValue(Object object) {
            Method method = this.getMethod(object, this._methodName);
            return this.handleLookup(method, object);
        }

        public String toString() {
            return this._key;
        }

        private Method getMethod(Object object, String string) {
            block2: {
                if (this._method != null) break block2;
                try {
                    this._method = object.getClass().getMethod(string, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Debug.fatal("No method: " + string);
                }
            }
            return this._method;
        }

        private String handleLookup(Method method, Object object) {
            Object object2 = "";
            try {
                object2 = method.invoke(object, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
            return this.convertToString(object2);
        }

        private String convertToString(Object object) {
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof byte[]) {
                StringBuffer stringBuffer = new StringBuffer();
                byte[] byArray = (byte[])object;
                if (byArray.length > 0) {
                    stringBuffer.append(Integer.toHexString(byArray[0]));
                    int n = 1;
                    while (n < byArray.length) {
                        stringBuffer.append(':');
                        stringBuffer.append(Integer.toHexString(byArray[n]));
                        ++n;
                    }
                }
                return stringBuffer.toString();
            }
            if (object instanceof Principal) {
                return ((Principal)object).getName();
            }
            if (object instanceof Date) {
                DateFormat dateFormat = DateFormat.getDateInstance(3);
                return dateFormat.format((Date)object);
            }
            if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < blArray.length) {
                    if (n % 8 == 1 && n != 1) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(blArray[n] ? (char)'1' : '0');
                    ++n;
                }
                return stringBuffer.toString();
            }
            if (object != null) {
                return object.toString();
            }
            return "";
        }
    }
}

