/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.debug.Globals;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

public final class FileOpenServiceImpl
implements FileOpenService {
    static FileOpenServiceImpl _sharedInstance = null;
    static FileSaveServiceImpl _fileSaveServiceImpl;

    private FileOpenServiceImpl(FileSaveServiceImpl fileSaveServiceImpl) {
        _fileSaveServiceImpl = fileSaveServiceImpl;
    }

    public static synchronized FileOpenService getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new FileOpenServiceImpl((FileSaveServiceImpl)FileSaveServiceImpl.getInstance());
        }
        return _sharedInstance;
    }

    public static FileSystemView getFileSystemView() {
        String string;
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        if (Globals.isWindowsPlatform() && ((string = System.getProperty("java.version")).startsWith("1.2") || string.startsWith("1.3"))) {
            fileSystemView = new WindowsAltFileSystemView();
        }
        return fileSystemView;
    }

    public FileContents openFileDialog(final String string, String[] stringArray) throws IOException {
        if (!_fileSaveServiceImpl.askUser()) {
            return null;
        }
        FileContents fileContents = (FileContents)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                JFileChooser jFileChooser = null;
                FileSystemView fileSystemView = FileOpenServiceImpl.getFileSystemView();
                jFileChooser = string != null ? new JFileChooser(string, fileSystemView) : new JFileChooser(_fileSaveServiceImpl.getLastPath(), fileSystemView);
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setDialogType(0);
                jFileChooser.setMultiSelectionEnabled(false);
                int n = jFileChooser.showOpenDialog(null);
                if (n == 1) {
                    return null;
                }
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    try {
                        _fileSaveServiceImpl.setLastPath(file.getPath());
                        return new FileContentsImpl(file, FileSaveServiceImpl.computeMaxLength(file.length()));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                    }
                }
                return null;
            }
        });
        return fileContents;
    }

    public FileContents[] openMultiFileDialog(final String string, String[] stringArray) throws IOException {
        if (!_fileSaveServiceImpl.askUser()) {
            return null;
        }
        FileContents[] fileContentsArray = (FileContents[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                JFileChooser jFileChooser = null;
                FileSystemView fileSystemView = FileOpenServiceImpl.getFileSystemView();
                jFileChooser = string != null ? new JFileChooser(string, fileSystemView) : new JFileChooser(_fileSaveServiceImpl.getLastPath(), fileSystemView);
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setDialogType(0);
                jFileChooser.setMultiSelectionEnabled(true);
                int n = jFileChooser.showOpenDialog(null);
                if (n == 1) {
                    return null;
                }
                File[] fileArray = jFileChooser.getSelectedFiles();
                if (fileArray != null && fileArray.length > 0) {
                    FileContents[] fileContentsArray = new FileContents[fileArray.length];
                    int n2 = 0;
                    while (n2 < fileArray.length) {
                        try {
                            fileContentsArray[n2] = new FileContentsImpl(fileArray[n2], FileSaveServiceImpl.computeMaxLength(fileArray[n2].length()));
                            _fileSaveServiceImpl.setLastPath(fileArray[n2].getPath());
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ++n2;
                    }
                    return fileContentsArray;
                }
                return null;
            }
        });
        return fileContentsArray;
    }

    static class WindowsAltFileSystemView
    extends FileSystemView {
        private static final Object[] noArgs = new Object[0];
        private static final Class[] noArgTypes = new Class[0];
        private static Method listRootsMethod = null;
        private static boolean listRootsMethodChecked = false;

        WindowsAltFileSystemView() {
        }

        public boolean isRoot(File file) {
            if (!file.isAbsolute()) {
                return false;
            }
            String string = file.getParent();
            if (string == null) {
                return true;
            }
            File file2 = new File(string);
            return file2.equals(file);
        }

        public File createNewFolder(File file) throws IOException {
            if (file == null) {
                throw new IOException("Containing directory is null:");
            }
            File file2 = null;
            file2 = this.createFileObject(file, "New Folder");
            int n = 2;
            while (file2.exists() && n < 100) {
                file2 = this.createFileObject(file, "New Folder (" + n + ")");
                ++n;
            }
            if (file2.exists()) {
                throw new IOException("Directory already exists:" + file2.getAbsolutePath());
            }
            file2.mkdirs();
            return file2;
        }

        public boolean isHiddenFile(File file) {
            return false;
        }

        public File[] getRoots() {
            Object[] objectArray;
            Vector<FileSystemRoot> vector = new Vector<FileSystemRoot>();
            FileSystemRoot fileSystemRoot = new FileSystemRoot("A:\\");
            vector.addElement(fileSystemRoot);
            char c = 'C';
            while (c <= 'Z') {
                objectArray = new char[]{c, ':', '\\'};
                String string = new String((char[])objectArray);
                FileSystemRoot fileSystemRoot2 = new FileSystemRoot(string);
                if (fileSystemRoot2 != null && fileSystemRoot2.exists()) {
                    vector.addElement(fileSystemRoot2);
                }
                c = (char)(c + 1);
            }
            objectArray = new File[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        class FileSystemRoot
        extends File {
            public FileSystemRoot(File file) {
                super(file, "");
            }

            public FileSystemRoot(String string) {
                super(string);
            }

            public boolean isDirectory() {
                return true;
            }
        }
    }
}

