/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

import com.ibm.xml.dsig.AlgorithmFactory;
import com.ibm.xml.dsig.IDResolver;
import com.ibm.xml.dsig.Transform;
import com.ibm.xml.dsig.transform.DecryptionTransformer;
import com.ibm.xml.enc.DOMSerializationEngine;
import com.ibm.xml.enc.EncodingEngine;
import com.ibm.xml.enc.EncryptedKeyRetriever;
import com.ibm.xml.enc.EncryptionEngine;
import com.ibm.xml.enc.KeyGenerationEngine;
import com.ibm.xml.enc.KeyInfoResolver;
import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.EncryptionMethod;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.NoSuchPaddingException;
import org.xml.sax.EntityResolver;

public class AlgorithmFactoryExtn
extends AlgorithmFactory {
    private KeyInfoResolver fKeyInfoResolver;
    private IDResolver fIdResolver;
    private EntityResolver fEntityResolver;
    private EncryptedKeyRetriever fEncryptedKeyRetriever;

    public AlgorithmFactoryExtn() {
        super(null);
        this.digestMethodTable.put("http://www.w3.org/2001/04/xmlenc#sha256", "SHA256");
        this.digestMethodTable.put("http://www.w3.org/2001/04/xmlenc#sha512", "SHA512");
        this.digestMethodTable.put("http://www.w3.org/2001/04/xmlenc#ripemd160", "RIPEMD160");
        this.transformTable.put("http://www.w3.org/2001/04/decrypt#", "com.ibm.xml.dsig.transform.XMLDecryptionTransformer");
        this.transformTable.put("http://www.w3.org/2002/07/decrypt#XML", "com.ibm.xml.dsig.transform.XMLDecryptionTransformer2");
        this.transformTable.put("http://www.w3.org/2002/07/decrypt#Binary", "com.ibm.xml.dsig.transform.BinaryDecryptionTransformer");
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setKeyInfoResolver(KeyInfoResolver resolver) {
        this.fKeyInfoResolver = resolver;
    }

    public void setIdResolver(IDResolver resolver) {
        this.fIdResolver = resolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.fEntityResolver = resolver;
    }

    public void setEncryptedKeyRetriever(EncryptedKeyRetriever retriever) {
        this.fEncryptedKeyRetriever = retriever;
    }

    public EncryptionEngine getEncryptionEngine(EncryptionMethod encMeth) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        if (encMeth == null) {
            throw new NullPointerException("EncryptionMethod not specified");
        }
        String s = encMeth.getAlgorithm();
        EncryptionEngine engine = null;
        if (s == null) {
            throw new StructureException("Algorithm not specified");
        }
        if (s.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            engine = new EncryptionEngine.TripleDESCBC(encMeth, this.provider);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            engine = new EncryptionEngine.AES128CBC(encMeth, this.provider);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
            engine = new EncryptionEngine.AES192CBC(encMeth, this.provider);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            engine = new EncryptionEngine.AES256CBC(encMeth, this.provider);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
            engine = new EncryptionEngine.RSA15(encMeth, this.provider, this);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
            engine = new EncryptionEngine.RSAOAEP(encMeth, this.provider, this);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
            engine = new EncryptionEngine.KWTripleDES(encMeth, this.provider, this);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
            engine = new EncryptionEngine.KWAES128(encMeth, this.provider, this);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
            engine = new EncryptionEngine.KWAES192(encMeth, this.provider, this);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
            engine = new EncryptionEngine.KWAES256(encMeth, this.provider, this);
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm: " + s);
        }
        return engine;
    }

    public KeyGenerationEngine getKeyGenerationEngine(EncryptionMethod encMeth) throws NoSuchAlgorithmException, NoSuchProviderException, StructureException {
        if (encMeth == null) {
            throw new NullPointerException("EncryptionMethod not specified");
        }
        String s = encMeth.getAlgorithm();
        KeyGenerationEngine engine = null;
        if (s == null) {
            throw new StructureException("Algorithm not specified");
        }
        if (s.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || s.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
            engine = new KeyGenerationEngine.TripleDES(encMeth, this.provider);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || s.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
            engine = new KeyGenerationEngine.AES128(encMeth, this.provider);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || s.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
            engine = new KeyGenerationEngine.AES192(encMeth, this.provider);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc") || s.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
            engine = new KeyGenerationEngine.AES256(encMeth, this.provider);
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm: " + s);
        }
        return engine;
    }

    public EncodingEngine getEncodingEngine(String uri) throws NoSuchAlgorithmException {
        EncodingEngine engine = null;
        if (uri == null) {
            throw new NullPointerException("Algorithm not specified");
        }
        if (uri.equals("http://www.w3.org/2000/09/xmldsig#base64")) {
            engine = new EncodingEngine.Base64();
        } else if (uri.equals("http://www.trl.ibm.com/xmlenc#hex")) {
            engine = new EncodingEngine.Hex();
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm: " + uri);
        }
        return engine;
    }

    public DOMSerializationEngine getDOMSerializationEngine(String type) throws NoSuchAlgorithmException {
        DOMSerializationEngine.XMLContent engine = null;
        if (type == null) {
            throw new NullPointerException("Type not specified");
        }
        if (type.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            engine = new DOMSerializationEngine.XMLElement();
        } else if (type.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            engine = new DOMSerializationEngine.XMLContent();
        } else {
            throw new NoSuchAlgorithmException("Unknown type: " + type);
        }
        return engine;
    }

    public Transform getTransform(String uri) throws NoSuchAlgorithmException {
        Transform trans = super.getTransform(uri);
        if (trans instanceof DecryptionTransformer) {
            DecryptionTransformer dt = (DecryptionTransformer)trans;
            dt.setAlgorithmFactory(this);
            dt.setKeyInfoResolver(this.fKeyInfoResolver);
            dt.setIdResolver(this.fIdResolver);
            dt.setEntityResolver(this.fEntityResolver);
            dt.setEncryptedKeyRetriever(this.fEncryptedKeyRetriever);
        }
        return trans;
    }
}

