/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

import com.ibm.xml.enc.TransformerFactoryExtn;
import com.ibm.xml.enc.util.DOMUtil;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DOMSerializationEngine {
    public abstract String getType();

    public abstract void setOutputStream(OutputStream var1);

    public abstract void serialize(NodeList var1) throws IOException;

    private static Throwable unwrapException(TransformerException exc) {
        Throwable thr = exc.getException();
        if (thr == null) {
            thr = exc;
        }
        return thr;
    }

    static class XMLElement
    extends XMLContent {
        XMLElement() {
        }

        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Element";
        }

        public void serialize(NodeList nodeList) throws IOException {
            if (nodeList != null) {
                Element n = DOMUtil.getFirstElement(nodeList);
                DOMUtil.NodeListImpl nl = new DOMUtil.NodeListImpl();
                if (n != null) {
                    nl.add(n);
                }
                nodeList = nl;
            }
            super.serialize(nodeList);
        }
    }

    static class XMLContent
    extends DOMSerializationEngine {
        private Transformer fTransformer;
        private OutputStream fOut;

        XMLContent() {
            try {
                this.fTransformer = TransformerFactoryExtn.getTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(DOMSerializationEngine.unwrapException(e).toString());
            }
        }

        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Content";
        }

        public void setOutputStream(OutputStream out) {
            this.fOut = out;
        }

        public void serialize(NodeList nodeList) throws IOException {
            if (nodeList != null) {
                DOMSource ds = new DOMSource();
                StreamResult r = new StreamResult(this.fOut);
                int i = 0;
                int l = nodeList.getLength();
                while (i < l) {
                    ds.setNode(nodeList.item(i));
                    try {
                        this.fTransformer.transform(ds, r);
                    }
                    catch (TransformerException e) {
                        Throwable t = DOMSerializationEngine.unwrapException(e);
                        if (t instanceof IOException) {
                            throw (IOException)t;
                        }
                        throw new RuntimeException(t.toString());
                    }
                    ++i;
                }
            }
        }
    }
}

