/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

import com.ibm.xml.dsig.IDResolver;
import com.ibm.xml.dsig.XSignatureException;
import com.ibm.xml.enc.AlgorithmFactoryExtn;
import com.ibm.xml.enc.DocumentBuilderFactoryExtn;
import com.ibm.xml.enc.EncryptedKeyRetriever;
import com.ibm.xml.enc.EncryptedTypeContainer;
import com.ibm.xml.enc.EncryptionEngine;
import com.ibm.xml.enc.EncryptionInputStream;
import com.ibm.xml.enc.KeyInfoResolver;
import com.ibm.xml.enc.KeyInfoResolvingException;
import com.ibm.xml.enc.SignatureContextExtn;
import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.XMLWriter;
import com.ibm.xml.enc.type.CipherData;
import com.ibm.xml.enc.type.CipherReference;
import com.ibm.xml.enc.type.CipherValue;
import com.ibm.xml.enc.type.DsTransforms;
import com.ibm.xml.enc.type.EncryptedData;
import com.ibm.xml.enc.type.EncryptedKey;
import com.ibm.xml.enc.type.EncryptedType;
import com.ibm.xml.enc.type.EncryptionMethod;
import com.ibm.xml.enc.type.KeyInfo;
import com.ibm.xml.enc.type.Transform;
import com.ibm.xml.enc.type.Transforms;
import com.ibm.xml.enc.type.Type;
import com.ibm.xml.enc.util.DOMUtil;
import com.ibm.xml.enc.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class DecryptionContext {
    private EncryptedTypeContainer fEncryptedTypeContainer;
    private EncryptionMethod fEncryptionMethod;
    private AlgorithmParameterSpec fParameters;
    private Key fKey;
    private AlgorithmFactoryExtn fAlgorithmFactory;
    private KeyInfoResolver fKeyInfoResolver;
    private IDResolver fIdResolver;
    private EntityResolver fEntityResolver;
    private EncryptedKeyRetriever fEncryptedKeyRetriever;
    private Object fData;
    private String fType;
    private String fMimeType;
    private String fEncoding;

    public void setEncryptedType(InputStream encType, String type, Element encMeth, Element keyInfo) throws IOException, ParserConfigurationException, SAXException {
        Element e = null;
        if (encType != null) {
            DocumentBuilder db = DocumentBuilderFactoryExtn.getDocumentBuilder();
            e = db.parse(encType).getDocumentElement();
        }
        this.setEncryptedType(e, type, encMeth, keyInfo);
    }

    public void setEncryptedType(Element encType, String type, Element encMeth, Element keyInfo) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(encType, type, encMeth, keyInfo);
    }

    void setEncryptedType(EncryptedType encType, String type, EncryptionMethod encMeth, KeyInfo keyInfo) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(encType, type, encMeth, keyInfo);
    }

    public void setEncryptionMethod(Element encMeth) {
        EncryptionMethod em = null;
        if (encMeth != null) {
            em = new EncryptionMethod(encMeth);
        }
        this.setEncryptionMethod(em);
    }

    void setEncryptionMethod(EncryptionMethod encMeth) {
        this.fEncryptionMethod = encMeth;
    }

    public void setParameters(AlgorithmParameterSpec params) {
        this.fParameters = params;
    }

    public void setKey(Key key) {
        this.fKey = key;
    }

    public void setAlgorithmFactory(AlgorithmFactoryExtn factory) {
        this.fAlgorithmFactory = factory;
    }

    public void setKeyInfoResolver(KeyInfoResolver resolver) {
        this.fKeyInfoResolver = resolver;
    }

    public void setIdResolver(IDResolver resolver) {
        this.fIdResolver = resolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.fEntityResolver = resolver;
    }

    public void setEncryptedKeyRetriever(EncryptedKeyRetriever retriever) {
        this.fEncryptedKeyRetriever = retriever;
    }

    public Object getData() {
        return this.fData;
    }

    public NodeList getDataAsNodeList() throws IOException, ParserConfigurationException, SAXException, StructureException {
        if (this.fData != null) {
            if (this.fType == null) {
                throw new StructureException("Type attribute not specified");
            }
            if (this.fType.equals("http://www.w3.org/2001/04/xmlenc#Element") || this.fType.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                if (this.fData instanceof InputStream) {
                    Element e = this.fEncryptedTypeContainer.getET().getBase();
                    byte[] bb = Util.getBytes((InputStream)this.fData);
                    bb = DecryptionContext.wrapData(bb, e);
                    this.fData = DOMUtil.getChildNodes(this.parseData(bb, e));
                } else if (!(this.fData instanceof NodeList)) {
                    throw new RuntimeException("Instance of unknown class: " + this.fData.getClass().getName());
                }
            } else {
                throw new StructureException("Unknown type: " + this.fType);
            }
        }
        return (NodeList)this.fData;
    }

    public String getType() {
        return this.fType;
    }

    public String getMimeType() {
        return this.fMimeType;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public Key getKey() {
        return this.fKey;
    }

    public void decrypt() throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither encrypted data nor key specified");
        }
        EncryptedType et = this.fEncryptedTypeContainer.getET();
        if (et == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        if (et instanceof EncryptedData) {
            EncryptionEngine ee = this.getEncryptionEngine(2);
            InputStream is = this.getInputStream();
            this.fData = new EncryptionInputStream(is, ee);
        } else if (et instanceof EncryptedKey) {
            EncryptionEngine ee = this.getEncryptionEngine(4);
            byte[] bb = Util.getBytes(this.getInputStream());
            String s = this.fEncryptedTypeContainer.getType();
            this.fData = ee.unwrap(bb, this.fEncryptionMethod, s);
        }
        this.fType = this.fEncryptedTypeContainer.getType();
        this.fMimeType = et.getMimeType();
        this.fEncoding = et.getEncoding();
    }

    private EncryptionEngine getEncryptionEngine(int opMode) throws InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        EncryptionMethod em = this.fEncryptedTypeContainer.getEM();
        if (em == null) {
            throw new StructureException("EncryptionMethod element not specified");
        }
        if (this.fAlgorithmFactory == null) {
            throw new NullPointerException("Algorithm factory not specified");
        }
        EncryptionEngine engine = this.fAlgorithmFactory.getEncryptionEngine(em);
        Key k = this._getKey();
        if (k == null) {
            throw new NullPointerException("Key not specified or obtained");
        }
        engine.init(opMode, k, this.fParameters);
        return engine;
    }

    private Key _getKey() throws KeyInfoResolvingException {
        String s;
        KeyInfo ki;
        if (this.fKey == null && (ki = this.fEncryptedTypeContainer.getKI()) != null && this.fKeyInfoResolver != null) {
            this.fKey = this.fKeyInfoResolver.resolve(ki, this.fEncryptedTypeContainer.getEM());
        }
        if (this.fKey == null && (s = this.fEncryptedTypeContainer.getET().getId()) != null && this.fEncryptedKeyRetriever != null && this.fKeyInfoResolver != null) {
            KeyInfo ki2 = new KeyInfo();
            Iterator i = this.fEncryptedKeyRetriever.retrieve(s).iterator();
            while (i.hasNext()) {
                ki2.addEncryptedKey((EncryptedKey)i.next());
            }
            this.fKey = this.fKeyInfoResolver.resolve(ki2, this.fEncryptedTypeContainer.getEM());
        }
        return this.fKey;
    }

    private InputStream getInputStream() throws StructureException, XSignatureException {
        CipherData cd = this.fEncryptedTypeContainer.getET().getCipherData();
        if (cd == null) {
            throw new StructureException("CipherData element not specified");
        }
        Type ty = cd.getCipherData();
        byte[] bb = null;
        if (ty == null) {
            throw new StructureException("Neither CipherValue nor CipherReference element specified");
        }
        if (ty instanceof CipherValue) {
            bb = ((CipherValue)ty).getValue();
            if (bb == null) {
                throw new StructureException("Cipher value not specified");
            }
        } else if (ty instanceof CipherReference) {
            CipherReference cr = (CipherReference)ty;
            String s = cr.getURI();
            if (s == null) {
                throw new StructureException("URI attribute not specified");
            }
            Element e = cr.getBase();
            Transforms tr = cr.getTransforms();
            if (tr != null) {
                DsTransforms tr2 = new DsTransforms();
                Iterator i = tr.getTransforms().iterator();
                while (i.hasNext()) {
                    tr2.addTransform((Transform)i.next());
                }
                Element e2 = tr2.createElement(e.getOwnerDocument(), true);
                e = (Element)e.cloneNode(false);
                e.appendChild(e2);
            }
            SignatureContextExtn sc = new SignatureContextExtn();
            sc.setAlgorithmFactory(this.fAlgorithmFactory);
            sc.setIDResolver(this.fIdResolver);
            sc.setEntityResolver(this.fEntityResolver);
            bb = (byte[])sc.retrieve(e);
        }
        return new ByteArrayInputStream(bb);
    }

    public void replace() throws IOException, ParserConfigurationException, SAXException, StructureException {
        NodeList nl = this.getDataAsNodeList();
        if (nl == null) {
            throw new NullPointerException("Data not obtained");
        }
        DOMUtil.replaceNode((Node)this.fEncryptedTypeContainer.getET().getBase(), nl);
    }

    public static byte[] wrapData(byte[] data, Node node) {
        DocumentType dt;
        NamedNodeMap nnm = null;
        if (node != null && (dt = node.getOwnerDocument().getDoctype()) != null) {
            nnm = dt.getEntities();
        }
        Map m = DOMUtil.getNamespaceDeclAttrNodes(node);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            String s;
            XMLWriter xw = new XMLWriter(os);
            if (nnm != null && nnm.getLength() > 0) {
                xw.printText("<!DOCTYPE dummy [");
                int i = nnm.getLength() - 1;
                while (i >= 0) {
                    Entity e = (Entity)nnm.item(i);
                    if (e.getNotationName() == null) {
                        xw.printText("<!ENTITY " + e.getNodeName() + " ");
                        if (e.getSystemId() != null) {
                            s = e.getPublicId();
                            if (s != null) {
                                xw.printText("PUBLIC ");
                                xw.printDoctypeURL(s);
                                xw.printText(' ');
                            } else {
                                xw.printText("SYSTEM ");
                            }
                            xw.printDoctypeURL(e.getSystemId());
                        } else {
                            xw.printText('\"');
                            xw.printText(DOMUtil.cloneChildNodes(e), false);
                            xw.printText('\"');
                        }
                        xw.printText('>');
                    }
                    --i;
                }
                xw.printText("]>");
            }
            xw.printText("<dummy");
            if (m != null && m.size() > 0) {
                Iterator i = m.values().iterator();
                while (i.hasNext()) {
                    Attr a = (Attr)i.next();
                    xw.printText(" " + a.getName() + "=\"");
                    s = a.getValue();
                    if (s == null) {
                        s = "";
                    }
                    xw.printEscaped(s);
                    xw.printText('\"');
                }
            }
            xw.printText('>');
            xw.flush();
            if (data != null) {
                os.write(data);
            }
            xw.printText("</dummy>");
            xw.flush();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return os.toByteArray();
    }

    private Element parseData(byte[] data, Node node) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder db = DocumentBuilderFactoryExtn.getDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        Element elem = db.parse(is).getDocumentElement();
        if (node != null) {
            Document d = node.getOwnerDocument();
            if (node.getNodeType() == 9) {
                d = (Document)node;
            }
            elem = (Element)d.importNode(elem, true);
        }
        return elem;
    }
}

