/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

public abstract class EncodingEngine {
    public static final String BASE64 = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final String HEX = "http://www.trl.ibm.com/xmlenc#hex";

    public abstract String getAlgorithm();

    public abstract String encode(byte[] var1);

    public abstract byte[] decode(String var1);

    static class Hex
    extends EncodingEngine {
        Hex() {
        }

        private char toChar(int i) {
            i = i < 10 ? (i += 48) : (i += 87);
            return (char)i;
        }

        private int toInt(char c) {
            c = c >= '0' && c <= '9' ? (char)(c - 48) : (char)(c - 87);
            return c;
        }

        public String getAlgorithm() {
            return EncodingEngine.HEX;
        }

        public String encode(byte[] data) {
            String encoded = null;
            if (data != null) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < data.length) {
                    sb.append(this.toChar((data[i] & 0xF0) >> 4));
                    sb.append(this.toChar(data[i] & 0xF));
                    ++i;
                }
                encoded = sb.toString();
            }
            return encoded;
        }

        public byte[] decode(String data) {
            byte[] decoded = null;
            if (data != null) {
                int l = data.length();
                if (l % 2 != 0) {
                    data = "0" + data;
                    ++l;
                }
                decoded = new byte[l / 2];
                int i = 0;
                while (i < decoded.length) {
                    decoded[i] = 0;
                    ++i;
                }
                int i2 = 0;
                while (i2 < l) {
                    int j = this.toInt(data.charAt(i2));
                    if (i2 % 2 == 0) {
                        j <<= 4;
                    }
                    int n = i2 / 2;
                    decoded[n] = (byte)(decoded[n] | j);
                    ++i2;
                }
            }
            return decoded;
        }
    }

    static class Base64
    extends EncodingEngine {
        Base64() {
        }

        public String getAlgorithm() {
            return EncodingEngine.BASE64;
        }

        public String encode(byte[] data) {
            String encoded = null;
            if (data != null) {
                encoded = com.ibm.xml.dsig.util.Base64.encode((byte[])data);
            }
            return encoded;
        }

        public byte[] decode(String data) {
            byte[] decoded = null;
            if (data != null) {
                decoded = com.ibm.xml.dsig.util.Base64.decode((String)data);
            }
            return decoded;
        }
    }
}

