/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

import com.ibm.xml.enc.AlgorithmFactoryExtn;
import com.ibm.xml.enc.DOMSerializationEngine;
import com.ibm.xml.enc.EncryptedTypeContainer;
import com.ibm.xml.enc.EncryptionEngine;
import com.ibm.xml.enc.EncryptionOutputStream;
import com.ibm.xml.enc.KeyGenerationEngine;
import com.ibm.xml.enc.KeyInfoResolver;
import com.ibm.xml.enc.KeyInfoResolvingException;
import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.CipherData;
import com.ibm.xml.enc.type.CipherValue;
import com.ibm.xml.enc.type.EncryptedType;
import com.ibm.xml.enc.type.EncryptionMethod;
import com.ibm.xml.enc.type.KeyInfo;
import com.ibm.xml.enc.type.Type;
import com.ibm.xml.enc.util.DOMUtil;
import com.ibm.xml.enc.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptionContext {
    private Object fData;
    private EncryptedTypeContainer fEncryptedTypeContainer;
    private AlgorithmParameterSpec fParameters;
    private Key fKey;
    private AlgorithmParameterSpec fKeyGenParameters;
    private OutputStream fOut;
    private AlgorithmFactoryExtn fAlgorithmFactory;
    private KeyInfoResolver fKeyInfoResolver;
    private Element fEncryptedType;

    public void setData(InputStream in) {
        this.fData = in;
    }

    public void setData(Element elem) {
        this.fData = elem;
    }

    public void setData(Key key) {
        this.fData = key;
    }

    public void setEncryptedType(Element encType, String type, Element encMeth, Element keyInfo) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(encType, type, encMeth, keyInfo);
    }

    void setEncryptedType(EncryptedType encType, String type, EncryptionMethod encMeth, KeyInfo keyInfo) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(encType, type, encMeth, keyInfo);
    }

    public void setParameters(AlgorithmParameterSpec params) {
        this.fParameters = params;
    }

    public void setKey(Key key) {
        this.fKey = key;
    }

    public void setKeyGenerationParameters(AlgorithmParameterSpec params) {
        this.fKeyGenParameters = params;
    }

    public void setOutputStream(OutputStream out) {
        this.fOut = out;
    }

    public void setAlgorithmFactory(AlgorithmFactoryExtn factory) {
        this.fAlgorithmFactory = factory;
    }

    public void setKeyInfoResolver(KeyInfoResolver resolver) {
        this.fKeyInfoResolver = resolver;
    }

    public InputStream getEncryptedType() {
        ByteArrayInputStream in = null;
        if (this.fEncryptedType != null) {
            in = new ByteArrayInputStream(this.serialize(this.fEncryptedType));
        }
        return in;
    }

    private byte[] serialize(Element elem) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DOMSerializationEngine.XMLElement dse = new DOMSerializationEngine.XMLElement();
        ((DOMSerializationEngine)dse).setOutputStream(os);
        try {
            ((DOMSerializationEngine)dse).serialize(new DOMUtil.NodeListImpl(elem));
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return os.toByteArray();
    }

    public Element getEncryptedTypeAsElement() {
        return this.fEncryptedType;
    }

    public Key getKey() {
        return this.fKey;
    }

    public void encrypt() throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        OutputStream os = null;
        if (this.fData == null) {
            throw new NullPointerException("Data not specified");
        }
        if (this.fData instanceof InputStream) {
            os = this.getEncryptionOutputStream();
            Util.getBytes((InputStream)this.fData, os);
        } else if (this.fData instanceof Element) {
            os = this.getEncryptionOutputStream();
            this.serialize((Element)this.fData, os);
        } else if (this.fData instanceof Key) {
            EncryptionEngine ee = this.getEncryptionEngine(3);
            os = this.getOutputStream();
            os.write(ee.wrap((Key)this.fData));
            os.flush();
        }
        this.doFinal(os);
    }

    public EncryptionOutputStream getEncryptionOutputStream() throws IOException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        EncryptionEngine ee = this.getEncryptionEngine(1);
        OutputStream os = this.getOutputStream();
        EncryptionOutputStream out = new EncryptionOutputStream(os, ee);
        return out;
    }

    private EncryptionEngine getEncryptionEngine(int opMode) throws InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        EncryptionMethod em = this.fEncryptedTypeContainer.getEM();
        if (em == null) {
            throw new StructureException("EncryptionMethod element not specified");
        }
        if (this.fAlgorithmFactory == null) {
            throw new NullPointerException("Algorithm factory not specified");
        }
        EncryptionEngine engine = this.fAlgorithmFactory.getEncryptionEngine(em);
        Key k = this._getKey();
        if (k == null) {
            throw new NullPointerException("Key not specified or obtained");
        }
        engine.init(opMode, k, this.fParameters);
        return engine;
    }

    private Key _getKey() throws KeyInfoResolvingException {
        KeyInfo ki;
        if (this.fKey == null && (ki = this.fEncryptedTypeContainer.getKI()) != null && this.fKeyInfoResolver != null) {
            this.fKey = this.fKeyInfoResolver.resolve(ki, this.fEncryptedTypeContainer.getEM());
        }
        return this.fKey;
    }

    private OutputStream getOutputStream() throws StructureException {
        OutputStream out = null;
        if (this.hasCipherValue()) {
            out = new ByteArrayOutputStream();
        } else if (this.fOut != null) {
            out = this.fOut;
        } else {
            throw new NullPointerException("Neither CipherValue element nor output stream specified");
        }
        return out;
    }

    private boolean hasCipherValue() throws StructureException {
        EncryptedType et = this.fEncryptedTypeContainer.getET();
        if (et == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        return this.getCipherValue(et) != null;
    }

    private CipherValue getCipherValue(EncryptedType encType) throws StructureException {
        CipherData cd = encType.getCipherData();
        if (cd == null) {
            throw new StructureException("CipherData element not specified");
        }
        Type t = cd.getCipherData();
        if (t == null) {
            throw new StructureException("Neither CipherValue nor CipherReference element specified");
        }
        CipherValue ciphVal = null;
        if (t instanceof CipherValue) {
            ciphVal = (CipherValue)t;
        }
        return ciphVal;
    }

    private void serialize(Element elem, OutputStream out) throws IOException, NoSuchAlgorithmException, StructureException {
        String s = this.fEncryptedTypeContainer.getType();
        if (s == null) {
            throw new StructureException("Type attribute not specified");
        }
        NodeList nl = null;
        if (s.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            nl = new DOMUtil.NodeListImpl(elem);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            nl = elem.getChildNodes();
        } else {
            throw new StructureException("Unknown type: " + s);
        }
        DOMSerializationEngine dse = this.fAlgorithmFactory.getDOMSerializationEngine(s);
        dse.setOutputStream(out);
        dse.serialize(nl);
    }

    public void doFinal(OutputStream out) throws IOException, StructureException {
        if (out instanceof EncryptionOutputStream) {
            EncryptionOutputStream os = (EncryptionOutputStream)out;
            os.doFinal();
            os.flush();
            out = os.getOutputStream();
        }
        this.fEncryptedType = this.getEncryptedType(out);
    }

    private Element getEncryptedType(OutputStream out) throws StructureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        EncryptedType et = this.fEncryptedTypeContainer.getET();
        if (et == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        CipherValue cv = this.getCipherValue(et);
        if (cv != null) {
            ByteArrayOutputStream os = (ByteArrayOutputStream)out;
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.setCipherValue(cv, os.toByteArray());
        }
        return et.getBase();
    }

    private void setCipherValue(CipherValue ciphVal, byte[] value) throws StructureException {
        Element e = ciphVal.getBase();
        ciphVal = new CipherValue();
        ciphVal.setValue(value);
        Element e2 = ciphVal.createElement(e.getOwnerDocument(), false);
        DOMUtil.removeChildNodes(e);
        DOMUtil.moveChildNodes(e2, e);
    }

    public Key generateKey() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
        this.fKey = this.getKeyGenerationEngine().generateKey();
        return this.fKey;
    }

    private KeyGenerationEngine getKeyGenerationEngine() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        EncryptionMethod em = this.fEncryptedTypeContainer.getEM();
        if (em == null) {
            throw new StructureException("EncryptionMethod element not specified");
        }
        if (this.fAlgorithmFactory == null) {
            throw new NullPointerException("Algorithm factory not specified");
        }
        KeyGenerationEngine engine = this.fAlgorithmFactory.getKeyGenerationEngine(em);
        if (this.fKeyGenParameters != null) {
            engine.init(this.fKeyGenParameters);
        }
        return engine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replace() throws StructureException {
        String s;
        if (this.fEncryptedType == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element obtained");
        }
        if (!(this.fData instanceof Element)) throw new RuntimeException("Instance of unknown class: " + this.fData.getClass().getName());
        Element e1 = (Element)this.fData;
        Document d = e1.getOwnerDocument();
        Element e2 = this.fEncryptedType;
        if (e2.getOwnerDocument() != d) {
            e2 = (Element)d.importNode(e2, true);
        }
        if ((s = this.fEncryptedTypeContainer.getType()).equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            DOMUtil.replaceNode((Node)e1, e2);
        } else {
            if (!s.equals("http://www.w3.org/2001/04/xmlenc#Content")) throw new StructureException("Unknown type: " + s);
            DOMUtil.replaceNodes(DOMUtil.getChildNodes(e1), e2);
        }
        this.fEncryptedType = e2;
    }
}

