/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

import com.ibm.xml.enc.EncryptionEngine;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class EncryptionInputStream
extends FilterInputStream {
    private EncryptionEngine fEncryptionEngine;
    private byte[] fBuffer;
    private int fIndex;
    private boolean fDoneFinal;

    public EncryptionInputStream(InputStream in, EncryptionEngine engine) {
        super(in);
        this.fEncryptionEngine = engine;
    }

    private byte[] getNextBytes() throws IOException {
        byte[] next = null;
        while (!this.fDoneFinal) {
            if (this.in == null) {
                throw new IOException("Input stream closed");
            }
            int b = super.read();
            if (this.fEncryptionEngine == null) {
                throw new NullPointerException("Encryption engine not specified");
            }
            byte[] o = null;
            if (b < 0) {
                try {
                    o = this.fEncryptionEngine.doFinal();
                }
                catch (BadPaddingException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
                catch (IllegalBlockSizeException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
                this.fDoneFinal = true;
            } else {
                o = this.fEncryptionEngine.update(new byte[]{(byte)b});
            }
            if (o == null || o.length <= 0) continue;
            next = o;
            break;
        }
        return next;
    }

    public int read() throws IOException {
        if (this.fBuffer == null || this.fIndex >= this.fBuffer.length) {
            this.fBuffer = this.getNextBytes();
            this.fIndex = 0;
        }
        int next = -1;
        if (this.fBuffer != null) {
            next = this.fBuffer[this.fIndex++] & 0xFF;
        }
        return next;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off >= b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c < 0) {
            return -1;
        }
        b[off] = (byte)c;
        int i = 1;
        try {
            while (i < len) {
                c = this.read();
                if (c >= 0) {
                    b[off + i] = (byte)c;
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return i;
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long remaining = n;
        byte[] b = new byte[2048];
        while (remaining > 0L) {
            int i = this.read(b, 0, (int)Math.min(2048L, remaining));
            if (i < 0) break;
            remaining -= (long)i;
        }
        return n - remaining;
    }

    public int available() throws IOException {
        return 0;
    }

    public boolean markSupported() {
        return false;
    }
}

