/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

import com.ibm.xml.enc.EncryptionEngine;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class EncryptionOutputStream
extends FilterOutputStream {
    private EncryptionEngine fEncryptionEngine;
    private boolean fDoneFinal;

    public EncryptionOutputStream(OutputStream out, EncryptionEngine engine) {
        super(out);
        this.fEncryptionEngine = engine;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void doFinal() throws IOException {
        this.doFinal(null);
    }

    public void doFinal(byte[] b) throws IOException {
        if (this.fEncryptionEngine == null) {
            throw new NullPointerException("Encryption engine not specified");
        }
        byte[] o = null;
        try {
            o = b != null ? this.fEncryptionEngine.doFinal(b) : this.fEncryptionEngine.doFinal();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        this.fDoneFinal = true;
        if (o != null && o.length > 0) {
            this.writeBytes(o);
        }
    }

    private void writeBytes(byte[] b) throws IOException {
        int i = 0;
        int l = b.length;
        while (i < l) {
            super.write(b[i]);
            ++i;
        }
    }

    public void write(int b) throws IOException {
        if (this.fEncryptionEngine == null) {
            throw new NullPointerException("Encryption engine not specified");
        }
        byte[] o = this.fEncryptionEngine.update(new byte[]{(byte)b});
        if (o != null && o.length > 0) {
            this.writeBytes(o);
        }
    }

    public void close() throws IOException {
        if (!this.fDoneFinal) {
            this.doFinal();
        }
        super.close();
    }
}

