/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

import com.ibm.xml.enc.type.EncryptionMethod;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class KeyGenerationEngine {
    public abstract EncryptionMethod getEncryptionMethod();

    public abstract Provider getProvider();

    public abstract void init(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    public abstract Key generateKey();

    public abstract Key generateKey(byte[] var1, String var2) throws InvalidKeyException;

    public abstract int getKeyLength(String var1);

    static class AES256
    extends AES {
        private static final int KEY_LENGTH = 32;

        AES256(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
            super(encMeth, provider);
            super.init(32);
        }

        public Key generateKey(byte[] keyMat, String type) throws InvalidKeyException {
            if (keyMat == null) {
                throw new NullPointerException("Key material not specified");
            }
            if (keyMat.length < 32) {
                throw new InvalidKeyException("Too short material");
            }
            return super.generateKey(new SecretKeySpec(keyMat, 0, 32, "AES"));
        }

        public int getKeyLength(String type) {
            return 32;
        }
    }

    static class AES192
    extends AES {
        private static final int KEY_LENGTH = 24;

        AES192(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
            super(encMeth, provider);
            super.init(24);
        }

        public Key generateKey(byte[] keyMat, String type) throws InvalidKeyException {
            if (keyMat == null) {
                throw new NullPointerException("Key material not specified");
            }
            if (keyMat.length < 24) {
                throw new InvalidKeyException("Too short material");
            }
            return super.generateKey(new SecretKeySpec(keyMat, 0, 24, "AES"));
        }

        public int getKeyLength(String type) {
            return 24;
        }
    }

    static class AES128
    extends AES {
        private static final int KEY_LENGTH = 16;

        AES128(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
            super(encMeth, provider);
            super.init(16);
        }

        public Key generateKey(byte[] keyMat, String type) throws InvalidKeyException {
            if (keyMat == null) {
                throw new NullPointerException("Key material not specified");
            }
            if (keyMat.length < 16) {
                throw new InvalidKeyException("Too short material");
            }
            return super.generateKey(new SecretKeySpec(keyMat, 0, 16, "AES"));
        }

        public int getKeyLength(String type) {
            return 16;
        }
    }

    static abstract class AES
    extends KeyGenerationEngine {
        static final String ALGORITHM = "AES";
        private EncryptionMethod fEncryptionMethod;
        private KeyGenerator fKeyGenerator;
        private SecretKeyFactory fKeyFactory;
        private boolean fUsingKeyGenerator;

        AES(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
            this.fEncryptionMethod = encMeth;
            if (provider != null) {
                this.fKeyGenerator = KeyGenerator.getInstance(ALGORITHM, provider);
                this.fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM, provider);
            } else {
                this.fKeyGenerator = KeyGenerator.getInstance(ALGORITHM);
                this.fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            }
            this.fUsingKeyGenerator = true;
        }

        void init(int keyLen) {
            this.fKeyGenerator.init(keyLen * 8);
            this.fUsingKeyGenerator = true;
        }

        Key generateKey(KeySpec keySpec) {
            SecretKey key = null;
            try {
                key = this.fKeyFactory.generateSecret(keySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                // empty catch block
            }
            this.fUsingKeyGenerator = false;
            return key;
        }

        public EncryptionMethod getEncryptionMethod() {
            return this.fEncryptionMethod;
        }

        public Provider getProvider() {
            Provider provider = null;
            provider = this.fUsingKeyGenerator ? this.fKeyGenerator.getProvider() : this.fKeyFactory.getProvider();
            return provider;
        }

        public void init(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            if (params != null) {
                this.fKeyGenerator.init(params);
            }
            this.fUsingKeyGenerator = true;
        }

        public Key generateKey() {
            SecretKey key = this.fKeyGenerator.generateKey();
            this.fUsingKeyGenerator = true;
            return key;
        }
    }

    static class TripleDES
    extends KeyGenerationEngine {
        private static final String ALGORITHM = "DESede";
        private static final int KEY_LENGTH = 24;
        private EncryptionMethod fEncryptionMethod;
        private static String fProvider;
        private static KeyGenerator fKeyGenerator;
        private static SecretKeyFactory fKeyFactory;
        private static boolean fUsingKeyGenerator;

        TripleDES(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
            this.fEncryptionMethod = encMeth;
            TripleDES._construct(provider);
        }

        private static synchronized void _construct(String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
            if (!(fKeyGenerator != null && (fProvider == null && provider == null || fProvider != null && fProvider.equals(provider) || fKeyGenerator.getProvider().getName().equals(provider)))) {
                fProvider = provider;
                if (provider != null) {
                    fKeyGenerator = KeyGenerator.getInstance(ALGORITHM, provider);
                    fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM, provider);
                } else {
                    fKeyGenerator = KeyGenerator.getInstance(ALGORITHM);
                    fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
                }
            }
            fUsingKeyGenerator = true;
        }

        private static synchronized Provider _getProvider() {
            Provider provider = null;
            provider = fUsingKeyGenerator ? fKeyGenerator.getProvider() : fKeyFactory.getProvider();
            return provider;
        }

        private static synchronized void _init(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            if (params != null) {
                fKeyGenerator.init(params);
            }
            fUsingKeyGenerator = true;
        }

        private static synchronized Key _generateKey() {
            SecretKey key = fKeyGenerator.generateKey();
            fUsingKeyGenerator = true;
            return key;
        }

        private static synchronized Key _generateKey(byte[] keyMat, String type) throws InvalidKeyException {
            SecretKey key = null;
            try {
                key = fKeyFactory.generateSecret(new DESedeKeySpec(keyMat));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                // empty catch block
            }
            fUsingKeyGenerator = false;
            return key;
        }

        public EncryptionMethod getEncryptionMethod() {
            return this.fEncryptionMethod;
        }

        public Provider getProvider() {
            return TripleDES._getProvider();
        }

        public void init(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            TripleDES._init(params);
        }

        public Key generateKey() {
            return TripleDES._generateKey();
        }

        public Key generateKey(byte[] keyMat, String type) throws InvalidKeyException {
            if (keyMat == null) {
                throw new NullPointerException("Key material not specified");
            }
            if (keyMat.length < 24) {
                throw new InvalidKeyException("Too short material");
            }
            return TripleDES._generateKey(keyMat, type);
        }

        public int getKeyLength(String type) {
            return 24;
        }
    }
}

