/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

import com.ibm.xml.dsig.IDResolver;
import com.ibm.xml.dsig.XSignatureException;
import com.ibm.xml.enc.AlgorithmFactoryExtn;
import com.ibm.xml.enc.DecryptionContext;
import com.ibm.xml.enc.EncryptedKeyRetriever;
import com.ibm.xml.enc.EncryptionContext;
import com.ibm.xml.enc.KeyInfoResolver;
import com.ibm.xml.enc.KeyInfoResolvingException;
import com.ibm.xml.enc.SignatureContextExtn;
import com.ibm.xml.enc.type.CarriedKeyName;
import com.ibm.xml.enc.type.EncryptedKey;
import com.ibm.xml.enc.type.EncryptionMethod;
import com.ibm.xml.enc.type.KeyInfo;
import com.ibm.xml.enc.type.KeyName;
import com.ibm.xml.enc.type.RetrievalMethod;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

public class KeyInfoResolverBase
implements KeyInfoResolver {
    protected boolean fInEncryptMode;
    private AlgorithmParameterSpec fKeyGenParameters;
    private AlgorithmFactoryExtn fAlgorithmFactory;
    private IDResolver fIdResolver;
    private EntityResolver fEntityResolver;
    private EncryptedKeyRetriever fEncryptedKeyRetriever;

    public void setKeyGenerationParameters(AlgorithmParameterSpec params) {
        this.fKeyGenParameters = params;
    }

    public void setAlgorithmFactory(AlgorithmFactoryExtn factory) {
        this.fAlgorithmFactory = factory;
    }

    public void setIdResolver(IDResolver resolver) {
        this.fIdResolver = resolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.fEntityResolver = resolver;
    }

    public void setEncryptedKeyRetriever(EncryptedKeyRetriever retriever) {
        this.fEncryptedKeyRetriever = retriever;
    }

    protected Key resolveEncryptedKey(EncryptedKey encKey, EncryptionMethod encMeth, Key key) throws KeyInfoResolvingException {
        if (this.fInEncryptMode) {
            EncryptionContext ec = new EncryptionContext();
            ec.setAlgorithmFactory(this.fAlgorithmFactory);
            if (key == null) {
                ec.setEncryptedType(null, null, encMeth, null);
                ec.setKeyGenerationParameters(this.fKeyGenParameters);
                try {
                    key = ec.generateKey();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ec.setKey(null);
            }
            ec.setData(key);
            ec.setEncryptedType(encKey, null, null, null);
            ec.setKeyInfoResolver(this);
            try {
                ec.encrypt();
            }
            catch (KeyInfoResolvingException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            DecryptionContext dc = new DecryptionContext();
            dc.setEncryptedType(encKey, null, null, null);
            dc.setEncryptionMethod(encMeth);
            dc.setAlgorithmFactory(this.fAlgorithmFactory);
            dc.setKeyInfoResolver(this);
            dc.setIdResolver(this.fIdResolver);
            dc.setEntityResolver(this.fEntityResolver);
            dc.setEncryptedKeyRetriever(this.fEncryptedKeyRetriever);
            try {
                dc.decrypt();
            }
            catch (KeyInfoResolvingException e) {
                throw e;
            }
            catch (Exception e) {
                Exception e2;
                if (e instanceof XSignatureException && (e2 = ((XSignatureException)e).getException()) != null) {
                    e = e2;
                }
                e.printStackTrace();
            }
            key = (Key)dc.getData();
        }
        return key;
    }

    protected Key resolveKeyName(KeyName keyName, EncryptionMethod encMeth, Key key) throws KeyInfoResolvingException {
        Element e;
        String s;
        if (!this.fInEncryptMode && (s = keyName.getName()) != null && (e = keyName.getBase().getOwnerDocument().getDocumentElement()) != null) {
            ArrayList l = new ArrayList();
            this.addEncryptedKeys(e, s, l);
            Iterator i = l.iterator();
            while (key == null && i.hasNext()) {
                key = this.resolveEncryptedKey((EncryptedKey)i.next(), encMeth, key);
            }
        }
        return key;
    }

    private void addEncryptedKeys(Node node, String name, List encKeys) {
        if (node.getNodeType() == 1 && EncryptedKey.isOfType((Element)node)) {
            this.addEncryptedKeys(new EncryptedKey((Element)node), name, encKeys);
        } else {
            Node n = node.getFirstChild();
            while (n != null) {
                this.addEncryptedKeys(n, name, encKeys);
                n = n.getNextSibling();
            }
        }
    }

    private void addEncryptedKeys(EncryptedKey encKey, String name, List encKeys) {
        KeyInfo ki;
        String s;
        CarriedKeyName kn = encKey.getCarriedKeyName();
        if (kn != null && (s = kn.getName()) != null && s.equals(name)) {
            encKeys.add(encKey);
        }
        if ((ki = encKey.getKeyInfo()) != null) {
            Iterator i = ki.getKeyIds().iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof EncryptedKey)) continue;
                this.addEncryptedKeys((EncryptedKey)o, name, encKeys);
            }
        }
    }

    protected Key resolveRetrievalMethod(RetrievalMethod retMeth, EncryptionMethod encMeth, Key key) throws KeyInfoResolvingException {
        if (!this.fInEncryptMode) {
            SignatureContextExtn sc = new SignatureContextExtn();
            sc.setAlgorithmFactory(this.fAlgorithmFactory);
            sc.setIDResolver(this.fIdResolver);
            sc.setEntityResolver(this.fEntityResolver);
            Object o = null;
            try {
                o = sc.retrieve(retMeth.getBase());
            }
            catch (Exception e) {
                Exception e2;
                if (e instanceof XSignatureException && (e2 = ((XSignatureException)e).getException()) != null) {
                    e = e2;
                }
                e.printStackTrace();
            }
            if (o instanceof EncryptedKey) {
                key = this.resolveEncryptedKey((EncryptedKey)o, encMeth, key);
            }
        }
        return key;
    }

    protected Key resolveKeyId(Element keyId, EncryptionMethod encMeth, Key key) throws KeyInfoResolvingException {
        return key;
    }

    public void setOperationMode(int opMode) {
        boolean b = false;
        switch (opMode) {
            case 1: {
                b = true;
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation mode: " + opMode);
            }
        }
        this.fInEncryptMode = b;
    }

    public Key resolve(KeyInfo keyInfo, EncryptionMethod encMeth) throws KeyInfoResolvingException {
        if (keyInfo == null) {
            throw new NullPointerException("KeyInfo not specified");
        }
        Key key = null;
        Iterator i = keyInfo.getKeyIds().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof EncryptedKey) {
                key = this.resolveEncryptedKey((EncryptedKey)o, encMeth, key);
            } else if (o instanceof KeyName) {
                key = this.resolveKeyName((KeyName)o, encMeth, key);
            } else if (o instanceof RetrievalMethod) {
                key = this.resolveRetrievalMethod((RetrievalMethod)o, encMeth, key);
            } else if (o instanceof Element) {
                key = this.resolveKeyId((Element)o, encMeth, key);
            }
            if (!this.fInEncryptMode && key != null) break;
        }
        return key;
    }
}

