/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

import com.ibm.xml.enc.TransformerFactoryExtn;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

class XMLWriter {
    private static final String ENTITIES1 = "<>\"'&";
    private static final String[] ENTITY_NAMES = new String[]{"lt", "gt", "quot", "apos", "amp"};
    private static final String[] ENTITY_REFS = new String[]{"&lt;", "&gt;", "&amp;"};
    private static final String ENTITIES2 = "<>&";
    private Writer fOut;
    private Transformer fTransformer;

    XMLWriter(OutputStream out) throws IOException {
        this.fOut = new OutputStreamWriter(out, "UTF8");
    }

    void printText(String text) throws IOException {
        this.fOut.write(text);
    }

    void printText(char ch) throws IOException {
        this.fOut.write(ch);
    }

    void printText(DocumentFragment frag) throws IOException {
        this.printText(frag, true);
    }

    void printText(DocumentFragment frag, boolean replaced) throws IOException {
        Writer w = this.fOut;
        if (!replaced) {
            w = new StringWriter();
        }
        this.printText(frag, w);
        if (!replaced) {
            w.flush();
            w.close();
            String s = ((StringWriter)w).toString();
            s = this.restoreEntities(s);
            this.fOut.write(s);
        }
    }

    private void printText(DocumentFragment frag, Writer writer) throws IOException {
        if (this.fTransformer == null) {
            try {
                this.fTransformer = TransformerFactoryExtn.getTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(this.unwrapException(e).toString());
            }
        }
        DOMSource ds = new DOMSource();
        StreamResult r = new StreamResult(writer);
        Node n = frag.getFirstChild();
        while (n != null) {
            ds.setNode(n);
            try {
                this.fTransformer.transform(ds, r);
            }
            catch (TransformerException e) {
                Throwable t = this.unwrapException(e);
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new RuntimeException(t.toString());
            }
            n = n.getNextSibling();
        }
    }

    private Throwable unwrapException(TransformerException exc) {
        Throwable thr = exc.getException();
        if (thr == null) {
            thr = exc;
        }
        return thr;
    }

    private String restoreEntities(String text) {
        int i = 0;
        while (i < ENTITY_REFS.length) {
            text = this.restoreEntity(text, ENTITY_REFS[i], ENTITIES2.charAt(i));
            ++i;
        }
        return text;
    }

    private String restoreEntity(String text, String ref, char entity) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int tl = text.length();
        int rl = ref.length();
        while (i < tl) {
            int j = text.indexOf(ref, i);
            if (j >= 0) {
                sb.append(text.substring(i, j));
                sb.append(entity);
                i = j + rl;
            } else {
                sb.append(text.substring(i));
                i = tl;
            }
            ++i;
        }
        return sb.toString();
    }

    void printDoctypeURL(String url) throws IOException {
        this.printText('\"');
        int i = 0;
        int l = url.length();
        while (i < l) {
            if (url.charAt(i) == '\"' || url.charAt(i) < ' ' || url.charAt(i) > '\u007f') {
                this.printText('%');
                this.printText(Integer.toHexString(url.charAt(i)));
            } else {
                this.printText(url.charAt(i));
            }
            ++i;
        }
        this.printText('\"');
    }

    void printEscaped(String source) throws IOException {
        int i = 0;
        int l = source.length();
        while (i < l) {
            char lowch;
            int ch = source.charAt(i);
            if ((ch & 0xFC00) == 55296 && i + 1 < l && ((lowch = source.charAt(i + 1)) & 0xFC00) == 56320) {
                ch = 65536 + (ch - 55296 << 10) + lowch - 56320;
                ++i;
            }
            this.printEscaped(ch);
            ++i;
        }
    }

    private void printEscaped(int ch) throws IOException {
        String charRef = this.getEntityRef(ch);
        if (charRef != null) {
            this.printText('&');
            this.printText(charRef);
            this.printText(';');
        } else if (ch >= 32 && ch <= 0x10FFFF && ch != 247 || ch == 10 || ch == 13 || ch == 9) {
            if (ch < 65536) {
                this.printText((char)ch);
            } else {
                this.printText((char)((ch - 65536 >> 10) + 55296));
                this.printText((char)((ch - 65536 & 0x3FF) + 56320));
            }
        } else {
            this.printText("&#x");
            this.printText(Integer.toHexString(ch));
            this.printText(';');
        }
    }

    private String getEntityRef(int ch) {
        int i = ENTITIES1.indexOf(ch);
        String ref = null;
        if (i >= 0) {
            ref = ENTITY_NAMES[i];
        }
        return ref;
    }

    void flush() throws IOException {
        this.fOut.flush();
    }
}

