/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.CipherReference;
import com.ibm.xml.enc.type.CipherValue;
import com.ibm.xml.enc.type.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CipherData
extends Type {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "CipherData";
    private Type fCipherData;

    public CipherData() {
        this(null);
    }

    public CipherData(Element ciphData) {
        super(ciphData);
        if (ciphData != null) {
            if (!CipherData.isOfType(ciphData)) {
                throw new IllegalArgumentException("Not CipherData element");
            }
            this.init(ciphData);
        }
    }

    public static boolean isOfType(Element elem) {
        return elem != null && NAMESPACE.equals(elem.getNamespaceURI()) && NAME.equals(elem.getLocalName());
    }

    private void init(Node node) {
        Node n = node.getFirstChild();
        while (n != null) {
            switch (n.getNodeType()) {
                case 1: {
                    Element e = (Element)n;
                    if (CipherValue.isOfType(e)) {
                        this.fCipherData = new CipherValue(e);
                        break;
                    }
                    if (!CipherReference.isOfType(e)) break;
                    this.fCipherData = new CipherReference(e);
                    break;
                }
                case 5: {
                    this.init(n);
                }
            }
            n = n.getNextSibling();
        }
    }

    public void setCipherValue(CipherValue ciphVal) {
        this.fCipherData = ciphVal;
    }

    public void setCipherReference(CipherReference ciphRef) {
        this.fCipherData = ciphRef;
    }

    public Type getCipherData() {
        return this.fCipherData;
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document factory, boolean withNsDecl) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element ciphData = factory.createElementNS(NAMESPACE, NAME);
        if (withNsDecl) {
            ciphData.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fCipherData == null) {
            throw new StructureException("Neither CipherValue nor CipherReference specified");
        }
        Element e = this.fCipherData.createElement(factory, false);
        ciphData.appendChild(e);
        return ciphData;
    }
}

