/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.Base64BinaryType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CipherValue
extends Base64BinaryType {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "CipherValue";

    public CipherValue() {
        this(null);
    }

    public CipherValue(Element ciphVal) {
        super(ciphVal);
        if (ciphVal != null && !CipherValue.isOfType(ciphVal)) {
            throw new IllegalArgumentException("Not CipherValue element");
        }
    }

    public static boolean isOfType(Element elem) {
        return elem != null && NAMESPACE.equals(elem.getNamespaceURI()) && NAME.equals(elem.getLocalName());
    }

    public void setValue(byte[] value) {
        super.setValue(value);
    }

    public byte[] getValue() {
        return super.getValue();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document factory, boolean withNsDecl) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element ciphVal = factory.createElementNS(NAMESPACE, NAME);
        if (withNsDecl) {
            ciphVal.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        super.createElement(ciphVal, factory);
        return ciphVal;
    }
}

