/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.CipherData;
import com.ibm.xml.enc.type.EncryptedData;
import com.ibm.xml.enc.type.EncryptedKey;
import com.ibm.xml.enc.type.EncryptionMethod;
import com.ibm.xml.enc.type.EncryptionProperties;
import com.ibm.xml.enc.type.KeyInfo;
import com.ibm.xml.enc.type.Type;
import com.ibm.xml.enc.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class EncryptedType
extends Type {
    private static final String ATTR_ID = "Id";
    private static final String ATTR_TYPE = "Type";
    private static final String ATTR_MIME_TYPE = "MimeType";
    private static final String ATTR_ENCODING = "Encoding";
    private String fId;
    private String fType;
    private String fMimeType;
    private String fEncoding;
    private EncryptionMethod fEncryptionMethod;
    private KeyInfo fKeyInfo;
    private CipherData fCipherData;
    private EncryptionProperties fEncryptionProperties;

    public EncryptedType(Element encType) {
        super(encType);
        if (encType != null) {
            if (encType.hasAttribute(ATTR_ID)) {
                this.fId = encType.getAttribute(ATTR_ID);
            }
            if (encType.hasAttribute(ATTR_TYPE)) {
                this.fType = encType.getAttribute(ATTR_TYPE);
            }
            if (encType.hasAttribute(ATTR_MIME_TYPE)) {
                this.fMimeType = encType.getAttribute(ATTR_MIME_TYPE);
            }
            if (encType.hasAttribute(ATTR_ENCODING)) {
                this.fEncoding = encType.getAttribute(ATTR_ENCODING);
            }
            this.init(encType);
        }
    }

    public static EncryptedType getInstance(Element encType) {
        if (encType == null) {
            throw new NullPointerException("Element not specified");
        }
        EncryptedType encType2 = null;
        if (EncryptedData.isOfType(encType)) {
            encType2 = new EncryptedData(encType);
        } else if (EncryptedKey.isOfType(encType)) {
            encType2 = new EncryptedKey(encType);
        } else {
            throw new IllegalArgumentException("Unknown element type: " + encType.getTagName());
        }
        return encType2;
    }

    private void init(Node node) {
        Node n = node.getFirstChild();
        while (n != null) {
            switch (n.getNodeType()) {
                case 1: {
                    Element e = (Element)n;
                    if (EncryptionMethod.isOfType(e)) {
                        this.fEncryptionMethod = new EncryptionMethod(e);
                        break;
                    }
                    if (KeyInfo.isOfType(e)) {
                        this.fKeyInfo = new KeyInfo(e);
                        break;
                    }
                    if (CipherData.isOfType(e)) {
                        this.fCipherData = new CipherData(e);
                        break;
                    }
                    if (!EncryptionProperties.isOfType(e)) break;
                    this.fEncryptionProperties = new EncryptionProperties(e);
                    break;
                }
                case 5: {
                    this.init(n);
                }
            }
            n = n.getNextSibling();
        }
    }

    public void setId(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public void setType(String uri) {
        this.fType = uri;
    }

    public String getType() {
        return this.fType;
    }

    public void setMimeType(String mimeType) {
        this.fMimeType = mimeType;
    }

    public String getMimeType() {
        return this.fMimeType;
    }

    public void setEncoding(String encoding) {
        this.fEncoding = encoding;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncryptionMethod(EncryptionMethod encMeth) {
        this.fEncryptionMethod = encMeth;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.fEncryptionMethod;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.fKeyInfo = keyInfo;
    }

    public KeyInfo getKeyInfo() {
        return this.fKeyInfo;
    }

    public void setCipherData(CipherData ciphData) {
        this.fCipherData = ciphData;
    }

    public CipherData getCipherData() {
        return this.fCipherData;
    }

    public void setEncryptionProperties(EncryptionProperties encProps) {
        this.fEncryptionProperties = encProps;
    }

    public EncryptionProperties getEncryptionProperties() {
        return this.fEncryptionProperties;
    }

    void createElement(Element encType, Document factory) throws StructureException {
        Element e;
        if (this.fId != null) {
            encType.setAttribute(ATTR_ID, Util.normalize(this.fId));
        }
        if (this.fType != null) {
            encType.setAttribute(ATTR_TYPE, Util.normalize(this.fType));
        }
        if (this.fMimeType != null) {
            encType.setAttribute(ATTR_MIME_TYPE, Util.normalize(this.fMimeType));
        }
        if (this.fEncoding != null) {
            encType.setAttribute(ATTR_ENCODING, Util.normalize(this.fEncoding));
        }
        if (this.fEncryptionMethod != null) {
            e = this.fEncryptionMethod.createElement(factory, false);
            encType.appendChild(e);
        }
        if (this.fKeyInfo != null) {
            e = this.fKeyInfo.createElement(factory, true);
            encType.appendChild(e);
        }
        if (this.fCipherData == null) {
            throw new StructureException("CipherData not specified");
        }
        e = this.fCipherData.createElement(factory, false);
        encType.appendChild(e);
        if (this.fEncryptionProperties != null) {
            e = this.fEncryptionProperties.createElement(factory, false);
            encType.appendChild(e);
        }
    }
}

