/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.ElementsType;
import com.ibm.xml.enc.type.KeySize;
import com.ibm.xml.enc.type.OAEPParams;
import com.ibm.xml.enc.util.Util;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptionMethod
extends ElementsType {
    public static final String TRIPLEDES_CBC = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES128_CBC = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES192_CBC = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String AES256_CBC = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String RSA_1_5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String RSA_OAEP = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    public static final String KW_TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String KW_AES128 = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String KW_AES192 = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String KW_AES256 = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "EncryptionMethod";
    private static final String ATTR_ALGORITHM = "Algorithm";
    private String fAlgorithm;
    private KeySize fKeySize;
    private OAEPParams fOaepParams;

    public EncryptionMethod() {
        this(null);
    }

    public EncryptionMethod(Element encMeth) {
        super(encMeth);
        if (encMeth != null) {
            if (!EncryptionMethod.isOfType(encMeth)) {
                throw new IllegalArgumentException("Not EncryptionMethod element");
            }
            if (encMeth.hasAttribute(ATTR_ALGORITHM)) {
                this.fAlgorithm = encMeth.getAttribute(ATTR_ALGORITHM);
            }
            this.init(encMeth);
        }
    }

    public static boolean isOfType(Element elem) {
        return elem != null && NAMESPACE.equals(elem.getNamespaceURI()) && NAME.equals(elem.getLocalName());
    }

    private void init(Node node) {
        Node n = node.getFirstChild();
        while (n != null) {
            switch (n.getNodeType()) {
                case 1: {
                    Element e = (Element)n;
                    if (KeySize.isOfType(e)) {
                        this.fKeySize = new KeySize(e);
                        break;
                    }
                    if (OAEPParams.isOfType(e)) {
                        this.fOaepParams = new OAEPParams(e);
                        break;
                    }
                    if (!this.isParameter(e)) break;
                    super.addElement(e);
                    break;
                }
                case 5: {
                    this.init(n);
                }
            }
            n = n.getNextSibling();
        }
    }

    private boolean isParameter(Element elem) {
        String s = elem.getNamespaceURI();
        return s != null && !s.equals(NAMESPACE);
    }

    public void setAlgorithm(String uri) {
        this.fAlgorithm = uri;
    }

    public String getAlgorithm() {
        return this.fAlgorithm;
    }

    public void setKeySize(KeySize keySize) {
        this.fKeySize = keySize;
    }

    public KeySize getKeySize() {
        return this.fKeySize;
    }

    public void setOAEPParams(OAEPParams oaepParams) {
        this.fOaepParams = oaepParams;
    }

    public OAEPParams getOAEPParams() {
        return this.fOaepParams;
    }

    public void addParameter(Element param) {
        if (param != null) {
            if (!this.isParameter(param)) {
                throw new IllegalArgumentException("Wrong parameter");
            }
            super.addElement(param);
        }
    }

    public List getParameters() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document factory, boolean withNsDecl) throws StructureException {
        Element e;
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element encMeth = factory.createElementNS(NAMESPACE, NAME);
        if (withNsDecl) {
            encMeth.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fAlgorithm == null) {
            throw new StructureException("Algorithm not specified");
        }
        encMeth.setAttribute(ATTR_ALGORITHM, Util.normalize(this.fAlgorithm));
        if (this.fKeySize != null) {
            e = this.fKeySize.createElement(factory, false);
            encMeth.appendChild(e);
        }
        if (this.fOaepParams != null) {
            e = this.fOaepParams.createElement(factory, false);
            encMeth.appendChild(e);
        }
        super.createElement(encMeth, factory, NAMESPACE);
        return encMeth;
    }
}

