/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.DataReference;
import com.ibm.xml.enc.type.ElementsType;
import com.ibm.xml.enc.type.KeyReference;
import com.ibm.xml.enc.type.ReferenceType;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReferenceList
extends ElementsType {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "ReferenceList";

    public ReferenceList() {
        this(null);
    }

    public ReferenceList(Element refList) {
        super(refList);
        if (refList != null) {
            if (!ReferenceList.isOfType(refList)) {
                throw new IllegalArgumentException("Not ReferenceList element");
            }
            this.init(refList);
        }
    }

    public static boolean isOfType(Element elem) {
        return elem != null && NAMESPACE.equals(elem.getNamespaceURI()) && NAME.equals(elem.getLocalName());
    }

    private void init(Node node) {
        Node n = node.getFirstChild();
        while (n != null) {
            switch (n.getNodeType()) {
                case 1: {
                    Element e = (Element)n;
                    ReferenceType o = null;
                    if (DataReference.isOfType(e)) {
                        o = new DataReference(e);
                    } else if (KeyReference.isOfType(e)) {
                        o = new KeyReference(e);
                    }
                    super.addElement(o);
                    break;
                }
                case 5: {
                    this.init(n);
                }
            }
            n = n.getNextSibling();
        }
    }

    public void addDataReference(DataReference dataRef) {
        super.addElement(dataRef);
    }

    public void addKeyReference(KeyReference keyRef) {
        super.addElement(keyRef);
    }

    public List getReferences() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document factory, boolean withNsDecl) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element refList = factory.createElementNS(NAMESPACE, NAME);
        if (withNsDecl) {
            refList.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fElements.isEmpty()) {
            throw new StructureException("References not specified");
        }
        super.createElement(refList, factory, NAMESPACE);
        return refList;
    }
}

