/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.ElementsType;
import com.ibm.xml.enc.util.Util;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ReferenceType
extends ElementsType {
    private static final String ATTR_URI = "URI";
    private String fUri;

    public ReferenceType(Element refType) {
        super(refType);
        if (refType != null) {
            if (refType.hasAttribute(ATTR_URI)) {
                this.fUri = refType.getAttribute(ATTR_URI);
            }
            this.init(refType);
        }
    }

    private void init(Node node) {
        Node n = node.getFirstChild();
        while (n != null) {
            switch (n.getNodeType()) {
                case 1: {
                    Element e = (Element)n;
                    if (!this.isParameter(e)) break;
                    super.addElement(e);
                    break;
                }
                case 5: {
                    this.init(n);
                }
            }
            n = n.getNextSibling();
        }
    }

    abstract boolean isParameter(Element var1);

    public void setURI(String uri) {
        this.fUri = uri;
    }

    public String getURI() {
        return this.fUri;
    }

    public void addParameter(Element param) {
        if (param != null) {
            if (!this.isParameter(param)) {
                throw new IllegalArgumentException("Wrong parameter");
            }
            super.addElement(param);
        }
    }

    public List getParameters() {
        return super.getElements();
    }

    void createElement(Element refType, Document factory, String namespace) throws StructureException {
        if (this.fUri == null) {
            throw new StructureException("URI not specified");
        }
        refType.setAttribute(ATTR_URI, Util.normalize(this.fUri));
        super.createElement(refType, factory, namespace);
    }
}

