/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.DsTransforms;
import com.ibm.xml.enc.type.Type;
import com.ibm.xml.enc.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RetrievalMethod
extends Type {
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "RetrievalMethod";
    private static final String ATTR_URI = "URI";
    private static final String ATTR_TYPE = "Type";
    private String fUri;
    private String fType;
    private DsTransforms fTransforms;

    public RetrievalMethod() {
        this(null);
    }

    public RetrievalMethod(Element retMeth) {
        super(retMeth);
        if (retMeth != null) {
            if (!RetrievalMethod.isOfType(retMeth)) {
                throw new IllegalArgumentException("Not RetrievalMethod element");
            }
            if (retMeth.hasAttribute(ATTR_URI)) {
                this.fUri = retMeth.getAttribute(ATTR_URI);
            }
            if (retMeth.hasAttribute(ATTR_TYPE)) {
                this.fType = retMeth.getAttribute(ATTR_TYPE);
            }
            this.init(retMeth);
        }
    }

    public static boolean isOfType(Element elem) {
        return elem != null && NAMESPACE.equals(elem.getNamespaceURI()) && NAME.equals(elem.getLocalName());
    }

    private void init(Node node) {
        Node n = node.getFirstChild();
        while (n != null) {
            switch (n.getNodeType()) {
                case 1: {
                    Element e = (Element)n;
                    if (!DsTransforms.isOfType(e)) break;
                    this.fTransforms = new DsTransforms(e);
                    break;
                }
                case 5: {
                    this.init(n);
                }
            }
            n = n.getNextSibling();
        }
    }

    public void setURI(String uri) {
        this.fUri = uri;
    }

    public String getURI() {
        return this.fUri;
    }

    public void setType(String type) {
        this.fType = type;
    }

    public String getType() {
        return this.fType;
    }

    public void setTransforms(DsTransforms transs) {
        this.fTransforms = transs;
    }

    public DsTransforms getTransforms() {
        return this.fTransforms;
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document factory, boolean withNsDecl) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element retMeth = factory.createElementNS(NAMESPACE, NAME);
        if (withNsDecl) {
            retMeth.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fUri == null) {
            throw new StructureException("URI not specified");
        }
        retMeth.setAttribute(ATTR_URI, Util.normalize(this.fUri));
        if (this.fType != null) {
            retMeth.setAttribute(ATTR_TYPE, Util.normalize(this.fType));
        }
        if (this.fTransforms != null) {
            Element e = this.fTransforms.createElement(factory, false);
            retMeth.appendChild(e);
        }
        return retMeth;
    }
}

