/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.util;

import com.ibm.dom.util.XPathCanonicalizer;
import com.ibm.xml.enc.DOMSerializationEngine;
import com.ibm.xml.enc.util.DOMUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DOMCanonicalizationEngine
extends DOMSerializationEngine {

    public static class XMLElement
    extends XMLContent {
        public XMLElement(boolean withComments) {
            super(withComments);
        }

        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Element";
        }

        public void serialize(NodeList nodeList) throws IOException {
            if (nodeList != null) {
                Element n = DOMUtil.getFirstElement(nodeList);
                DOMUtil.NodeListImpl nl = new DOMUtil.NodeListImpl();
                if (n != null) {
                    nl.add(n);
                }
                nodeList = nl;
            }
            super.serialize(nodeList);
        }
    }

    public static class XMLContent
    extends DOMCanonicalizationEngine {
        private boolean fWithComments;
        private OutputStream fOut;

        public XMLContent(boolean withComments) {
            this.fWithComments = withComments;
        }

        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Content";
        }

        public void setOutputStream(OutputStream out) {
            this.fOut = out;
        }

        public void serialize(NodeList nodeList) throws IOException {
            if (nodeList != null) {
                OutputStreamWriter w = new OutputStreamWriter(this.fOut, "UTF-8");
                int i = 0;
                int l = nodeList.getLength();
                while (i < l) {
                    XPathCanonicalizer.serializeSubset((Node)nodeList.item(i), (boolean)this.fWithComments, (Writer)w);
                    ++i;
                }
            }
        }
    }
}

