/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs;

import com.ibm.disthub.client.JMS;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.drs.DRSAPI;
import com.ibm.ws.drs.DRSBuffWrapper;
import com.ibm.ws.drs.DRSCacheMsg;
import com.ibm.ws.drs.DRSCacheMsgListener;
import com.ibm.ws.drs.DRSCloseJMS;
import com.ibm.ws.drs.DRSCrypto;
import com.ibm.ws.drs.DRSDataXfer;
import com.ibm.ws.drs.DRSEntryPartitionException;
import com.ibm.ws.drs.DRSEventListener;
import com.ibm.ws.drs.DRSInitJMSClient;
import com.ibm.ws.drs.DRSJMS;
import com.ibm.ws.drs.DRSJMSResources;
import com.ibm.ws.drs.DRSLaunch;
import com.ibm.ws.drs.DRSPeerCoordinator;
import com.ibm.ws.drs.DRSPools;
import com.ibm.ws.drs.DRSResetJMS;
import com.ibm.ws.drs.DRSSecurity;
import com.ibm.ws.drs.DRSUtils;
import com.ibm.ws.drs.JMSSessPoolWrapper;
import com.ibm.ws.drs.JMSTopicPoolWrapper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.ThreadPool;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class DRSCacheApp
extends HttpServlet
implements MessageListener,
DRSDataXfer {
    static TraceComponent tc = Tr.register((class$com$ibm$ws$drs$DRSCacheApp == null ? (class$com$ibm$ws$drs$DRSCacheApp = DRSCacheApp.class$("com.ibm.ws.drs.DRSCacheApp")) : class$com$ibm$ws$drs$DRSCacheApp).getName(), "IBM WAS DRS Cache App", "com.ibm.ws.drs.drs");
    public NLS rb = null;
    DRSInitJMSClient drsIJC = null;
    DRSCloseJMS drsCJ = null;
    DRSResetJMS drsRJ = null;
    DRSUtils drsU = null;
    DRSAPI drsA = null;
    DRSJMS drsJ = null;
    DRSSecurity drsSec = null;
    protected TopicConnectionFactory factory = null;
    protected static String className = "com.ibm.ws.drs.DRSCacheApp.";
    protected static String factoryClassName = "com.ibm.ws.drs.factory";
    protected static String factoryMethodName = "createTopicConnectionFactory";
    protected static String factoryNameSpaceName = null;
    protected String authId = null;
    protected String passwd = null;
    protected Topic cacheUpdateTopic = null;
    protected Topic cacheAccessTopic = null;
    protected Topic controlTopic = null;
    protected String updTopicName = "update";
    protected String accTopicName = "access";
    protected String partTopicName = "partitions";
    protected String controlTopicName = null;
    public String dcaName = "DRSCacheApp";
    protected JMSSessPoolWrapper updJSPW = null;
    protected JMSSessPoolWrapper accJSPW = null;
    protected DRSCrypto crypto = null;
    protected SecretKey key = null;
    protected String keyString = null;
    protected boolean doEncrypt = false;
    protected boolean do3DES = false;
    public Vector otherHosts = null;
    public boolean localBroker = true;
    public Object broker = null;
    protected Vector listeners = null;
    public String replicatorNameForJMSPoolKey;
    public String domainNameForJMSPoolKey;
    protected static HashMap drsJMSResources = new HashMap();
    protected DRSPools drsPools = null;
    protected boolean drsPoolsInitted = false;
    protected static boolean appServerIsShuttingDown = false;
    protected LinkedList updJMSPool = null;
    protected LinkedList updJMSPoolReferences = null;
    protected final Object updJMSPoolMutex = new Object();
    protected LinkedList accJMSPool = null;
    protected LinkedList accJMSPoolReferences = null;
    protected final Object accJMSPoolMutex = new Object();
    protected LinkedList updSubPool = null;
    protected LinkedList accSubPool = null;
    protected short poolsize = (short)10;
    protected boolean poolCons = false;
    protected short dcmPoolSize = (short)1000;
    protected LinkedList dcmPool = null;
    protected LinkedList dbwPool = null;
    private static final String cntType = "text/html";
    protected static HashMap jmsSvrs = new HashMap();
    protected static HashMap drsInsts = new HashMap();
    protected long instanceID;
    protected HashMap otherDRSInstancesGroups = null;
    protected HashMap groupDRSInstances = null;
    protected HashMap otherDRSInstancesTempTopics = null;
    protected ArrayList otherDRSInstanceIDs = null;
    protected ArrayList otherDRSServerInstances = null;
    protected HashMap otherDRSInstanceMsgTimestamps = null;
    protected String localHost = null;
    private HashMap otherDRSLocalHosts = null;
    private HashMap otherDRSTopicCounts = null;
    protected TemporaryTopic instanceTempTopic;
    protected TopicSubscriber instanceTempTopicSub;
    protected TopicSubscriber controlSub;
    protected DRSPeerCoordinator drsPC;
    public String hostName = null;
    protected boolean jmsUp = false;
    protected boolean cleanUpFailed = false;
    protected long cleanUpFailedTime = 0L;
    protected long recoveryTime = 0L;
    public long onExceptionTime = 0L;
    public int recoveryCount = 0;
    protected long requestTO = 2000L;
    protected boolean partitionOnEntry = false;
    protected short partitionSize = (short)10;
    protected short partitionId = 0;
    protected boolean partialPartSet = false;
    protected boolean othersPartialPartSet = false;
    protected HashMap otherUpdPartitionIds;
    protected HashMap otherAccPartitionIds;
    protected ArrayList freePartialPartSet;
    protected boolean reverseEntryPart = false;
    protected int entryCnt = 0;
    protected String updPartTopicName = null;
    protected String accPartTopicName = null;
    protected int msgCnt = 0;
    protected HashMap tempTopics = null;
    protected HashMap key2DRSInst = null;
    private HashMap key2OtherDRSInst = null;
    protected HashMap key2TempTopic = null;
    protected HashMap entryParts = null;
    protected HashMap partTopics = null;
    protected HashMap otherEntryParts = null;
    protected HashMap entryPartsBcasted = null;
    protected boolean clientOnly = false;
    protected boolean serverOnly = false;
    protected boolean brokerOnly = false;
    protected boolean entrybytesvsobjs = false;
    protected boolean propsbytesvsobjs = false;
    protected boolean debug = false;
    protected TopicSubscriber updPartSub = null;
    protected TopicSubscriber accPartSub = null;
    protected JMSTopicPoolWrapper updJTPW = null;
    protected JMSTopicPoolWrapper accJTPW = null;
    protected LinkedList updJTPWPool = null;
    protected LinkedList accJTPWPool = null;
    protected LinkedList drsListeners = null;
    private static ThreadPool _threadPool = null;
    public static boolean disthubParametersHaveBeenSet = false;
    static /* synthetic */ Class class$com$ibm$ws$drs$DRSCacheApp;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initVars() {
        String string = this.dcaName + "/initVars: ";
        this.instanceID = System.currentTimeMillis() + (long)this.hashCode();
        if (!disthubParametersHaveBeenSet) {
            JMS.setParameter((String)"MAX_MESSAGE_SIZE", (String)"2000000");
            JMS.setParameter((String)"PING_TIMEOUT_MULTIPLE", (String)"5");
            JMS.setParameter((String)"MAX_CLIENT_QUEUE_SIZE", (String)"2000000");
            JMS.setParameter((String)"MAX_BROKER_QUEUE_SIZE", (String)"2000000");
            disthubParametersHaveBeenSet = true;
        }
        Serializable serializable = drsInsts;
        synchronized (serializable) {
            drsInsts.put(new Long(this.instanceID), this);
        }
        this.otherDRSInstancesGroups = new HashMap();
        this.groupDRSInstances = new HashMap();
        this.otherDRSInstancesTempTopics = new HashMap();
        this.otherDRSInstanceIDs = new ArrayList();
        this.otherDRSServerInstances = new ArrayList();
        this.otherDRSInstanceMsgTimestamps = new HashMap();
        try {
            this.localHost = InetAddress.getLocalHost().toString();
        }
        catch (Exception exception) {
            this.localHost = "UNKNOWN_LOCAL_HOST_" + this.instanceID;
        }
        this.otherDRSLocalHosts = new HashMap();
        this.otherDRSTopicCounts = new HashMap();
        this.listeners = new Vector();
        this.otherHosts = new Vector();
        this.tempTopics = new HashMap();
        this.key2TempTopic = new HashMap();
        this.key2DRSInst = new HashMap();
        this.key2OtherDRSInst = new HashMap();
        this.entryParts = new HashMap();
        this.partTopics = new HashMap();
        this.otherUpdPartitionIds = new HashMap();
        this.otherAccPartitionIds = new HashMap();
        this.freePartialPartSet = new ArrayList();
        this.otherEntryParts = new HashMap();
        this.entryPartsBcasted = new HashMap();
        this.updSubPool = new LinkedList();
        this.accSubPool = new LinkedList();
        this.dcmPool = new LinkedList();
        this.dbwPool = new LinkedList();
        this.updJMSPool = new LinkedList();
        this.updJMSPoolReferences = new LinkedList();
        this.accJMSPool = new LinkedList();
        this.accJMSPoolReferences = new LinkedList();
        this.updJTPWPool = new LinkedList();
        this.accJTPWPool = new LinkedList();
        this.drsListeners = new LinkedList();
        serializable = class$com$ibm$ws$drs$DRSCacheApp == null ? (class$com$ibm$ws$drs$DRSCacheApp = DRSCacheApp.class$("com.ibm.ws.drs.DRSCacheApp")) : class$com$ibm$ws$drs$DRSCacheApp;
        synchronized (serializable) {
            if (this.drsPools == null) {
                this.drsPools = new DRSPools(this);
            }
        }
        this.drsIJC = new DRSInitJMSClient(this);
        this.drsCJ = new DRSCloseJMS(this);
        this.drsRJ = new DRSResetJMS(this);
        this.drsU = new DRSUtils(this);
        this.drsA = new DRSAPI(this);
        this.drsJ = new DRSJMS(this);
        this.drsSec = new DRSSecurity(this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created DRS instance: dcaName:" + this.dcaName + " instanceId:" + this.instanceID);
        }
    }

    protected void launchDRS(Properties properties) {
        DRSLaunch dRSLaunch = new DRSLaunch(this);
        dRSLaunch.launchDRS(properties);
        this.drsPC = new DRSPeerCoordinator(this);
        if (this.clientOnly) {
            this.pingPeers();
        }
    }

    protected void pingPeers() {
        try {
            this.drsPC.pingPeers();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "pingPeers"), (String)"1", (Object)this);
            Tr.error(tc, "drs.throwable", throwable);
        }
    }

    protected void sendLocalData(Message message) throws JMSException {
        this.drsA.sendLocalData(message);
    }

    protected void sendOutEntryParts(Topic topic) throws JMSException {
        this.drsA.sendOutEntryParts(topic);
    }

    protected void getNewEntryPartition(Object object) {
        this.drsA.getNewEntryPartition(object);
    }

    protected TopicConnection getConn() throws JMSException {
        if (this.authId != null && this.passwd != null) {
            return this.factory.createTopicConnection(this.authId, this.passwd);
        }
        return this.factory.createTopicConnection();
    }

    protected void createUpdateTopic(String string) {
        try {
            this.drsIJC.createUpdateTopic(string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "createUpdateTopic"), (String)"2", (Object)this);
        }
    }

    protected void createAccessTopic(String string) {
        try {
            this.drsIJC.createAccessTopic(string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "createAccessTopic"), (String)"3", (Object)this);
        }
    }

    protected DRSCacheMsg getDCMPool() {
        try {
            return this.drsPools.getDCMPool();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "getDCMPool"), (String)"5", (Object)this);
            return new DRSCacheMsg();
        }
    }

    protected DRSBuffWrapper getDBWPool() {
        try {
            return this.drsPools.getDBWPool();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "getDBWPool"), (String)"6", (Object)this);
            return new DRSBuffWrapper();
        }
    }

    protected void retDCMPool(DRSCacheMsg dRSCacheMsg) {
        this.drsPools.retDCMPool(dRSCacheMsg);
    }

    protected void retDBWPool(DRSBuffWrapper dRSBuffWrapper) {
        this.drsPools.retDBWPool(dRSBuffWrapper);
    }

    protected JMSSessPoolWrapper getAccJMS() {
        try {
            JMSSessPoolWrapper jMSSessPoolWrapper = this.drsPools.getAccJMS();
            jMSSessPoolWrapper.recLvl = this.recoveryCount;
            return jMSSessPoolWrapper;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "getAccJMS"), (String)"8", (Object)this);
            return this.accJSPW;
        }
    }

    protected JMSSessPoolWrapper getUpdJMS() {
        try {
            JMSSessPoolWrapper jMSSessPoolWrapper = this.drsPools.getUpdJMS();
            jMSSessPoolWrapper.recLvl = this.recoveryCount;
            return jMSSessPoolWrapper;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "getUpdJMS"), (String)"9", (Object)this);
            return this.updJSPW;
        }
    }

    protected void retAccJMS(JMSSessPoolWrapper jMSSessPoolWrapper) {
        this.drsPools.retAccJMS(jMSSessPoolWrapper);
    }

    protected void retUpdJMS(JMSSessPoolWrapper jMSSessPoolWrapper) {
        this.drsPools.retUpdJMS(jMSSessPoolWrapper);
    }

    protected JMSTopicPoolWrapper getAccJTPW() {
        JMSTopicPoolWrapper jMSTopicPoolWrapper = null;
        try {
            jMSTopicPoolWrapper = this.drsPools.getAccJTPW();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "getAccJTPW"), (String)"1648", (Object)this);
            jMSTopicPoolWrapper = this.accJTPW;
        }
        return jMSTopicPoolWrapper;
    }

    protected JMSTopicPoolWrapper getUpdJTPW() {
        JMSTopicPoolWrapper jMSTopicPoolWrapper = null;
        try {
            jMSTopicPoolWrapper = this.drsPools.getUpdJTPW();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "getUpdJTPW"), (String)"1673", (Object)this);
            jMSTopicPoolWrapper = this.updJTPW;
        }
        return jMSTopicPoolWrapper;
    }

    protected void retAccJTPW(JMSTopicPoolWrapper jMSTopicPoolWrapper) {
        this.drsPools.retAccJTPW(jMSTopicPoolWrapper);
    }

    protected void retUpdJTPW(JMSTopicPoolWrapper jMSTopicPoolWrapper) {
        this.drsPools.retUpdJTPW(jMSTopicPoolWrapper);
    }

    public void launchBroker(Properties properties) {
    }

    protected void getFactory() throws Throwable {
        Object object;
        Object object2;
        Throwable throwable = null;
        Throwable throwable2 = null;
        factoryNameSpaceName = System.getProperty("DRS.factoryNameSpaceName");
        if (factoryNameSpaceName != null) {
            try {
                object2 = new Properties();
                ((Properties)object2).put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                object = new InitialContext((Hashtable<?, ?>)object2);
                this.factory = (TopicConnectionFactory)((InitialContext)object).lookup(factoryNameSpaceName);
            }
            catch (Throwable throwable3) {
                Tr.error(tc, "drs.throwable", throwable3);
                throwable3.printStackTrace();
                throwable = throwable3;
            }
        }
        if (this.factory == null) {
            try {
                object2 = System.getProperty("DRS.factoryMethodName");
                if (object2 != null) {
                    factoryMethodName = object2;
                }
                object = ImplFactory.loadClassFromKey((String)factoryClassName);
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DRSCacheApp.class$("java.lang.String")) : class$java$lang$String};
                Method method = ((Class)object).getMethod(factoryMethodName, classArray);
                Object[] objectArray = new Object[]{this.hostName};
                this.factory = (TopicConnectionFactory)method.invoke(null, objectArray);
            }
            catch (Throwable throwable4) {
                Tr.error(tc, "drs.throwable", throwable4);
                throwable4.printStackTrace();
                throwable2 = throwable4;
            }
        }
        if (throwable != null) {
            throw throwable;
        }
        if (throwable2 != null) {
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initJMSClient(String string, boolean bl) {
        String string2 = this.dcaName + "/initJMSClient: ";
        try {
            boolean bl2 = false;
            this.replicatorNameForJMSPoolKey = string;
            String string3 = this.replicatorNameForJMSPoolKey + this.domainNameForJMSPoolKey;
            Class clazz = class$com$ibm$ws$drs$DRSCacheApp == null ? (class$com$ibm$ws$drs$DRSCacheApp = DRSCacheApp.class$("com.ibm.ws.drs.DRSCacheApp")) : class$com$ibm$ws$drs$DRSCacheApp;
            synchronized (clazz) {
                Object object;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + "Printing keys in drsJMSResources Hashmap");
                    object = drsJMSResources.keySet().iterator();
                    while (object.hasNext()) {
                        String string4 = (String)object.next();
                        Tr.debug(tc, string2 + "Key:" + string4 + " Ref count:" + ((DRSJMSResources)drsJMSResources.get(string4)).getRefCount());
                    }
                    Tr.debug(tc, string2 + " Now Adding/Incrementing refs to key: " + string3);
                }
                if (drsJMSResources.containsKey(string3)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + " key: " + string3 + " found in the drsJMSResources table. Increment ref.");
                    }
                    object = (DRSJMSResources)drsJMSResources.get(string3);
                    ((DRSJMSResources)object).incrementRefCount();
                    this.factory = ((DRSJMSResources)object).factory;
                    this.accJMSPool = ((DRSJMSResources)object).accJMSPool;
                    this.accJMSPoolReferences = ((DRSJMSResources)object).accJMSPoolReferences;
                    this.accJSPW = ((DRSJMSResources)object).accJSPW;
                    this.updJMSPool = ((DRSJMSResources)object).updJMSPool;
                    this.updJMSPoolReferences = ((DRSJMSResources)object).updJMSPoolReferences;
                    this.updJSPW = ((DRSJMSResources)object).updJSPW;
                    this.drsPoolsInitted = true;
                    this.drsIJC.initJMSTempTopics();
                    this.drsIJC.initJMSSubs();
                    return true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " key: " + string3 + " not in drsJMSResources table. Will add ref if initialization is successful.");
                }
                try {
                    bl2 = this.drsIJC.initJMSClient(string, bl);
                }
                catch (Throwable throwable) {
                    Tr.debug(tc, string2 + "Caught exception attempting to initialize JMS Connections to : " + string);
                    Tr.debug(tc, string2 + "Stack trace of exception: ");
                    throwable.printStackTrace();
                }
                this.drsPoolsInitted = bl2;
                if (bl2) {
                    object = new DRSJMSResources();
                    ((DRSJMSResources)object).factory = this.factory;
                    ((DRSJMSResources)object).accJMSPool = this.accJMSPool;
                    ((DRSJMSResources)object).accJSPW = this.accJSPW;
                    ((DRSJMSResources)object).accJMSPoolReferences = this.accJMSPoolReferences;
                    ((DRSJMSResources)object).updJMSPool = this.updJMSPool;
                    ((DRSJMSResources)object).updJMSPoolReferences = this.updJMSPoolReferences;
                    ((DRSJMSResources)object).updJSPW = this.updJSPW;
                    ((DRSJMSResources)object).incrementRefCount();
                    drsJMSResources.put(string3, object);
                    this.drsIJC.initJMSTempTopics();
                    this.drsIJC.initJMSSubs();
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "initJMSClient"), (String)"10", (Object)this);
            Tr.error(tc, "drs.throwable", throwable);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DRSDataXfer getDRSDataXfer(String string) {
        DRSDataXfer dRSDataXfer = null;
        HashMap hashMap = jmsSvrs;
        synchronized (hashMap) {
            dRSDataXfer = (DRSDataXfer)jmsSvrs.get(string);
        }
        return dRSDataXfer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(" factory: ").append(this.factory).append("\n").append(" dcaName: ").append(this.dcaName).append("\n").append(" instanceID: ").append(this.instanceID).append("\n").append(" clientOnly: ").append(this.clientOnly).append("\n").append(" serverOnly: ").append(this.serverOnly).append("\n").append(" accJMSPool: ").append(this.accJMSPool).append("\n").append(" accJSPWS: ").append(this.accJSPW).append("\n").append(" accTopicName: ").append(this.accTopicName).append("\n").append(" cacheAccessTopic: ").append(this.cacheAccessTopic).append("\n").append(" cacheUpdateTopic: ").append(this.cacheUpdateTopic).append("\n").append(" cleanUpFailed: ").append(this.cleanUpFailed).append("\n").append(" cleanUpFailedTime: ").append(this.cleanUpFailedTime).append("\n").append(" recoveryTime: ").append(this.recoveryTime).append("\n").append(" entryCnt: ").append(this.entryCnt).append("\n").append(" entryParts: ").append(this.entryParts).append("\n").append(" listeners: ").append(this.listeners).append("\n").append(" hostName: ").append(this.hostName).append("\n").append(" otherHosts: ").append(this.otherHosts).append("\n").append(" doEncrypt: ").append(this.doEncrypt).append("\n").append(" partitionOnEntry: ").append(this.partitionOnEntry).append("\n").append(" partitionId: ").append(this.partitionId).append("\n").append(" partitionSize: ").append(this.partitionSize).append("\n").append(" partTopicName: ").append(this.partTopicName).append("\n").append(" poolsize: ").append(this.poolsize).append("\n").append(" dcmPoolSize: ").append(this.dcmPoolSize).append("\n").append(" tempTopics: ").append(this.tempTopics).append("\n").append(" key2TempTopic: ").append(this.key2TempTopic).append("\n").append(" key2TempTopic: ").append(this.key2TempTopic).append("\n").append(" updJMSPool: ").append(this.updJMSPool).append("\n").append(" updJSPW: ").append(this.updJSPW).append("\n").append(" updTopicName: ").append(this.updTopicName).append("\n").append(" jmsUp: ").append(this.jmsUp).append("\n dcaName: ").append(this.dcaName).append("\n debug: ").append(this.debug).append("\n updPartSub: ").append(this.updPartSub).append("\n accPartSub: ").append(this.accPartSub).append("\n updJTPW: ").append(this.updJTPW).append("\n accJTPW: ").append(this.accJTPW).append("\n updJTPWPool: ").append(this.updJTPWPool).append("\n accJTPWPool: ").append(this.accJTPWPool).append("\n localHost: ").append(this.localHost).append("\n");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "toString"), (String)"15", (Object)this);
            return "Could not do toString on DRSCacheApp";
        }
        return stringBuffer.toString();
    }

    public String getServletInfo() {
        return "WAS JMS based cache app";
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (tc == null) {
            tc = Tr.register((class$com$ibm$ws$drs$DRSCacheApp == null ? (class$com$ibm$ws$drs$DRSCacheApp = DRSCacheApp.class$("com.ibm.ws.drs.DRSCacheApp")) : class$com$ibm$ws$drs$DRSCacheApp).getName(), "IBM WAS DRS Cache App", "com.ibm.ws.drs.drs");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSCacheApp:doGet");
        }
        ServletOutputStream servletOutputStream = null;
        try {
            String string = "\nInit params available are: propsBytesVsObjs, partitioned, partitionSize, partitionId, partitionOnEntry, hostname, poolsize, clientOnly, serverOnly, debug\n";
            httpServletResponse.setContentType(cntType);
            servletOutputStream = httpServletResponse.getOutputStream();
            DRSDataXfer dRSDataXfer = DRSCacheApp.getDRSDataXfer(this.dcaName);
            if (((DRSCacheApp)dRSDataXfer).debug) {
                servletOutputStream.println(string + dRSDataXfer.toString());
            } else {
                servletOutputStream.println("Cache servlet " + this.dcaName + " is loaded" + string);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "doGet"), (String)"13", (Object)this);
            throwable.printStackTrace();
        }
    }

    protected void closeUpdJMS() {
        try {
            this.drsCJ.closeUpdJMS();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "closeUpdJMS"), (String)"14", (Object)this);
        }
    }

    protected void closeAccJMS() {
        try {
            this.drsCJ.closeAccJMS();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "closeAccJMS"), (String)"17", (Object)this);
        }
    }

    protected void closeUpdJTPW() {
        try {
            this.drsCJ.closeUpdJTPW();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "closeUpdJTPW"), (String)"2145", (Object)this);
        }
    }

    protected void closeAccJTPW() {
        try {
            this.drsCJ.closeAccJTPW();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "closeAccJTPW"), (String)"2165", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeJMSClient() {
        String string = this.dcaName + "/closeJMSClient: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry");
        }
        this.jmsUp = false;
        this.factory = null;
        String string2 = this.replicatorNameForJMSPoolKey + this.domainNameForJMSPoolKey;
        Object object = this.updJMSPoolMutex;
        synchronized (object) {
            Object object2 = this.accJMSPoolMutex;
            synchronized (object2) {
                Class clazz = class$com$ibm$ws$drs$DRSCacheApp == null ? (class$com$ibm$ws$drs$DRSCacheApp = DRSCacheApp.class$("com.ibm.ws.drs.DRSCacheApp")) : class$com$ibm$ws$drs$DRSCacheApp;
                synchronized (clazz) {
                    Object object3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Printing keys in drsJMSResources Hashmap");
                        object3 = drsJMSResources.keySet().iterator();
                        while (object3.hasNext()) {
                            String string3 = (String)object3.next();
                            Tr.debug(tc, string + "Key:" + string3 + " RefCount: " + ((DRSJMSResources)drsJMSResources.get(string3)).getRefCount());
                        }
                        Tr.debug(tc, string + "Searching for DRSJMSResources with key:" + string2);
                    }
                    if ((object3 = (DRSJMSResources)drsJMSResources.get(string2)) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "Found djr for said key. # of references to drsJMSResources(mbd+broker):" + ((DRSJMSResources)object3).getRefCount());
                        }
                        ((DRSJMSResources)object3).decrementRefCount();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "Decremented refCount. Now # of references to drsJMSResources(mbd+broker):" + ((DRSJMSResources)object3).getRefCount());
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "No djr found for said key.");
                        }
                        return;
                    }
                    if (((DRSJMSResources)object3).getRefCount() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "Closing Access and Update jspw pools to this mbd+broker");
                        }
                        this.closeAccJMS();
                        this.closeUpdJMS();
                        drsJMSResources.remove(string2);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "Dereferencing local jspw members only.");
                        }
                        this.accJMSPool = new LinkedList();
                        this.accJMSPoolReferences = new LinkedList();
                        this.accJSPW = null;
                        this.updJMSPool = new LinkedList();
                        this.updJMSPoolReferences = new LinkedList();
                        this.updJSPW = null;
                        this.instanceTempTopicSub = null;
                        this.accPartSub = null;
                        this.updPartSub = null;
                    }
                }
                this.accSubPool.clear();
                this.updSubPool.clear();
                this.closeAccJTPW();
                this.closeUpdJTPW();
                this.drsPoolsInitted = false;
            }
        }
    }

    protected boolean resetJMS(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, this.dcaName + " doing DRSCacheApp:resetJMS");
        }
        return this.drsRJ.resetJMS(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        String string = "stop: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. ");
        }
        appServerIsShuttingDown = true;
        try {
            Thread.sleep(1234L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Vector vector = null;
        Enumeration enumeration = null;
        Object object = jmsSvrs;
        synchronized (object) {
            vector = new Vector(jmsSvrs.entrySet());
            enumeration = vector.elements();
        }
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            DRSCacheApp dRSCacheApp = (DRSCacheApp)object.getValue();
            try {
                dRSCacheApp.shutdown();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)(className + "stop"), (String)"3");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        String string = this.dcaName + "/shutdown: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string + "Entry. ");
        }
        this.drsPC.discontinue();
        this.closeJMSClient();
        HashMap hashMap = drsInsts;
        synchronized (hashMap) {
            drsInsts.remove(new Long(this.instanceID));
        }
        hashMap = jmsSvrs;
        synchronized (hashMap) {
            jmsSvrs.remove(this.dcaName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string + "Exit. ");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DRSCacheApp:destroy");
        }
        this.closeJMSClient();
        super.destroy();
    }

    public void onMessage(Message message) {
        try {
            this.drsJ.onMessage(message);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "onMessage"), (String)"27", (Object)this);
            Tr.error(tc, "drs.throwable", throwable);
        }
    }

    public void createEntry(Message message, DRSCacheMsg dRSCacheMsg) throws JMSException {
        this.drsA.createEntry(message, dRSCacheMsg);
    }

    public void createEntryProp(Message message, DRSCacheMsg dRSCacheMsg) throws JMSException {
        this.drsA.createEntryProp(message, dRSCacheMsg);
    }

    public void updateEntry(Message message, DRSCacheMsg dRSCacheMsg) throws JMSException {
        this.drsA.updateEntry(message, dRSCacheMsg);
    }

    public void updateEntryProp(Message message, DRSCacheMsg dRSCacheMsg) throws JMSException {
        this.drsA.updateEntryProp(message, dRSCacheMsg);
    }

    public void getEntry(Message message, DRSCacheMsg dRSCacheMsg) throws JMSException {
        this.drsA.getEntry(message, dRSCacheMsg);
    }

    public void getEntryProp(Message message, DRSCacheMsg dRSCacheMsg) throws JMSException {
        this.drsA.getEntryProp(message, dRSCacheMsg);
    }

    public void removeEntry(Message message, DRSCacheMsg dRSCacheMsg) throws JMSException {
        this.drsA.removeEntry(message, dRSCacheMsg);
    }

    public void removeEntryProp(Message message, DRSCacheMsg dRSCacheMsg) throws JMSException {
        this.drsA.removeEntryProp(message, dRSCacheMsg);
    }

    public void entryIDExists(Message message, DRSCacheMsg dRSCacheMsg) throws JMSException {
        this.drsA.entryIDExists(message, dRSCacheMsg);
    }

    public void propIDExists(Message message, DRSCacheMsg dRSCacheMsg) throws JMSException {
        this.drsA.propIDExists(message, dRSCacheMsg);
    }

    public void bootstrap(Message message, DRSCacheMsg dRSCacheMsg) throws JMSException {
        this.drsA.bootstrap(message, dRSCacheMsg);
    }

    public void acknowledge(Message message, DRSCacheMsg dRSCacheMsg) throws Throwable {
        this.drsJ.acknowledge(message, dRSCacheMsg);
    }

    public void acknowledge(DRSCacheMsg dRSCacheMsg, DRSCacheMsg dRSCacheMsg2) throws Throwable {
        this.drsJ.acknowledge(dRSCacheMsg, dRSCacheMsg2);
    }

    public void createEntry(Object object, Object object2) {
        try {
            this.drsA.createEntry(object, object2);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "createEntry"), (String)"21", (Object)this);
            Tr.error(tc, "drs.throwable", throwable);
        }
    }

    public void createEntryProp(Object object, Object object2, Object object3) throws DRSEntryPartitionException {
        try {
            this.drsA.createEntryProp(object, object2, object3);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)(className + "createEntryProp"), (String)"22", (Object)this);
            Tr.error(tc, "drs.jmsexcep", jMSException);
        }
    }

    public void updateEntry(Object object, Object object2) throws DRSEntryPartitionException {
        try {
            this.drsA.updateEntry(object, object2);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)(className + "updateEntry"), (String)"23", (Object)this);
            Tr.error(tc, "drs.jmsexcep", jMSException);
        }
    }

    public void updateEntryProp(Object object, Object object2, Object object3) throws DRSEntryPartitionException {
        try {
            this.drsA.updateEntryProp(object, object2, object3);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)(className + "updateEntryProp"), (String)"24", (Object)this);
            Tr.error(tc, "drs.jmsexcep", jMSException);
        }
    }

    public Object getEntry(Object object) {
        try {
            return this.drsA.getEntry(object);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)(className + "getEntry"), (String)"25", (Object)this);
            Tr.error(tc, "drs.jmsexcep", jMSException);
            return null;
        }
        catch (DRSEntryPartitionException dRSEntryPartitionException) {
            return null;
        }
    }

    public Object getEntryProp(Object object, Object object2) throws DRSEntryPartitionException {
        try {
            return this.drsA.getEntryProp(object, object2);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)(className + "getEntryProp"), (String)"26", (Object)this);
            Tr.error(tc, "drs.jmsexcep", jMSException);
            return null;
        }
    }

    public void removeEntry(Object object) {
        try {
            this.drsA.removeEntry(object);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)(className + "removeEntry"), (String)"27", (Object)this);
            Tr.error(tc, "drs.jmsexcep", jMSException);
        }
        catch (DRSEntryPartitionException dRSEntryPartitionException) {
            // empty catch block
        }
    }

    public void removeEntryProp(Object object, Object object2, Object object3) throws DRSEntryPartitionException {
        try {
            this.drsA.removeEntryProp(object, object2, object3);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)(className + "removeEntryProp"), (String)"28", (Object)this);
            Tr.error(tc, "drs.jmsexcep", jMSException);
        }
    }

    public boolean entryIDExists(Object object) {
        try {
            return this.drsA.entryIDExists(object);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)(className + "entryIDExists"), (String)"29", (Object)this);
            Tr.error(tc, "drs.jmsexcep", jMSException);
            return false;
        }
        catch (DRSEntryPartitionException dRSEntryPartitionException) {
            return false;
        }
    }

    public boolean propIDExists(Object object, Object object2) throws DRSEntryPartitionException {
        try {
            return this.drsA.propIDExists(object, object2);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)(className + "propIDExists"), (String)"30", (Object)this);
            Tr.error(tc, "drs.jmsexcep", jMSException);
            return false;
        }
    }

    public void bootstrap() {
        try {
            this.drsA.bootstrap();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)(className + "bootstrap"), (String)"31", (Object)this);
            Tr.error(tc, "drs.jmsexcep", jMSException);
        }
        catch (DRSEntryPartitionException dRSEntryPartitionException) {
            FFDCFilter.processException((Throwable)dRSEntryPartitionException, (String)(className + "bootstrap"), (String)"32", (Object)this);
        }
    }

    public void addDRSCacheMsgListener(DRSCacheMsgListener dRSCacheMsgListener) {
        this.drsA.addDRSCacheMsgListener(dRSCacheMsgListener);
    }

    public void removeDRSCacheMsgListener(DRSCacheMsgListener dRSCacheMsgListener) {
        this.drsA.removeDRSCacheMsgListener(dRSCacheMsgListener);
    }

    public boolean shouldConvBytes2Obj(Object object) {
        return this.drsA.shouldConvBytes2Obj(object);
    }

    public ByteArrayInputStream getByteStream(Object object) {
        return this.drsA.getByteStream(object);
    }

    public Object convBytes2Obj(ObjectInputStream objectInputStream) {
        try {
            return this.drsA.convBytes2Obj(objectInputStream);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "convBytes2Obj"), (String)"33", (Object)this);
            Tr.error(tc, "drs.throwable", throwable);
            return null;
        }
    }

    protected void setUpNLS() {
        try {
            this.rb = new NLS("com.ibm.ws.drs.drs");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "setUpNLS"), (String)"34", (Object)this);
        }
    }

    protected boolean isBootstrapOnReset() {
        return this.drsU.isBootstrapOnReset();
    }

    protected HashMap getCurrentList() {
        return this.drsU.getCurrentList();
    }

    protected DRSCacheMsg convBmsgHdrs2DCM(DRSCacheMsg dRSCacheMsg, BytesMessage bytesMessage) throws JMSException {
        try {
            return this.drsU.convBmsgHdrs2DCM(dRSCacheMsg, bytesMessage);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "convBmsgHdrs2DCM"), (String)"35", (Object)this);
            if (throwable instanceof JMSException) {
                throw (JMSException)throwable;
            }
            Tr.error(tc, "drs.throwable", throwable);
            return dRSCacheMsg;
        }
    }

    protected DRSCacheMsg convBmsg2DCM(DRSCacheMsg dRSCacheMsg, DRSBuffWrapper dRSBuffWrapper, BytesMessage bytesMessage) throws JMSException {
        return this.drsU.convBmsg2DCM(dRSCacheMsg, dRSBuffWrapper, bytesMessage);
    }

    protected Object getPartKeyForSvr(DRSCacheMsg dRSCacheMsg) {
        return dRSCacheMsg.entryKey;
    }

    protected Object getPartKeyForCl(DRSCacheMsg dRSCacheMsg) {
        return this.drsU.getPartKeyForCl(dRSCacheMsg);
    }

    protected Topic getUpdPartTopic(DRSCacheMsg dRSCacheMsg) {
        return this.drsU.getUpdPartTopic(dRSCacheMsg);
    }

    protected Topic getAccPartTopic(DRSCacheMsg dRSCacheMsg) {
        return this.drsU.getAccPartTopic(dRSCacheMsg);
    }

    protected void setJCMEntryObj(DRSCacheMsg dRSCacheMsg, Object object) {
        this.drsU.setJCMEntryObj(dRSCacheMsg, object);
    }

    protected void setJCMPropObj(DRSCacheMsg dRSCacheMsg, Object object) {
        this.drsU.setJCMPropObj(dRSCacheMsg, object);
    }

    protected byte[] getBytes(Object object) {
        try {
            return this.drsU.getBytes(object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "getBytes"), (String)"36", (Object)throwable);
            Tr.error(tc, "drs.throwable", throwable);
            return new byte[0];
        }
    }

    protected short getPartition() {
        return this.drsU.getPartition();
    }

    protected void sendListenerEvent(Object object) {
        this.drsU.sendListenerEvent(object);
    }

    protected boolean notMyJMSPartition(DRSCacheMsg dRSCacheMsg) {
        return this.drsU.notMyPartition(dRSCacheMsg);
    }

    protected void setDCMTimeStamp(DRSCacheMsg dRSCacheMsg) {
        dRSCacheMsg.timestamp = System.currentTimeMillis();
    }

    protected void jmsPubUpd(DRSCacheMsg dRSCacheMsg, Topic topic, Topic topic2) throws JMSException, DRSEntryPartitionException {
        this.drsJ.jmsPubUpd(dRSCacheMsg, topic, topic2);
    }

    protected boolean jmsExist(DRSCacheMsg dRSCacheMsg) throws JMSException, DRSEntryPartitionException {
        return this.drsJ.jmsExist(dRSCacheMsg);
    }

    protected Object jmsGetReq(DRSCacheMsg dRSCacheMsg) throws JMSException, DRSEntryPartitionException {
        try {
            return this.drsJ.jmsGetReq(dRSCacheMsg);
        }
        catch (JMSException jMSException) {
            throw jMSException;
        }
        catch (DRSEntryPartitionException dRSEntryPartitionException) {
            throw dRSEntryPartitionException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "jmsGetReq"), (String)"37", (Object)this);
            Tr.error(tc, "drs.throwable", throwable);
            return null;
        }
    }

    protected Object jmsGet(DRSCacheMsg dRSCacheMsg) throws JMSException, DRSEntryPartitionException {
        return this.drsJ.jmsGet(dRSCacheMsg);
    }

    protected void jmsAckGet(Message message, DRSCacheMsg dRSCacheMsg, Object object) throws JMSException {
        this.drsJ.jmsAckGet(message, dRSCacheMsg, object);
    }

    protected byte[] handleOutboundSecurity(DRSCacheMsg dRSCacheMsg, byte[] byArray) {
        return this.drsSec.handleOutboundSecurity(dRSCacheMsg, byArray);
    }

    protected byte[] handleInboundSecurity(DRSCacheMsg dRSCacheMsg, byte[] byArray) {
        return this.drsSec.handleInboundSecurity(dRSCacheMsg, byArray);
    }

    protected BytesMessage encryptBmsgKeys(DRSCacheMsg dRSCacheMsg, BytesMessage bytesMessage) {
        try {
            return this.drsSec.encryptBmsgKeys(dRSCacheMsg, bytesMessage);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(className + "encrypBmsgKeys"), (String)"38", (Object)this);
            Tr.error(tc, "drs.throwable", throwable);
            return null;
        }
    }

    protected void setupBytesMsg(DRSCacheMsg dRSCacheMsg, DRSBuffWrapper dRSBuffWrapper, BytesMessage bytesMessage) throws JMSException {
        this.drsSec.setupBytesMsg(dRSCacheMsg, dRSBuffWrapper, bytesMessage);
    }

    protected DRSCacheMsg getJCM(ObjectMessage objectMessage) throws JMSException {
        return (DRSCacheMsg)objectMessage.getObject();
    }

    protected Object objMsgConv(ObjectMessage objectMessage) throws JMSException {
        try {
            return this.drsU.objMsgConv(objectMessage);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)(className + "objMsgConv"), (String)"55", (Object)this);
            Tr.error(tc, "drs.throwable", classCastException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void key2OtherDRSInstAdd(Object object, Long l) {
        HashMap hashMap = this.key2OtherDRSInst;
        synchronized (hashMap) {
            this.key2OtherDRSInst.put(object, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void key2OtherDRSInstRemove(Object object) {
        HashMap hashMap = this.key2OtherDRSInst;
        synchronized (hashMap) {
            this.key2OtherDRSInst.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long key2OtherDRSInstGet(Object object) {
        Long l = null;
        HashMap hashMap = this.key2OtherDRSInst;
        synchronized (hashMap) {
            l = (Long)this.key2OtherDRSInst.get(object);
        }
        return l;
    }

    public long getInstanceId() {
        return this.instanceID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDRSEventListener(DRSEventListener dRSEventListener) {
        LinkedList linkedList = this.drsListeners;
        synchronized (linkedList) {
            this.drsListeners.addLast(dRSEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDRSEventListener(DRSEventListener dRSEventListener) {
        LinkedList linkedList = this.drsListeners;
        synchronized (linkedList) {
            this.drsListeners.remove(dRSEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOtherDRSLocalHosts() {
        String string = this.dcaName + "/logOtherDRSLocalHosts: ";
        String string2 = "";
        HashMap hashMap = this.otherDRSLocalHosts;
        synchronized (hashMap) {
            string2 = "dcaName=" + this.dcaName + " numInstances=" + this.otherDRSLocalHosts.size();
            Set set = this.otherDRSLocalHosts.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                String string3 = (String)this.otherDRSLocalHosts.get(l);
                string2 = string2 + "\n  drsID=" + l + " localHost=" + string3;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOtherDRSLocalHost(Long l, String string) {
        HashMap hashMap = this.otherDRSLocalHosts;
        synchronized (hashMap) {
            this.otherDRSLocalHosts.put(l, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOtherDRSLocalHost(Long l) {
        String string = "";
        HashMap hashMap = this.otherDRSLocalHosts;
        synchronized (hashMap) {
            string = (String)this.otherDRSLocalHosts.get(l);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOtherDRSLocalHost(Long l) {
        HashMap hashMap = this.otherDRSLocalHosts;
        synchronized (hashMap) {
            this.otherDRSLocalHosts.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOtherDRSTopicCounts() {
        String string = this.dcaName + "/logOtherDRSTopicCounts: ";
        String string2 = "";
        HashMap hashMap = this.otherDRSTopicCounts;
        synchronized (hashMap) {
            string2 = "dcaName=" + this.dcaName + " numInstances=" + this.otherDRSTopicCounts.size();
            Set set = this.otherDRSTopicCounts.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                Integer n = (Integer)this.otherDRSTopicCounts.get(l);
                string2 = string2 + "\n  drsID=" + l + " TopicCount=" + n;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOtherDRSTopicCount(Long l) {
        HashMap hashMap = this.otherDRSTopicCounts;
        synchronized (hashMap) {
            this.otherDRSTopicCounts.put(l, new Integer(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOtherDRSTopicCount(Long l) {
        int n;
        HashMap hashMap = this.otherDRSTopicCounts;
        synchronized (hashMap) {
            if (!this.otherDRSTopicCounts.containsKey(l)) {
                this.otherDRSTopicCounts.put(l, new Integer(0));
            }
            n = (Integer)this.otherDRSTopicCounts.get(l);
            this.otherDRSTopicCounts.put(l, new Integer(1 + n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOtherDRSTopicCount(Long l) {
        HashMap hashMap = this.otherDRSTopicCounts;
        synchronized (hashMap) {
            this.otherDRSTopicCounts.remove(l);
        }
    }

    public static void setThreadPool(ThreadPool threadPool) {
        _threadPool = threadPool;
    }

    public static ThreadPool getThreadPool() {
        return _threadPool;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

