/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.drs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.drs.DRSBuffWrapper;
import com.ibm.ws.drs.DRSCacheApp;
import com.ibm.ws.drs.DRSCacheMsg;
import com.ibm.ws.drs.DRSCacheMsgListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Topic;

public class DRSUtils {
    DRSCacheApp dca;
    TraceComponent tc;
    protected int instCount = 0;
    protected int instTopicCount = 0;
    static /* synthetic */ Class class$com$ibm$ws$drs$DRSUtils;

    public DRSUtils(DRSCacheApp dRSCacheApp) {
        this.dca = dRSCacheApp;
        this.tc = Tr.register((class$com$ibm$ws$drs$DRSUtils == null ? (class$com$ibm$ws$drs$DRSUtils = DRSUtils.class$("com.ibm.ws.drs.DRSUtils")) : class$com$ibm$ws$drs$DRSUtils).getName(), "DRS utils", "com.ibm.ws.drs.drs");
    }

    protected boolean isBootstrapOnReset() {
        return this.dca.recoveryCount != 0;
    }

    protected HashMap getCurrentList() {
        return this.dca.entryParts;
    }

    protected DRSCacheMsg convBmsgHdrs2DCM(DRSCacheMsg dRSCacheMsg, BytesMessage bytesMessage) throws Throwable {
        if (this.dca.doEncrypt) {
            ObjectInputStream objectInputStream;
            ByteArrayInputStream byteArrayInputStream;
            byte[] byArray;
            int n;
            Object object = bytesMessage.getObjectProperty("DRS-entryKey");
            if (object != null) {
                n = bytesMessage.readInt();
                byArray = new byte[n];
                bytesMessage.readBytes(byArray);
                byArray = this.dca.handleInboundSecurity(dRSCacheMsg, byArray);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
                dRSCacheMsg.entryKey = this.dca.convBytes2Obj(objectInputStream);
                objectInputStream.close();
                byteArrayInputStream.close();
            }
            if ((object = bytesMessage.getObjectProperty("DRS-propKey")) != null) {
                n = bytesMessage.readInt();
                byArray = new byte[n];
                bytesMessage.readBytes(byArray);
                byArray = this.dca.handleInboundSecurity(dRSCacheMsg, byArray);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
                dRSCacheMsg.propKey = this.dca.convBytes2Obj(objectInputStream);
                objectInputStream.close();
                byteArrayInputStream.close();
            }
        } else {
            dRSCacheMsg.entryKey = bytesMessage.getObjectProperty("DRS-entryKey");
            dRSCacheMsg.propKey = bytesMessage.getObjectProperty("DRS-propKey");
        }
        dRSCacheMsg.action = bytesMessage.getShortProperty("DRS-action");
        dRSCacheMsg.partition = bytesMessage.getShortProperty("DRS-partition");
        dRSCacheMsg.instanceID = bytesMessage.getLongProperty("DRS-instanceID");
        dRSCacheMsg.timestamp = bytesMessage.getLongProperty("DRS-timestamp");
        dRSCacheMsg.msgId = bytesMessage.getIntProperty("DRS-msgId");
        dRSCacheMsg.ackMsgId = bytesMessage.getLongProperty("DRS-ackMsgId");
        return dRSCacheMsg;
    }

    protected DRSCacheMsg convBmsg2DCM(DRSCacheMsg dRSCacheMsg, DRSBuffWrapper dRSBuffWrapper, BytesMessage bytesMessage) throws JMSException {
        int n = bytesMessage.readInt();
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "convBmsg2DCM len is " + n);
        }
        DRSCacheMsg dRSCacheMsg2 = null;
        if (n != 0) {
            byte[] byArray = new byte[n];
            bytesMessage.readBytes(byArray);
            byArray = this.dca.handleInboundSecurity(dRSCacheMsg, byArray);
            try {
                dRSCacheMsg2 = (DRSCacheMsg)this.dca.convBytes2Obj(new ObjectInputStream(this.dca.getByteStream(byArray)));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "convBmsg2DCM returning " + dRSCacheMsg2);
        }
        return dRSCacheMsg2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getPartKeyForCl(DRSCacheMsg dRSCacheMsg) {
        if (this.dca.partitionOnEntry) {
            return dRSCacheMsg.entryKey;
        }
        Short s = null;
        HashMap hashMap = this.dca.entryParts;
        synchronized (hashMap) {
            s = (Short)this.dca.entryParts.get(dRSCacheMsg.entryKey);
        }
        boolean bl = false;
        Cloneable cloneable = this.dca.freePartialPartSet;
        synchronized (cloneable) {
            bl = this.dca.freePartialPartSet.contains(s);
        }
        if (s != null && !this.dca.clientOnly && (s == -1 || s == 0 || bl)) {
            s = new Short(this.getPartition());
            cloneable = this.dca.entryParts;
            synchronized (cloneable) {
                this.dca.entryParts.put(dRSCacheMsg.entryKey, s);
            }
        }
        if (s == null && !this.dca.clientOnly) {
            s = new Short(this.getPartition());
            cloneable = this.dca.entryParts;
            synchronized (cloneable) {
                this.dca.entryParts.put(dRSCacheMsg.entryKey, s);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Topic getUpdPartTopic(DRSCacheMsg dRSCacheMsg) {
        Topic topic = null;
        Object object = null;
        boolean bl = true;
        boolean bl2 = false;
        object = this.dca.getPartKeyForCl(dRSCacheMsg);
        if (this.dca.partitionOnEntry) {
            if (!(this.dca.reverseEntryPart || object == null || object.equals(this.dca.key2DRSInst) || object.equals(this.dca.key2TempTopic))) {
                Object object2;
                try {
                    topic = (Topic)this.dca.key2TempTopic.get(object);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    object2 = this.dca.key2TempTopic;
                    synchronized (object2) {
                        topic = (Topic)this.dca.key2TempTopic.get(object);
                    }
                }
                if (topic == null) {
                    if (this.dca.otherDRSInstanceIDs.size() > 0) {
                        int n;
                        Object object3;
                        int n2 = 0;
                        object2 = this;
                        synchronized (object2) {
                            n2 = this.instCount % this.dca.otherDRSInstanceIDs.size();
                            ++this.instCount;
                        }
                        object2 = (Long)this.dca.otherDRSInstanceIDs.get(n2);
                        String string = this.dca.getOtherDRSLocalHost((Long)object2);
                        if (null != string && this.dca.localHost.equals(string)) {
                            object3 = this;
                            synchronized (object3) {
                                n = this.dca.otherDRSInstanceIDs.size();
                                for (int i = 0; i < n; ++i) {
                                    n2 = this.instCount % this.dca.otherDRSInstanceIDs.size();
                                    ++this.instCount;
                                    Long l = (Long)this.dca.otherDRSInstanceIDs.get(n2);
                                    string = this.dca.getOtherDRSLocalHost(l);
                                    if (null == string || this.dca.localHost.equals(string)) continue;
                                    object2 = l;
                                    break;
                                }
                            }
                        }
                        if (!this.dca.otherDRSServerInstances.contains(object2) && 0 < this.dca.otherDRSServerInstances.size()) {
                            object3 = this;
                            synchronized (object3) {
                                n2 = this.instCount % this.dca.otherDRSServerInstances.size();
                            }
                            object2 = (Long)this.dca.otherDRSServerInstances.get(n2);
                        }
                        if ((object3 = (ArrayList)this.dca.tempTopics.get(object2)) != null && ((ArrayList)object3).size() != 0) {
                            n = 0;
                            n = this.dca.getOtherDRSTopicCount((Long)object2) % ((ArrayList)object3).size();
                            topic = (Topic)((ArrayList)object3).get(n);
                            HashMap hashMap = this.dca.key2TempTopic;
                            synchronized (hashMap) {
                                this.dca.key2TempTopic.put(object, topic);
                            }
                            hashMap = this.dca.key2DRSInst;
                            synchronized (hashMap) {
                                this.dca.key2DRSInst.put(object, object2);
                            }
                        }
                        topic = this.dca.cacheUpdateTopic;
                    } else {
                        topic = this.dca.cacheUpdateTopic;
                    }
                }
            }
        } else {
            Short s = (Short)object;
            if (s != null) {
                topic = (Topic)this.dca.partTopics.get(this.dca.updTopicName + s);
            }
        }
        if (topic == null) {
            bl = false;
            if (!this.dca.partialPartSet && !this.dca.othersPartialPartSet && this.dca.partitionSize > 0) {
                short s;
                if (dRSCacheMsg.partition <= 0) {
                    dRSCacheMsg.partition = s = this.dca.getPartition();
                } else {
                    s = dRSCacheMsg.partition;
                }
                topic = (Topic)this.dca.partTopics.get(this.dca.updTopicName + s);
            }
            if (topic == null) {
                topic = this.dca.cacheUpdateTopic;
            }
        }
        if (bl) {
            Short s = (Short)this.dca.entryParts.get(dRSCacheMsg.entryKey);
            dRSCacheMsg.partition = s != null ? s : (short)-1;
        }
        return topic;
    }

    protected Topic getAccPartTopic(DRSCacheMsg dRSCacheMsg) {
        int n;
        ArrayList arrayList;
        Number number;
        Topic topic = null;
        Object object = null;
        boolean bl = true;
        object = this.dca.getPartKeyForCl(dRSCacheMsg);
        if (!this.dca.partitionOnEntry) {
            if (this.dca.reverseEntryPart) {
                number = null;
                if (null != dRSCacheMsg.entryKey) {
                    number = this.dca.key2OtherDRSInstGet(dRSCacheMsg.entryKey);
                }
                if (null == number && null != object) {
                    number = this.dca.key2OtherDRSInstGet(object);
                }
                if (number != null && (arrayList = (ArrayList)this.dca.tempTopics.get(number)) != null && arrayList.size() > 0) {
                    n = 0;
                    n = this.dca.getOtherDRSTopicCount((Long)number) % arrayList.size();
                    topic = (Topic)arrayList.get(n);
                }
            } else if (this.dca.othersPartialPartSet) {
                topic = this.dca.cacheAccessTopic;
                dRSCacheMsg.partition = (short)-1;
            }
            if ((number = (Short)object) != null && topic == null) {
                topic = (Topic)this.dca.partTopics.get(this.dca.accTopicName + (Short)number);
            }
        }
        if (this.dca.partitionOnEntry && this.dca.reverseEntryPart && (arrayList = (ArrayList)this.dca.tempTopics.get(number = (Long)this.dca.otherEntryParts.get(object))) != null && arrayList.size() > 0) {
            n = 0;
            n = this.dca.getOtherDRSTopicCount((Long)number) % arrayList.size();
            topic = (Topic)arrayList.get(n);
        }
        if (topic == null) {
            bl = false;
            dRSCacheMsg.partition = (short)-1;
            if (!this.dca.partialPartSet && !this.dca.othersPartialPartSet && this.dca.partitionSize > 0) {
                topic = (Topic)this.dca.partTopics.get(this.dca.accTopicName + this.dca.getPartition());
            }
            if (topic == null) {
                topic = this.dca.cacheAccessTopic;
            }
        }
        if (bl) {
            number = (Short)this.dca.entryParts.get(dRSCacheMsg.entryKey);
            dRSCacheMsg.partition = number != null ? (Short)number : (short)-1;
        }
        return topic;
    }

    protected void setJCMEntryObj(DRSCacheMsg dRSCacheMsg, Object object) {
        if (!this.dca.entrybytesvsobjs) {
            dRSCacheMsg.objValue = object;
        } else if (object instanceof byte[]) {
            dRSCacheMsg.objValue = object;
        } else {
            DRSBuffWrapper dRSBuffWrapper = this.dca.getDBWPool();
            dRSBuffWrapper.buf = this.dca.getBytes(object);
            dRSCacheMsg.objValue = dRSBuffWrapper;
        }
    }

    protected void setJCMPropObj(DRSCacheMsg dRSCacheMsg, Object object) {
        if (!this.dca.propsbytesvsobjs) {
            dRSCacheMsg.objValue = object;
        } else if (object instanceof byte[]) {
            dRSCacheMsg.objValue = object;
        } else {
            DRSBuffWrapper dRSBuffWrapper = this.dca.getDBWPool();
            dRSBuffWrapper.buf = this.dca.getBytes(object);
            dRSCacheMsg.objValue = dRSBuffWrapper;
        }
    }

    protected byte[] getBytes(Object object) throws Throwable {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        byte[] byArray = new byte[]{};
        byteArrayOutputStream = new ByteArrayOutputStream();
        objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        byArray = byteArrayOutputStream.toByteArray();
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getPartition() {
        short s;
        if (this.dca.partitionSize == 0) {
            return -1;
        }
        Serializable serializable = this.dca;
        synchronized (serializable) {
            s = (short)(this.dca.entryCnt % this.dca.partitionSize);
        }
        if (s == 0) {
            s = this.dca.partitionSize;
        }
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "getPartition:  othersPartialPartSet " + this.dca.othersPartialPartSet + " freePartialPartSet " + this.dca.freePartialPartSet + " ret=" + s);
        }
        if (this.dca.othersPartialPartSet && !this.dca.clientOnly) {
            if (this.dca.freePartialPartSet.size() > 0 && this.dca.freePartialPartSet.size() < this.dca.partitionSize) {
                serializable = new Short(s);
                if (!this.dca.freePartialPartSet.contains(serializable)) {
                    s = (short)(this.dca.entryCnt % this.dca.freePartialPartSet.size());
                    serializable = (Short)this.dca.freePartialPartSet.get(s);
                    s = (Short)serializable;
                }
            } else {
                Short s2;
                short s3;
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, "getPartition: either some problem with freePartialPartSet,  or everybody listens to the same subset as this instance");
                }
                for (s3 = 1; s3 <= this.dca.partitionSize && s != this.dca.partitionId && !this.dca.otherUpdPartitionIds.containsKey(s2 = new Short(s)); s3 = (short)(s3 + 1)) {
                }
                if (s3 == this.dca.partitionSize) {
                    s = -1;
                }
            }
        }
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "getPartition returning " + s);
        }
        return s;
    }

    protected void sendListenerEvent(Object object) {
        EventObject eventObject = new EventObject(object);
        Enumeration enumeration = this.dca.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DRSCacheMsgListener dRSCacheMsgListener = (DRSCacheMsgListener)enumeration.nextElement();
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "DRSCacheApp:sendListenerEvent - sending " + eventObject + " to " + dRSCacheMsgListener);
            }
            dRSCacheMsgListener.processDRSCacheMsgEvent(eventObject);
        }
    }

    protected boolean notMyPartition(DRSCacheMsg dRSCacheMsg) {
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "notMyPartition - jcm is " + dRSCacheMsg + " and the partition size is " + this.dca.partitionSize);
        }
        if (this.dca.partitionSize == 0) {
            return false;
        }
        if (this.dca.partitionOnEntry) {
            return false;
        }
        if (dRSCacheMsg.partition == -1 || dRSCacheMsg.partition == 0) {
            return false;
        }
        if (dRSCacheMsg.partition == this.dca.partitionId) {
            return false;
        }
        return !this.dca.otherUpdPartitionIds.containsKey(new Short(dRSCacheMsg.partition));
    }

    protected Object objMsgConv(ObjectMessage objectMessage) throws JMSException, ClassCastException {
        Serializable serializable = objectMessage.getObject();
        DRSCacheMsg dRSCacheMsg = (DRSCacheMsg)serializable;
        return dRSCacheMsg.objValue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

