/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.environment.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public final class StringUtils {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final byte STATE_WS = 0;
    private static final byte STATE_NWS = 1;
    private static final char[] URI_SYMBOLS = new char[]{'-', '~', '#', '/', '.'};
    private static final char UNDERSCORE = '_';

    private StringUtils() {
    }

    public static String[] splitter(String string, int n) {
        Vector<String> vector = new Vector<String>(20);
        int n2 = 0;
        while (n2 < string.length()) {
            String string2 = string.substring(n2, Math.min(n + n2, string.length()));
            int n3 = string2.lastIndexOf(" ");
            if (n2 + string2.length() < string.length() && string.charAt(n2 + string2.length() - 1) != ' ' && string.charAt(n2 + string2.length()) != ' ' && n3 != -1) {
                vector.addElement(string2.substring(0, n3));
                n2 += n3 + 1;
                continue;
            }
            vector.addElement(string2.trim());
            n2 += string2.length();
        }
        String[] stringArray = new String[vector.size()];
        n2 = 0;
        while (n2 < vector.size()) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public static String repeat(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String flattenArguments(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            boolean bl = false;
            char[] cArray = stringArray[n].toCharArray();
            int n2 = 0;
            while (!bl && n2 < cArray.length) {
                if (Character.isWhitespace(cArray[n2])) {
                    bl = true;
                }
                ++n2;
            }
            if (bl) {
                stringBuffer.append('\"');
            }
            int n3 = 0;
            while (n3 < cArray.length) {
                if (cArray[n3] == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(cArray[n3]);
                ++n3;
            }
            if (bl) {
                stringBuffer.append('\"');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Enumeration parseFilenamesFromStream(InputStream inputStream) throws IOException {
        Vector<String> vector = new Vector<String>(64, 64);
        StringBuffer stringBuffer = null;
        int n = 0;
        int n2 = inputStream.read();
        while (n2 >= 0) {
            char c = (char)n2;
            switch (n) {
                case 0: {
                    if (Character.isWhitespace(c)) break;
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(c);
                    n = 1;
                    break;
                }
                case 1: {
                    if (!Character.isWhitespace(c)) {
                        stringBuffer.append(c);
                        break;
                    }
                    String string = stringBuffer.toString();
                    vector.add(string);
                    stringBuffer = null;
                    n = 0;
                    break;
                }
            }
            n2 = inputStream.read();
        }
        return vector.elements();
    }

    public static boolean isPrimitiveType(String string) {
        return string.equalsIgnoreCase("boolean") || string.equalsIgnoreCase("byte") || string.equalsIgnoreCase("double") || string.equalsIgnoreCase("float") || string.equalsIgnoreCase("int") || string.equalsIgnoreCase("long") || string.equalsIgnoreCase("short") || string.equalsIgnoreCase("char");
    }

    public static String URI2ClassName(String string) {
        String string2 = string;
        int n = 0;
        while (n < URI_SYMBOLS.length) {
            string2 = string2.replace(URI_SYMBOLS[n], '_');
            ++n;
        }
        return string2;
    }

    private static boolean isDelimiter(char c) {
        return "-.:_\u00b7\u0387\u06dd\u06de".indexOf(c) != -1;
    }
}

