/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import com.sun.mail.util.LineInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Provider;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.URLName;

public final class Session {
    private Properties props;
    private Authenticator authenticator;
    private Hashtable authTable = new Hashtable();
    private boolean debug = false;
    private Vector providers = new Vector();
    private Hashtable providersByProtocol = new Hashtable();
    private Hashtable providersByClassName = new Hashtable();
    private Properties addressMap = new Properties();
    private static Method getResources = null;
    private static Method getSystemResources = null;
    private static Session defaultSession;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$mail$Session;
    static /* synthetic */ Class class$javax$mail$URLName;

    private Session(Properties properties, Authenticator authenticator) {
        this.props = properties;
        this.authenticator = authenticator;
        if (Boolean.valueOf(properties.getProperty("mail.debug")).booleanValue()) {
            this.debug = true;
        }
        Class<?> clazz = authenticator != null ? authenticator.getClass() : this.getClass();
        this.loadProviders(clazz);
        this.loadAddressMap(clazz);
    }

    public static Session getInstance(Properties properties, Authenticator authenticator) {
        return new Session(properties, authenticator);
    }

    public static Session getInstance(Properties properties) {
        return new Session(properties, null);
    }

    public static Session getDefaultInstance(Properties properties, Authenticator authenticator) {
        if (defaultSession == null) {
            defaultSession = new Session(properties, authenticator);
        } else if (Session.defaultSession.authenticator != authenticator && (Session.defaultSession.authenticator == null || authenticator == null || Session.defaultSession.authenticator.getClass().getClassLoader() != authenticator.getClass().getClassLoader())) {
            throw new SecurityException("Access to default session denied");
        }
        return defaultSession;
    }

    public static Session getDefaultInstance(Properties properties) {
        return Session.getDefaultInstance(properties, null);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public Provider[] getProviders() {
        Object[] objectArray = new Provider[this.providers.size()];
        this.providers.copyInto(objectArray);
        return objectArray;
    }

    public Provider getProvider(String string) throws NoSuchProviderException {
        if (string == null || string.length() <= 0) {
            throw new NoSuchProviderException("Invalid protocol: null");
        }
        Provider provider = null;
        String string2 = this.props.getProperty("mail." + string + ".class");
        if (string2 != null) {
            if (this.debug) {
                System.out.println("DEBUG: mail." + string + ".class property exists and points to " + string2);
            }
            provider = (Provider)this.providersByClassName.get(string2);
        }
        if (provider != null) {
            return provider;
        }
        provider = (Provider)this.providersByProtocol.get(string);
        if (provider == null) {
            throw new NoSuchProviderException("No provider for " + string);
        }
        if (this.debug) {
            System.out.println("\nDEBUG: getProvider() returning " + provider.toString());
        }
        return provider;
    }

    public void setProvider(Provider provider) throws NoSuchProviderException {
        if (provider == null) {
            throw new NoSuchProviderException("Can't set null provider");
        }
        this.providersByProtocol.put(provider.getProtocol(), provider);
        ((Hashtable)this.props).put("mail." + provider.getProtocol() + ".class", provider.getClassName());
    }

    public Store getStore() throws NoSuchProviderException {
        return this.getStore(this.getProperty("mail.store.protocol"));
    }

    public Store getStore(String string) throws NoSuchProviderException {
        return this.getStore(new URLName(string, null, -1, null, null, null));
    }

    public Store getStore(URLName uRLName) throws NoSuchProviderException {
        String string = uRLName.getProtocol();
        Provider provider = this.getProvider(string);
        return this.getStore(provider, uRLName);
    }

    public Store getStore(Provider provider) throws NoSuchProviderException {
        return this.getStore(provider, null);
    }

    private Store getStore(Provider provider, URLName uRLName) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.STORE) {
            throw new NoSuchProviderException("invalid provider");
        }
        try {
            return (Store)this.getService(provider, uRLName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchProviderException("incorrect class");
        }
    }

    public Folder getFolder(URLName uRLName) throws MessagingException {
        Store store = this.getStore(uRLName);
        store.connect();
        return store.getFolder(uRLName);
    }

    public Transport getTransport() throws NoSuchProviderException {
        return this.getTransport(this.getProperty("mail.transport.protocol"));
    }

    public Transport getTransport(String string) throws NoSuchProviderException {
        return this.getTransport(new URLName(string, null, -1, null, null, null));
    }

    public Transport getTransport(URLName uRLName) throws NoSuchProviderException {
        String string = uRLName.getProtocol();
        Provider provider = this.getProvider(string);
        return this.getTransport(provider, uRLName);
    }

    public Transport getTransport(Provider provider) throws NoSuchProviderException {
        return this.getTransport(provider, null);
    }

    public Transport getTransport(Address address) throws NoSuchProviderException {
        String string = (String)((Hashtable)this.addressMap).get(address.getType());
        if (string == null) {
            throw new NoSuchProviderException("No provider for Address type: " + address.getType());
        }
        return this.getTransport(string);
    }

    private Transport getTransport(Provider provider, URLName uRLName) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.TRANSPORT) {
            throw new NoSuchProviderException("invalid provider");
        }
        try {
            return (Transport)this.getService(provider, uRLName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchProviderException("incorrect class");
        }
    }

    private Object getService(Provider provider, URLName uRLName) throws NoSuchProviderException {
        if (provider == null) {
            throw new NoSuchProviderException("null");
        }
        if (uRLName == null) {
            uRLName = new URLName(provider.getProtocol(), null, -1, null, null, null);
        }
        Object var3_3 = null;
        ClassLoader classLoader = this.authenticator != null ? this.authenticator.getClass().getClassLoader() : this.getClass().getClassLoader();
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(provider.getClassName());
        }
        catch (Exception exception) {
            try {
                clazz = Class.forName(provider.getClassName());
            }
            catch (Exception exception2) {
                if (this.debug) {
                    exception2.printStackTrace();
                }
                throw new NoSuchProviderException(provider.getProtocol());
            }
        }
        try {
            Class[] classArray = new Class[]{class$javax$mail$Session == null ? (class$javax$mail$Session = Session.class$("javax.mail.Session")) : class$javax$mail$Session, class$javax$mail$URLName == null ? (class$javax$mail$URLName = Session.class$("javax.mail.URLName")) : class$javax$mail$URLName};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this, uRLName};
            var3_3 = constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
            }
            throw new NoSuchProviderException(provider.getProtocol());
        }
        return var3_3;
    }

    public void setPasswordAuthentication(URLName uRLName, PasswordAuthentication passwordAuthentication) {
        if (passwordAuthentication == null) {
            this.authTable.remove(uRLName);
        } else {
            this.authTable.put(uRLName, passwordAuthentication);
        }
    }

    public PasswordAuthentication getPasswordAuthentication(URLName uRLName) {
        return (PasswordAuthentication)this.authTable.get(uRLName);
    }

    public PasswordAuthentication requestPasswordAuthentication(InetAddress inetAddress, int n, String string, String string2, String string3) {
        if (this.authenticator != null) {
            return this.authenticator.requestPasswordAuthentication(inetAddress, n, string, string2, string3);
        }
        return null;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    private void loadProviders(Class clazz) {
        block34: {
            Object object;
            Object object2;
            block33: {
                boolean bl;
                Object object3;
                block32: {
                    block31: {
                        BufferedInputStream bufferedInputStream = null;
                        try {
                            object3 = System.getProperty("java.home") + File.separator + "lib" + File.separator + "javamail.providers";
                            bufferedInputStream = new BufferedInputStream(new FileInputStream((String)object3));
                            if (bufferedInputStream != null) {
                                this.loadProvidersFromStream(bufferedInputStream);
                                ((InputStream)bufferedInputStream).close();
                                if (this.debug) {
                                    Session.pr("DEBUG: loaded providers in <java.home>/lib");
                                }
                            } else if (this.debug) {
                                Session.pr("DEBUG: not loading system providers in <java.home>/lib");
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (this.debug) {
                                Session.pr("DEBUG: not loading system providers in <java.home>/lib");
                            }
                        }
                        catch (IOException iOException) {
                            if (this.debug) {
                                Session.pr("DEBUG: " + iOException.getMessage());
                            }
                        }
                        catch (SecurityException securityException) {
                            if (!this.debug) break block31;
                            Session.pr("DEBUG: not loading system providers in <java.home>/lib");
                        }
                    }
                    object3 = null;
                    bl = false;
                    if (getResources != null) {
                        try {
                            object2 = clazz.getClassLoader();
                            object = object2 != null ? (Enumeration)getResources.invoke(object2, (Object[])new String[]{"META-INF/javamail.providers"}) : (Enumeration)getSystemResources.invoke(object2, (Object[])new String[]{"META-INF/javamail.providers"});
                            while (object.hasMoreElements()) {
                                URL uRL = (URL)object.nextElement();
                                object3 = uRL.openStream();
                                if (object3 != null) {
                                    try {
                                        this.loadProvidersFromStream((InputStream)object3);
                                        bl = true;
                                        ((InputStream)object3).close();
                                        if (!this.debug) continue;
                                        Session.pr("DEBUG: successfully loaded optional custom providers from URL: " + uRL);
                                    }
                                    catch (IOException iOException) {
                                        if (!this.debug) continue;
                                        Session.pr("DEBUG: " + iOException.getMessage());
                                    }
                                    continue;
                                }
                                if (!this.debug) continue;
                                Session.pr("DEBUG: not loading optional custom providers from URL: " + uRL);
                            }
                        }
                        catch (Exception exception) {
                            if (!this.debug) break block32;
                            Session.pr("DEBUG: " + exception);
                        }
                    }
                }
                if (!bl) {
                    object3 = clazz.getResourceAsStream("/META-INF/javamail.providers");
                    if (object3 != null) {
                        try {
                            this.loadProvidersFromStream((InputStream)object3);
                            ((InputStream)object3).close();
                            if (this.debug) {
                                Session.pr("DEBUG: successfully loaded optional custom providers: /META-INF/javamail.providers");
                            }
                            break block33;
                        }
                        catch (IOException iOException) {
                            if (this.debug) {
                                Session.pr("DEBUG: " + iOException);
                            }
                            break block33;
                        }
                    }
                    if (this.debug) {
                        Session.pr("DEBUG: not loading optional custom providers file: /META-INF/javamail.providers");
                    }
                }
            }
            object = null;
            object2 = "/META-INF/javamail.default.providers";
            object = clazz.getResourceAsStream((String)object2);
            if (object != null) {
                try {
                    this.loadProvidersFromStream((InputStream)object);
                    ((InputStream)object).close();
                    if (this.debug) {
                        Session.pr("DEBUG: successfully loaded default providers");
                    }
                    break block34;
                }
                catch (IOException iOException) {
                    if (this.debug) {
                        Session.pr("DEBUG: " + iOException.getMessage());
                    }
                    break block34;
                }
            }
            if (this.debug) {
                Session.pr("DEBUG: can't load default providers file" + (String)object2);
            }
        }
        if (this.debug) {
            System.out.println("\nDEBUG: Tables of loaded providers");
            Session.pr("DEBUG: Providers Listed By Class Name: " + this.providersByClassName.toString());
            Session.pr("DEBUG: Providers Listed By Protocol: " + this.providersByProtocol.toString());
        }
    }

    private void loadProvidersFromStream(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            String string;
            LineInputStream lineInputStream = new LineInputStream(inputStream);
            while ((string = lineInputStream.readLine()) != null) {
                Object object;
                if (string.startsWith("#")) continue;
                Provider.Type type = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken().trim();
                    int n = ((String)object).indexOf("=");
                    if (((String)object).startsWith("protocol=")) {
                        string2 = ((String)object).substring(n + 1);
                        continue;
                    }
                    if (((String)object).startsWith("type=")) {
                        String string6 = ((String)object).substring(n + 1);
                        if (string6.equalsIgnoreCase("store")) {
                            type = Provider.Type.STORE;
                            continue;
                        }
                        if (!string6.equalsIgnoreCase("transport")) continue;
                        type = Provider.Type.TRANSPORT;
                        continue;
                    }
                    if (((String)object).startsWith("class=")) {
                        string3 = ((String)object).substring(n + 1);
                        continue;
                    }
                    if (((String)object).startsWith("vendor=")) {
                        string4 = ((String)object).substring(n + 1);
                        continue;
                    }
                    if (!((String)object).startsWith("version=")) continue;
                    string5 = ((String)object).substring(n + 1);
                }
                if (type == null || string2 == null || string3 == null || string2.length() <= 0 || string3.length() <= 0) {
                    if (!this.debug) continue;
                    System.out.println("DEBUG: Bad provider entry: " + string);
                    continue;
                }
                object = new Provider(type, string2, string3, string4, string5);
                this.providers.addElement(object);
                this.providersByClassName.put(string3, object);
                if (this.providersByProtocol.containsKey(string2)) continue;
                this.providersByProtocol.put(string2, object);
            }
        }
    }

    private void loadAddressMap(Class clazz) {
        Object object;
        Object object2;
        block25: {
            boolean bl;
            InputStream inputStream;
            block24: {
                InputStream inputStream2 = null;
                String string = "/META-INF/javamail.default.address.map";
                inputStream2 = clazz.getResourceAsStream(string);
                if (inputStream2 != null) {
                    try {
                        this.addressMap.load(inputStream2);
                        inputStream2.close();
                    }
                    catch (IOException iOException) {
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                inputStream = null;
                bl = false;
                if (getResources != null) {
                    try {
                        object2 = clazz.getClassLoader();
                        object = object2 != null ? (Enumeration)getResources.invoke(object2, (Object[])new String[]{"META-INF/javamail.address.map"}) : (Enumeration)getSystemResources.invoke(object2, (Object[])new String[]{"META-INF/javamail.address.map"});
                        while (object.hasMoreElements()) {
                            URL uRL = (URL)object.nextElement();
                            inputStream = uRL.openStream();
                            if (inputStream != null) {
                                try {
                                    this.addressMap.load(inputStream);
                                    bl = true;
                                    inputStream.close();
                                    if (!this.debug) continue;
                                    Session.pr("DEBUG: successfully loaded optional address map from URL: " + uRL);
                                }
                                catch (IOException iOException) {
                                    if (!this.debug) continue;
                                    Session.pr("DEBUG: " + iOException.getMessage());
                                }
                                continue;
                            }
                            if (!this.debug) continue;
                            Session.pr("DEBUG: not loading optional address map from URL: " + uRL);
                        }
                    }
                    catch (Exception exception) {
                        if (!this.debug) break block24;
                        Session.pr("DEBUG: " + exception);
                    }
                }
            }
            if (!bl) {
                inputStream = clazz.getResourceAsStream("/META-INF/javamail.address.map");
                if (inputStream != null) {
                    try {
                        this.addressMap.load(inputStream);
                        inputStream.close();
                        if (this.debug) {
                            Session.pr("DEBUG: successfully loaded optional address map: /META-INF/javamail.address.map");
                        }
                        break block25;
                    }
                    catch (IOException iOException) {
                        if (this.debug) {
                            Session.pr("DEBUG: " + iOException);
                        }
                        break block25;
                    }
                }
                if (this.debug) {
                    Session.pr("DEBUG: not loading optional address map file: /META-INF/javamail.address.map");
                }
            }
        }
        object = null;
        try {
            object2 = System.getProperty("java.home") + File.separator + "lib" + File.separator + "javamail.address.map";
            object = new BufferedInputStream(new FileInputStream((String)object2));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (object != null) {
            try {
                this.addressMap.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void pr(String string) {
        System.out.println(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class clazz = class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Session.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader;
            getResources = clazz.getMethod("getResources", class$java$lang$String == null ? (class$java$lang$String = Session.class$("java.lang.String")) : class$java$lang$String);
            getSystemResources = clazz.getMethod("getSystemResources", class$java$lang$String == null ? (class$java$lang$String = Session.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        defaultSession = null;
    }
}

