/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.jgss.mech.spnego;

import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import java.io.IOException;

class ContextFlags {
    public final int delegFlag = 0;
    public final int mutualFlag = 1;
    public final int replayFlag = 2;
    public final int sequenceFlag = 3;
    public final int anonFlag = 4;
    public final int confFlag = 5;
    public final int integFlag = 6;
    private BitArray bits;

    public ContextFlags() {
        this.bits = new BitArray(7);
    }

    public ContextFlags(DerInputStream derInputStream) throws IOException {
        this.decode(derInputStream);
    }

    public ContextFlags(boolean[] blArray) {
        if (blArray == null || blArray.length == 0) {
            throw new IllegalArgumentException("flags must not be null or empty");
        }
        if (blArray.length == 7) {
            this.bits = new BitArray(blArray);
        } else if (blArray.length < 7) {
            boolean[] blArray2 = new boolean[7];
            System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        } else {
            boolean[] blArray3 = new boolean[7];
            System.arraycopy(blArray, 0, blArray3, 0, 7);
        }
    }

    public boolean get(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= 7) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n));
        }
        return this.bits.get(n);
    }

    public void set(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.bits.length()) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n));
        }
        this.bits.set(n, bl);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContextFlags: [\n");
        stringBuffer.append("   delegation: " + this.bits.get(0));
        stringBuffer.append("\n   mutual authentication: " + this.bits.get(1));
        stringBuffer.append("\n   replay detection: " + this.bits.get(2));
        stringBuffer.append("\n   out-of-sequence detection: " + this.bits.get(3));
        stringBuffer.append("\n   anonymous authentication: " + this.bits.get(4));
        stringBuffer.append("\n   confidentiality: " + this.bits.get(5));
        stringBuffer.append("\n   integrity: " + this.bits.get(6) + " ]");
        return stringBuffer.toString();
    }

    public byte[] encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putUnalignedBitString(this.bits);
        return derOutputStream.toByteArray();
    }

    private void decode(DerInputStream derInputStream) throws IOException {
        this.bits = derInputStream.getUnalignedBitString();
    }
}

