/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.jgss.mech.spnego;

import com.ibm.security.jgss.mech.spnego.ContextFlags;
import com.ibm.security.jgss.mech.spnego.MechTypeList;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.util.ArrayList;
import org.ietf.jgss.GSSException;

class InitNegToken {
    private MechTypeList mechTypes;
    private ContextFlags reqFlags;
    private byte[] mechToken;
    private byte[] mechListMIC;

    public InitNegToken(MechTypeList mechTypeList, ContextFlags contextFlags, byte[] byArray, byte[] byArray2) {
        this.mechTypes = mechTypeList;
        this.reqFlags = contextFlags;
        if (byArray != null) {
            this.mechToken = (byte[])byArray.clone();
        }
        if (byArray2 != null) {
            this.mechListMIC = (byte[])byArray2.clone();
        }
    }

    public InitNegToken(DerInputStream derInputStream) throws IOException, GSSException {
        this.decode(derInputStream);
    }

    private void decode(DerInputStream derInputStream) throws IOException, GSSException {
        DerValue[] derValueArray = derInputStream.getSequence(3);
        if (derValueArray.length > 0) {
            int n = 0;
            while (n < derValueArray.length) {
                int n2 = derValueArray[n].getTag() & 0x1F;
                switch (n2) {
                    case 0: {
                        this.mechTypes = new MechTypeList(derValueArray[n].getData());
                        break;
                    }
                    case 1: {
                        this.reqFlags = new ContextFlags(derValueArray[n].getData());
                        break;
                    }
                    case 2: {
                        this.mechToken = derValueArray[n].getData().getOctetString();
                        break;
                    }
                    case 3: {
                        this.mechListMIC = derValueArray[n].getData().getOctetString();
                        break;
                    }
                    default: {
                        throw new IOException("Invalid tag number");
                    }
                }
                ++n;
            }
        }
    }

    public byte[] encode() throws IOException {
        DerOutputStream derOutputStream;
        DerValue derValue;
        ArrayList<DerValue> arrayList = new ArrayList<DerValue>();
        if (this.mechTypes != null) {
            derValue = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.mechTypes.encode());
            arrayList.add(derValue);
        }
        if (this.reqFlags != null) {
            derValue = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.reqFlags.encode());
            arrayList.add(derValue);
        }
        if (this.mechToken != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.mechToken);
            derValue = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream.toByteArray());
            arrayList.add(derValue);
        }
        if (this.mechListMIC != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.mechListMIC);
            derValue = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream.toByteArray());
            arrayList.add(derValue);
        }
        DerValue[] derValueArray = new DerValue[arrayList.size()];
        arrayList.toArray(derValueArray);
        derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    public MechTypeList getMechTypes() {
        return this.mechTypes;
    }

    public ContextFlags getReqFlags() {
        return this.reqFlags;
    }

    public byte[] getMechListMIC() {
        return this.mechListMIC;
    }

    public byte[] getMechToken() {
        return this.mechToken;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("InitNegToken: [");
        if (this.mechTypes != null) {
            stringBuffer.append("\n\t" + this.mechTypes.toString());
        }
        if (this.reqFlags != null) {
            stringBuffer.append("\n\t" + this.reqFlags.toString());
        }
        if (this.mechToken != null) {
            stringBuffer.append("\n\tmechToken: " + this.getBytesString(this.mechToken));
        }
        if (this.mechListMIC != null) {
            stringBuffer.append("\n\tmechListMIC: " + this.getBytesString(this.mechListMIC));
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    private String getBytesString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Byte.toString(byArray[n]) + " ");
            ++n;
        }
        return stringBuffer.toString();
    }
}

