/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.jgss.mech.spnego;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

class MechTypeList {
    private Oid[] list;

    public MechTypeList(Oid[] oidArray) {
        if (oidArray == null || oidArray.length == 0) {
            throw new IllegalArgumentException("OIDs must not be null or empty");
        }
        this.list = (Oid[])oidArray.clone();
    }

    public MechTypeList(String[] stringArray) throws IllegalArgumentException {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("OIDs must not be null or empty");
        }
        this.list = new Oid[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.list[n] = new Oid(stringArray[n]);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Invalid OID string");
            }
            ++n;
        }
    }

    public MechTypeList(DerInputStream derInputStream) throws GSSException, IOException {
        this.decode(derInputStream);
    }

    private void decode(DerInputStream derInputStream) throws GSSException, IOException {
        DerValue[] derValueArray = derInputStream.getSequence(3);
        this.list = new Oid[derValueArray.length];
        int n = 0;
        while (n < derValueArray.length) {
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(new DerInputStream(derValueArray[n].toByteArray()));
            this.list[n] = new Oid(objectIdentifier.toString());
            ++n;
        }
    }

    public byte[] encode() throws IOException {
        DerValue derValue;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < this.list.length) {
            derValue = new ObjectIdentifier(this.list[n].toString());
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID((ObjectIdentifier)derValue);
            byteArrayOutputStream.write(derOutputStream.toByteArray());
            ++n;
        }
        derValue = new DerValue(48, byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
        return derValue.toByteArray();
    }

    public Oid[] getMechs() {
        return (Oid[])this.list.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MechTypeList:[");
        int n = 0;
        while (n < this.list.length) {
            stringBuffer.append(this.list[n] + "\n");
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

