/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Security;

public final class RSAPrivateCrtKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateCrtKey,
Serializable {
    static final long serialVersionUID = 4979297236007557055L;
    private BigInteger version = BigInteger.ZERO;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;

    RSAPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        byte[] byArray = bigInteger.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger.toByteArray();
        byte[] byArray2 = bigInteger2.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger2.toByteArray();
        byte[] byArray3 = bigInteger3.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger3.toByteArray();
        byte[] byArray4 = bigInteger4.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger4.toByteArray();
        byte[] byArray5 = bigInteger5.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger5.toByteArray();
        byte[] byArray6 = bigInteger6.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger6.toByteArray();
        byte[] byArray7 = bigInteger7.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger7.toByteArray();
        byte[] byArray8 = bigInteger8.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger8.toByteArray();
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8};
        try {
            RSAPrivateCrtKey.a(byArrayArray);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(RSAPrivateCrtKey.a("O(tp?,)nh{\u007f\"u<\t_\u0006!w>u}!") + exception.getMessage());
        }
        this.modulus = new BigInteger(byArrayArray[0]);
        this.privateExponent = new BigInteger(byArrayArray[1]);
        this.publicExponent = new BigInteger(byArrayArray[2]);
        this.primeP = new BigInteger(byArrayArray[3]);
        this.primeQ = new BigInteger(byArrayArray[4]);
        this.primeExponentP = new BigInteger(byArrayArray[5]);
        this.primeExponentQ = new BigInteger(byArrayArray[6]);
        this.crtCoefficient = new BigInteger(byArrayArray[7]);
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, this.version.toByteArray()), new DerValue(2, this.modulus.toByteArray()), new DerValue(2, this.publicExponent.toByteArray()), new DerValue(2, this.privateExponent.toByteArray()), new DerValue(2, this.primeP.toByteArray()), new DerValue(2, this.primeQ.toByteArray()), new DerValue(2, this.primeExponentP.toByteArray()), new DerValue(2, this.primeExponentQ.toByteArray()), new DerValue(2, this.crtCoefficient.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(RSAPrivateCrtKey.a("o(tp?,)nh{H\u0002S<>b$nx>6g") + iOException.getMessage());
        }
    }

    RSAPrivateCrtKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrimeP() {
        return this.primeP;
    }

    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    public String toString() {
        String string = null;
        string = Security.getProvider(RSAPrivateCrtKey.a("E\u0005LV\u0018I")) == null ? new String(RSAPrivateCrtKey.a("E\u0005LV\u0018M")) : new String(RSAPrivateCrtKey.a("E\u0005LV\u0018I"));
        return string + RSAPrivateCrtKey.a(",\u0015R]{\\5hj:x\"!_)xgJy\"6M") + RSAPrivateCrtKey.a("a(ei7y4;\u0016") + this.modulus.toString() + "\n" + RSAPrivateCrtKey.a("|2cp2ogdd+c)dr/6M") + this.publicExponent.toString() + "\n" + RSAPrivateCrtKey.a("|5hj:x\"!y#|(oy5x}\u000b") + this.privateExponent.toString() + "\n" + RSAPrivateCrtKey.a("|5hq>,\u0017\u000b") + this.primeP.toString() + "\n" + RSAPrivateCrtKey.a("|5hq>,\u0016\u000b") + this.primeQ.toString() + "\n" + RSAPrivateCrtKey.a("|5hq>,\"yl4b\"oh{\\M") + this.primeExponentP.toString() + "\n" + RSAPrivateCrtKey.a("|5hq>,\"yl4b\"oh{]M") + this.primeExponentQ.toString() + "\n" + RSAPrivateCrtKey.a("o5u<8c\"gz2o.dr/\u0006") + this.crtCoefficient.toString() + "\n";
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            this.version = derValue.getData().getInteger();
            this.modulus = derValue.getData().getInteger();
            this.publicExponent = derValue.getData().getInteger();
            this.privateExponent = derValue.getData().getInteger();
            this.primeP = derValue.getData().getInteger();
            this.primeQ = derValue.getData().getInteger();
            this.primeExponentP = derValue.getData().getInteger();
            this.primeExponentQ = derValue.getData().getInteger();
            this.crtCoefficient = derValue.getData().getInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(RSAPrivateCrtKey.a("E)w}7e#!N\bM\u0017su-m3d_)x\fde{i)bs?e)f0{h&u}{c1dn)y)"));
            }
        }
        catch (Exception exception) {
            throw new IOException(RSAPrivateCrtKey.a("E)w}7e#!w>ugw}7y\"!\u0016") + exception.getMessage());
        }
    }

    private static void a(byte[][] byArray) {
        BigInteger[] bigIntegerArray = new BigInteger[8];
        int n2 = 0;
        while (n2 < 8) {
            if (byArray[n2] != null) {
                bigIntegerArray[n2] = new BigInteger(1, byArray[n2]);
            }
            ++n2;
        }
        if (bigIntegerArray[3].compareTo(bigIntegerArray[4]) < 0) {
            BigInteger bigInteger = bigIntegerArray[3];
            bigIntegerArray[3] = bigIntegerArray[4];
            bigIntegerArray[4] = bigInteger;
            bigInteger = bigIntegerArray[5];
            bigIntegerArray[5] = bigIntegerArray[6];
            bigIntegerArray[6] = bigInteger;
            bigIntegerArray[7] = null;
        }
        if (bigIntegerArray[7] == null) {
            bigIntegerArray[7] = bigIntegerArray[4].modInverse(bigIntegerArray[3]);
        }
        if (bigIntegerArray[0] == null) {
            bigIntegerArray[0] = bigIntegerArray[3].multiply(bigIntegerArray[4]);
        }
        if (bigIntegerArray[1] == null) {
            bigIntegerArray[1] = bigIntegerArray[2].modInverse(bigIntegerArray[3].subtract(BigInteger.ONE).multiply(bigIntegerArray[4].subtract(BigInteger.ONE)));
        }
        if (bigIntegerArray[5] == null) {
            bigIntegerArray[5] = bigIntegerArray[1].remainder(bigIntegerArray[3].subtract(BigInteger.ONE));
        }
        if (bigIntegerArray[6] == null) {
            bigIntegerArray[6] = bigIntegerArray[1].remainder(bigIntegerArray[4].subtract(BigInteger.ONE));
        }
        int n3 = 0;
        while (n3 < 8) {
            byArray[n3] = bigIntegerArray[n3].toByteArray();
            ++n3;
        }
    }

    public void zeroize() {
        this.modulus = BigInteger.ZERO;
        this.publicExponent = BigInteger.ZERO;
        this.privateExponent = BigInteger.ZERO;
        this.primeP = BigInteger.ZERO;
        this.primeQ = BigInteger.ZERO;
        this.primeExponentP = BigInteger.ZERO;
        this.primeExponentQ = BigInteger.ZERO;
        this.crtCoefficient = BigInteger.ZERO;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 12;
                        break;
                    }
                    case 1: {
                        n5 = 71;
                        break;
                    }
                    case 2: {
                        n5 = 1;
                        break;
                    }
                    case 3: {
                        n5 = 28;
                        break;
                    }
                    default: {
                        n5 = 91;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

