/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.archive.LoadStrategy;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.impl.FileImpl;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.ServerServiceConfig;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.etools.webservice.wsext.WsExtension;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.webservices.WSModels;
import com.ibm.ws.webservices.deploy.MetaDataLoader;
import com.ibm.ws.webservices.deploy.ModuleData;
import com.ibm.ws.webservices.deploy.PublishWSDLInfo;
import com.ibm.ws.webservices.deploy.URLPatternHolder;
import com.ibm.ws.webservices.deploy.WebserviceDescriptionInfo;
import com.ibm.ws.webservices.engine.utils.WSDLUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.extensions.ejb.EJBBinding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.xml.sax.InputSource;

public class DeployUtils {
    public static final int NO_PORTS = 0;
    public static final int SOAP_PORTS_ONLY = 1;
    public static final int NONSOAP_PORTS_ONLY = 2;
    public static final int MIXED_PORTS = 3;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$webservices$deploy$DeployUtils == null ? (class$com$ibm$ws$webservices$deploy$DeployUtils = DeployUtils.class$("com.ibm.ws.webservices.deploy.DeployUtils")) : class$com$ibm$ws$webservices$deploy$DeployUtils), (String)"WebServices", (String)"com.ibm.ws.webservices.deploy.resources.deployMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.webservices.deploy.resources.deployMessages");
    private static final String WORKING_DIR_PREFIX = "DeployUtilsTmpDir";
    private static final int COPY_BUFFER_SIZE = 1024;
    static /* synthetic */ Class class$com$ibm$ws$webservices$deploy$DeployUtils;

    static String taskDataToString(String[][] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            stringBuffer.append("The taskData is").append("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray[i].length; ++j) {
                    stringBuffer.append("\t[").append(stringArray[i][j]).append("]");
                }
            }
            stringBuffer.append("\n");
        } else {
            stringBuffer.append("taskData is null\n");
        }
        return stringBuffer.toString();
    }

    static String createWorkingDirectory(AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        File file = null;
        String string = null;
        File file2 = null;
        try {
            file2 = File.createTempFile("PublishWSLDHelper", "temp");
            String string2 = file2.getParent();
            file = new File(string2, WORKING_DIR_PREFIX + System.currentTimeMillis());
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.webservices.deploy.DeployUtils.createWorkingDirectory", (String)"119");
            }
            file.mkdirs();
            file2.delete();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.DeployUtils.createWorkingDirectory", (String)"126");
            String string3 = MessageFormat.format(util.getMessage((AppDeploymentTask)appDeploymentTask, (String)"WSWS0010E"), exception);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("createWorkingDirectory: " + string3));
            }
            Tr.error((TraceComponent)tc, (String)"WSWS0010E", (Object)exception);
            throw new AppDeploymentException(string3, (Throwable)exception);
        }
        finally {
            file2.delete();
        }
        string = file.getPath();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createWorkingDirectory: created directory " + string));
        }
        return string;
    }

    static void deleteWorkingDirectory(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("deleteWorkingDirectory: deleting directory " + string));
        }
        File[] fileArray = null;
        File file = new File(string);
        if (string == null || file.getAbsolutePath().indexOf(WORKING_DIR_PREFIX) == -1) {
            return;
        }
        fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                DeployUtils.deleteWorkingDirectory(fileArray[i].getAbsolutePath());
                fileArray[i].delete();
            }
            if (!fileArray[i].isFile()) continue;
            fileArray[i].delete();
        }
        file.delete();
    }

    static EObject convertURIToRefObject(String string, AppDeploymentInfo appDeploymentInfo) throws AppDeploymentException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convertURIToRefObject: moduleURI=" + string));
        }
        Object object3 = null;
        boolean bl = false;
        Vector vector = appDeploymentInfo.getModuleConfig("JAR_DD");
        if (vector != null) {
            object2 = vector.iterator();
            while (object2.hasNext()) {
                object = (EObject)object2.next();
                if (!string.equals(util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)object))) continue;
                object3 = object;
                bl = true;
                break;
            }
        }
        if (!bl && (object2 = appDeploymentInfo.getModuleConfig("WAR_DD")) != null) {
            object = ((Vector)object2).iterator();
            while (object.hasNext()) {
                EObject eObject = (EObject)object.next();
                if (!string.equals(util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)eObject))) continue;
                object3 = eObject;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("convertURIToRefObject: returning refObject=" + object3));
        }
        return object3;
    }

    public static PublishWSDLInfo getUpdatedWSDLFile(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) throws WSDLException {
        String string7;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2).append("://").append(string3).append(":").append(string4).append("/").append(DeployUtils.trimSlash(string5));
        hashMap.put("http", stringBuffer.toString());
        ModuleData moduleData = URLPatternHolder.getModuleData(string5);
        String string8 = moduleData.getDefaultJMSPrefix();
        if (string8 != null) {
            hashMap.put("jms", string8);
        }
        if ((string7 = moduleData.getDefaultEJBPrefix()) != null) {
            hashMap.put("ejb", string7);
        }
        String string9 = URLPatternHolder.getOwningWebServicesDescription(string5, string6);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WSDLException("INVALID_WSDL", fileNotFoundException.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PublishWSDLInfo publishWSDLInfo = DeployUtils.getUpdatedWSDLFile(string, fileInputStream, hashMap, moduleData.getMergedQNameToUrlPatternMap(string9), moduleData.getMergedQNameToPortComponentNameMap(string9), moduleData.getMergedQNameToEJBUrlPrefixMap(string9), bl, byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        try {
            publishWSDLInfo.setWsdlDoc(XMLUtils.newDocument(byteArrayInputStream));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.DeployUtils.getUpdatedWSDLFile", (String)"381", null);
            throw new WSDLException("INVALID_WSDL", exception.getMessage());
        }
        return publishWSDLInfo;
    }

    public static PublishWSDLInfo getUpdatedWSDLFile(String string, InputStream inputStream, Map map, Map map2, Map map3, Map map4, boolean bl, OutputStream outputStream) throws WSDLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUpdatedWSDLFile", (Object)new Object[]{map, map2});
        }
        PublishWSDLInfo publishWSDLInfo = new PublishWSDLInfo();
        ServiceProviderManager serviceProviderManager = new ServiceProviderManager(null);
        WSDLFactory wSDLFactory = serviceProviderManager.getWSDLFactory();
        WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", false);
        if (string == null) {
            wSDLReader.setFeature("javax.wsdl.importDocuments", false);
        }
        Definition definition = wSDLReader.readWSDL(string, new InputSource(inputStream));
        String string2 = definition.getTargetNamespace();
        Map map5 = definition.getServices();
        publishWSDLInfo.setHasServiceElement(!map5.isEmpty());
        WSDLWriter wSDLWriter = map5.values().iterator();
        while (wSDLWriter.hasNext()) {
            Service service = (Service)wSDLWriter.next();
            Map map6 = service.getPorts();
            String string3 = null;
            String string4 = null;
            Iterator iterator = map6.values().iterator();
            block1: while (iterator.hasNext()) {
                String string5;
                String string6;
                String string7;
                Object object;
                ExtensibilityElement extensibilityElement;
                Iterator iterator2;
                Object[] objectArray;
                Port port2 = (Port)iterator.next();
                Binding binding = port2.getBinding();
                String string8 = port2.getName();
                QName qName = new QName(string2, string8);
                if (binding.isUndefined()) {
                    objectArray = port2.getExtensibilityElements();
                    iterator2 = objectArray.iterator();
                    while (iterator2.hasNext()) {
                        extensibilityElement = (ExtensibilityElement)iterator2.next();
                        if (extensibilityElement instanceof SOAPAddress) {
                            publishWSDLInfo.setHasSOAPPorts(true);
                            object = (SOAPAddress)extensibilityElement;
                            string7 = object.getLocationURI();
                            if (string7.startsWith("http")) {
                                string6 = map2 != null ? (String)map2.get(qName) : null;
                                string5 = (String)map.get("http");
                                if (string5 == null || string6 == null) break;
                                string3 = DeployUtils.trimSlash(string5) + "/" + DeployUtils.trimSlash(string6);
                                break;
                            }
                            if (!string7.startsWith("jms") || (string6 = (String)map.get("jms")) == null) break;
                            string3 = map3 != null ? ((string5 = (String)map3.get(qName)) != null ? string6 + '&' + "targetService" + '=' + string5 : string6) : string6;
                            break;
                        }
                        if (!(extensibilityElement instanceof AgnosticAddress)) continue;
                        publishWSDLInfo.setHasNonSOAPPorts(true);
                        object = (String)map4.get(qName);
                        string7 = (String)map.get("ejb");
                        string7 = DeployUtils.stripDelimitersFromFrontOfEJBURLPropertyString(string7);
                        string7 = string7.replace('|', '&');
                        string4 = (String)object + '&' + string7;
                        break;
                    }
                } else {
                    objectArray = binding.getExtensibilityElements();
                    iterator2 = objectArray.iterator();
                    while (iterator2.hasNext()) {
                        extensibilityElement = (ExtensibilityElement)iterator2.next();
                        if (extensibilityElement instanceof SOAPBinding) {
                            publishWSDLInfo.setHasSOAPPorts(true);
                            object = (SOAPBinding)extensibilityElement;
                            string7 = object.getTransportURI();
                            if (string7.endsWith("http")) {
                                string6 = map2 != null ? (String)map2.get(qName) : null;
                                string5 = (String)map.get("http");
                                if (string5 == null || string6 == null) break;
                                string3 = DeployUtils.trimSlash(string5) + "/" + DeployUtils.trimSlash(string6);
                                break;
                            }
                            if (!string7.endsWith("jms") || (string6 = (String)map.get("jms")) == null) break;
                            string3 = map3 != null ? ((string5 = (String)map3.get(qName)) != null ? string6 + '&' + "targetService" + '=' + string5 : string6) : string6;
                            break;
                        }
                        if (!(extensibilityElement instanceof EJBBinding)) continue;
                        publishWSDLInfo.setHasNonSOAPPorts(true);
                        object = (String)map4.get(qName);
                        string7 = (String)map.get("ejb");
                        string7 = DeployUtils.stripDelimitersFromFrontOfEJBURLPropertyString(string7);
                        string7 = string7.replace('|', '&');
                        string4 = (String)object + '&' + string7;
                        break;
                    }
                }
                objectArray = port2.getExtensibilityElements().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] instanceof SOAPAddress) {
                        extensibilityElement = (SOAPAddress)objectArray[i];
                        if (string3 == null) continue block1;
                        extensibilityElement.setLocationURI(string3);
                        continue block1;
                    }
                    if (!(objectArray[i] instanceof AgnosticAddress)) continue;
                    extensibilityElement = (AgnosticAddress)objectArray[i];
                    if (extensibilityElement == null || string4 == null) continue block1;
                    extensibilityElement.setLocationURI(string4);
                    continue block1;
                }
            }
        }
        if (!bl) {
            definition = DeployUtils.stripOutNonSoapElements(definition);
        }
        wSDLWriter = wSDLFactory.newWSDLWriter();
        wSDLWriter.writeWSDL(definition, outputStream);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUpdatedWSDLFile");
        }
        return publishWSDLInfo;
    }

    public static boolean isWebServicesEnabled(EARFile eARFile, boolean bl) {
        boolean bl2 = false;
        List list = eARFile.getModuleFiles();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            ModuleFile moduleFile = (ModuleFile)iterator.next();
            String string2 = string = moduleFile.isWARFile() ? "WEB-INF/webservices.xml" : "META-INF/webservices.xml";
            if (moduleFile.containsFile(string)) {
                bl2 = true;
                break;
            }
            if (!bl || !moduleFile.containsFile(string = moduleFile.isWARFile() ? "WEB-INF/webservicesclient.xml" : "META-INF/webservicesclient.xml")) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public static boolean isWebServicesSecurityEnabled(EARFile eARFile) {
        boolean bl = false;
        List list = eARFile.getModuleFiles();
        WsExtension wsExtension = null;
        LoadStrategy loadStrategy = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            WsDescExt wsDescExt;
            String string;
            ModuleFile moduleFile = (ModuleFile)iterator.next();
            if (moduleFile == null) continue;
            loadStrategy = moduleFile.getLoadStrategy();
            String string2 = string = moduleFile.isWARFile() ? "WEB-INF/ibm-webservices-ext.xmi" : "META-INF/ibm-webservices-ext.xmi";
            if (loadStrategy != null && string != null) {
                wsExtension = DeployUtils.loadWebServicesExtXML(loadStrategy, string);
            }
            boolean bl2 = false;
            EList eList = null;
            if (wsExtension != null) {
                eList = wsExtension.getWsDescExt();
            }
            if (eList == null || eList.isEmpty()) continue;
            int n = eList.size();
            block1: for (int i = 0; i < n && !bl && (wsDescExt = (WsDescExt)eList.get(i)) != null; ++i) {
                EList eList2 = wsDescExt.getPcBinding();
                if (eList2 == null || eList2.isEmpty()) continue;
                int n2 = eList2.size();
                for (int j = 0; j < n2; ++j) {
                    PcBinding pcBinding = (PcBinding)eList2.get(j);
                    ServerServiceConfig serverServiceConfig = pcBinding.getServerServiceConfig();
                    if (serverServiceConfig == null) continue;
                    if (serverServiceConfig.getSecurityRequestReceiverServiceConfig() != null) {
                        bl = true;
                        if (!tc.isDebugEnabled()) continue block1;
                        Tr.debug((TraceComponent)tc, (String)"SecurityRequestReceiverServiceConfig found, assuming ws-security is enabled");
                        continue block1;
                    }
                    if (serverServiceConfig.getSecurityResponseSenderServiceConfig() == null) continue;
                    bl = true;
                    if (!tc.isDebugEnabled()) continue block1;
                    Tr.debug((TraceComponent)tc, (String)"SecurityResponseSenderServiceConfig found, assuming ws-security is enabled");
                    continue block1;
                }
            }
        }
        return bl;
    }

    private static WsExtension loadWebServicesExtXML(LoadStrategy loadStrategy, String string) {
        if (loadStrategy.getContainer().containsFile(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing IBM web services XML ext file: " + string));
            }
            try {
                return WSModels.getWsExtension(loadStrategy, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.DeployUtils.loadWebServicesExtXML", (String)"805");
            }
        }
        return null;
    }

    public static String trimSlash(String string) {
        if (string == null) {
            return string;
        }
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void publishWSDLFiles(RepositoryContext repositoryContext, String string, AttributeList attributeList) throws Exception {
        MetaDataLoader metaDataLoader = new MetaDataLoader(repositoryContext, null);
        metaDataLoader.load();
        List list = metaDataLoader.getModuleDataList();
        String string2 = "";
        int n = string.lastIndexOf(47);
        if (n == -1) {
            string2 = "ExtWSDL_" + string;
        } else {
            String string3 = string.substring(0, n + 1);
            String string4 = string.substring(n + 1, string.length());
            String string5 = "ExtWSDL_" + string4;
            string2 = string3 + string5;
        }
        DeployUtils.publishWSDLFiles(list, string, string2, attributeList);
        metaDataLoader.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int publishWSDLFiles(List list, String string, String string2, AttributeList attributeList) throws Exception {
        boolean bl;
        boolean bl2;
        block34: {
            DeflaterOutputStream deflaterOutputStream;
            block35: {
                File file = null;
                File file2 = null;
                DeflaterOutputStream deflaterOutputStream2 = null;
                deflaterOutputStream = null;
                bl2 = false;
                bl = false;
                boolean bl3 = false;
                try {
                    Object object;
                    String string3;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    HashMap hashMap = null;
                    if (attributeList != null) {
                        hashMap = new HashMap();
                        for (int i = 0; i < attributeList.size(); ++i) {
                            object6 = (Attribute)attributeList.get(i);
                            object5 = ((Attribute)object6).getName();
                            object4 = (AttributeList)((Attribute)object6).getValue();
                            object3 = new HashMap<String, Object>();
                            for (int j = 0; j < ((ArrayList)object4).size(); ++j) {
                                object2 = (Attribute)((ArrayList)object4).get(j);
                                string3 = ((Attribute)object2).getName();
                                object = ((Attribute)object2).getValue();
                                object3.put(string3, object);
                            }
                            hashMap.put((String)object5, object3);
                        }
                    }
                    if ((file = new File(string2)) != null && file.exists()) {
                        file.delete();
                    }
                    file.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    deflaterOutputStream = new ZipOutputStream(fileOutputStream);
                    file2 = new File(string);
                    if (file2 != null && file2.exists()) {
                        file2.delete();
                    }
                    file2.createNewFile();
                    object6 = new FileOutputStream(file2);
                    deflaterOutputStream2 = new ZipOutputStream((OutputStream)object6);
                    object5 = list.iterator();
                    while (object5.hasNext()) {
                        Object object7;
                        Object object8;
                        Object object9;
                        Object object10;
                        String string4;
                        Object object11;
                        Object object12;
                        Object object13;
                        Object object14;
                        Object object15;
                        Object object16;
                        object4 = (ModuleData)object5.next();
                        object3 = ((ModuleData)object4).getApplicationName();
                        String string5 = ((ModuleData)object4).getName();
                        object2 = ((ModuleData)object4).getContextRoot();
                        string3 = ((ModuleData)object4).getDefaultPrefix();
                        object = ((ModuleData)object4).getDefaultJMSPrefix();
                        String string6 = ((ModuleData)object4).getDefaultEJBPrefix();
                        if (hashMap != null && (object16 = (Map)hashMap.get(string5)) != null) {
                            object15 = (String)object16.get("http");
                            if (object15 != null) {
                                string3 = object15;
                            }
                            if ((object14 = (String)object16.get("jms")) != null) {
                                object = object14;
                            }
                            if ((object13 = (String)object16.get("ejb")) != null) {
                                string6 = object13;
                            }
                        }
                        string3 = DeployUtils.trimSlash(string3) + "/" + DeployUtils.trimSlash((String)object2);
                        object16 = (String)object3 + "/" + string5;
                        object15 = ((ModuleData)object4).getModulesWsdlFiles();
                        object14 = ((ModuleData)object4).getWebservicesDescritions();
                        object13 = new HashSet();
                        HashSet<String> hashSet = new HashSet<String>();
                        Object object17 = object14.iterator();
                        while (object17.hasNext()) {
                            object12 = (WebserviceDescriptionInfo)object17.next();
                            object11 = ((WebserviceDescriptionInfo)object12).getWsdlFileName();
                            if (!object13.contains(object11)) {
                                object13.add(object11);
                                continue;
                            }
                            string4 = new File((String)object11).getName();
                            hashSet.add(string4);
                        }
                        object17 = new HashSet();
                        object12 = object14.iterator();
                        while (object12.hasNext()) {
                            String string7;
                            Object object18;
                            object11 = (WebserviceDescriptionInfo)object12.next();
                            string4 = ((WebserviceDescriptionInfo)object11).getWsdlFileName();
                            object10 = new File(string4);
                            object9 = ((File)object10).getName();
                            object8 = null;
                            object7 = object15.iterator();
                            while (object7.hasNext()) {
                                object18 = (FileImpl)object7.next();
                                string7 = object18.getName();
                                if (!string7.equals(object9)) continue;
                                object8 = object18;
                            }
                            if (object8 == null) {
                                Tr.error((TraceComponent)tc, (String)("publishWSDLFiles: thisWebserviceDescriptionsWsdlFile is null for module " + string5));
                                continue;
                            }
                            object7 = object8.getDirectoryURI();
                            object18 = object8.getName();
                            string7 = ((WebserviceDescriptionInfo)object11).getWebserviceDescriptionName();
                            if (hashSet.contains(object18)) {
                                object18 = string7 + '_' + (String)object18;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("DeployUtils.publishWSDLFiles: about to add an outermost WSDL file to the zip file, the file name is " + (String)object18));
                            }
                            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                            hashMap2.put("jms", object);
                            hashMap2.put("http", string3);
                            hashMap2.put("ejb", string6);
                            InputStream inputStream = object8.getInputStream();
                            ZipEntry zipEntry = new ZipEntry((String)object16 + "/" + (String)object7 + "/" + (String)object18);
                            ((ZipOutputStream)deflaterOutputStream2).putNextEntry(zipEntry);
                            PublishWSDLInfo publishWSDLInfo = DeployUtils.getUpdatedWSDLFile(null, inputStream, hashMap2, ((ModuleData)object4).getMergedQNameToUrlPatternMap(string7), ((ModuleData)object4).getMergedQNameToPortComponentNameMap(string7), ((ModuleData)object4).getMergedQNameToEJBUrlPrefixMap(string7), false, deflaterOutputStream2);
                            bl = publishWSDLInfo.hasSOAPPorts() | bl;
                            inputStream.close();
                            inputStream = object8.getInputStream();
                            ZipEntry zipEntry2 = new ZipEntry((String)object16 + "/" + (String)object7 + "/" + (String)object18);
                            ((ZipOutputStream)deflaterOutputStream).putNextEntry(zipEntry2);
                            PublishWSDLInfo publishWSDLInfo2 = DeployUtils.getUpdatedWSDLFile(null, inputStream, hashMap2, ((ModuleData)object4).getMergedQNameToUrlPatternMap(string7), ((ModuleData)object4).getMergedQNameToPortComponentNameMap(string7), ((ModuleData)object4).getMergedQNameToEJBUrlPrefixMap(string7), true, deflaterOutputStream);
                            bl2 = publishWSDLInfo2.hasNonSOAPPorts() | bl2;
                            object17.add(object8);
                            bl3 = true;
                        }
                        object12 = object15.iterator();
                        while (object12.hasNext()) {
                            object11 = (FileImpl)object12.next();
                            if (object17.contains(object11)) continue;
                            string4 = object11.getDirectoryURI();
                            object10 = object11.getName();
                            object9 = object11.getInputStream();
                            object8 = new ZipEntry((String)object16 + "/" + string4 + "/" + (String)object10);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("about to add a non-outermost WSDL file to the zip file.  file name is " + (String)object10));
                            }
                            ((ZipOutputStream)deflaterOutputStream2).putNextEntry((ZipEntry)object8);
                            ((ZipOutputStream)deflaterOutputStream).putNextEntry((ZipEntry)object8);
                            bl3 = true;
                            object7 = new byte[1024];
                            int n = 0;
                            while ((n = ((InputStream)object9).read((byte[])object7)) > -1) {
                                ((ZipOutputStream)deflaterOutputStream2).write((byte[])object7, 0, n);
                                ((ZipOutputStream)deflaterOutputStream).write((byte[])object7, 0, n);
                            }
                            ((ZipOutputStream)deflaterOutputStream2).closeEntry();
                            ((ZipOutputStream)deflaterOutputStream).closeEntry();
                        }
                    }
                    if (!bl3) {
                        ((ZipOutputStream)deflaterOutputStream2).close();
                        ((ZipOutputStream)deflaterOutputStream).close();
                        file.delete();
                        file2.delete();
                        throw new Exception(nls.getString("WSWS0047E"));
                    }
                    Object var44_47 = null;
                    if (!bl3) break block34;
                    if (deflaterOutputStream2 == null) break block35;
                }
                catch (Throwable throwable) {
                    Object var44_48 = null;
                    if (bl3) {
                        if (deflaterOutputStream2 != null) {
                            deflaterOutputStream2.flush();
                            ((ZipOutputStream)deflaterOutputStream2).close();
                        }
                        if (deflaterOutputStream != null) {
                            deflaterOutputStream.flush();
                            ((ZipOutputStream)deflaterOutputStream).close();
                        }
                    }
                    throw throwable;
                }
                deflaterOutputStream2.flush();
                ((ZipOutputStream)deflaterOutputStream2).close();
            }
            if (deflaterOutputStream != null) {
                deflaterOutputStream.flush();
                ((ZipOutputStream)deflaterOutputStream).close();
            }
        }
        if (!bl && !bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"DeployUtils.publishWSDLFiles: No ports in any published WSDL file");
            }
            return 0;
        }
        if (bl) {
            if (!bl2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"DeployUtils.publishWSDLFiles: Only SOAP ports present in WSDL files");
                }
                return 1;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"DeployUtils.publishWSDLFiles: Both SOAP and Non-SOAP ports present in WSDL files");
            }
            return 3;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"DeployUtils.publishWSDLFiles: Only Non-SOAP ports present in WSDL files");
        }
        return 2;
    }

    public static Definition stripOutNonSoapElements(Definition definition) {
        Map map = definition.getServices();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            QName qName = (QName)iterator.next();
            Service service = (Service)map.get(qName);
            Map map2 = service.getPorts();
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator<Object> iterator2 = map2.keySet().iterator();
            while (iterator2.hasNext()) {
                string = (String)iterator2.next();
                Port port2 = (Port)map2.get(string);
                Binding binding = port2.getBinding();
                boolean bl = false;
                List list = binding.getExtensibilityElements();
                Object object = list.iterator();
                while (object.hasNext()) {
                    ExtensibilityElement extensibilityElement = (ExtensibilityElement)object.next();
                    if (!(extensibilityElement instanceof SOAPBinding)) continue;
                    bl = true;
                    break;
                }
                if (!bl && (object = WSDLUtils.getAddressFromPort(port2)) != null && (((String)(object = ((String)object).toLowerCase())).startsWith("http:") || ((String)object).startsWith("https:") || ((String)object).startsWith("jms:"))) {
                    bl = true;
                }
                if (bl) continue;
                arrayList.add(string);
            }
            iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                string = (String)iterator2.next();
                map2.remove(string);
            }
        }
        return definition;
    }

    public static String stripDelimitersFromFrontOfEJBURLPropertyString(String string) {
        int n;
        String string2 = "&|";
        char[] cArray = string2.toCharArray();
        String[] stringArray = new String[cArray.length];
        for (n = 0; n < cArray.length; ++n) {
            stringArray[n] = new String(new char[]{cArray[n]});
        }
        n = 1;
        block1: while (n != 0) {
            n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.startsWith(stringArray[i])) continue;
                string = string.substring(1);
                n = 1;
                continue block1;
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

