/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.etools.application.Application;
import com.ibm.etools.application.EjbModule;
import com.ibm.etools.application.Module;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.webapplication.Servlet;
import com.ibm.etools.webapplication.ServletMapping;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsdd.PortComponent;
import com.ibm.etools.webservice.wsdd.ServletLink;
import com.ibm.etools.webservice.wsdd.WebServiceDescription;
import com.ibm.etools.webservice.wsdd.WebServices;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.WSModels;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class PluginCfgHelper {
    public static String getRouterModuleName(EARFile eARFile, EjbModule ejbModule) {
        String string = null;
        ModuleFile moduleFile = eARFile.getModuleRef((Module)ejbModule).getModuleFile();
        WSBinding wSBinding = null;
        try {
            wSBinding = WSModels.getWSBinding(moduleFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.PluginCfgHelper.getRouterModuleName", (String)"95");
        }
        if (wSBinding != null) {
            EList eList = wSBinding.getRouterModules();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                RouterModule routerModule = (RouterModule)iterator.next();
                String string2 = routerModule.getTransport();
                if (!string2.equalsIgnoreCase("http")) continue;
                string = routerModule.getName();
                break;
            }
        }
        return string;
    }

    public static List getWebServicesUrlPatterns(EARFile eARFile, List list, Module module) {
        LinkedList<String> linkedList = new LinkedList<String>();
        ModuleFile moduleFile = eARFile.getModuleRef(module).getModuleFile();
        Application application = eARFile.getDeploymentDescriptor();
        WebModule webModule = null;
        boolean bl = module.isWebModule();
        String string = bl ? "WEB-INF/webservices.xml" : "META-INF/webservices.xml";
        WebServices webServices = null;
        try {
            webServices = WSModels.getWebServices(moduleFile.getLoadStrategy(), string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.PluginCfgHelper.getWebServicesUrlPatterns", (String)"155");
        }
        if (webServices != null) {
            ModuleDeployment moduleDeployment;
            EList eList;
            String string2;
            if (bl) {
                webModule = (WebModule)module;
            } else if (module.isEjbModule() && (string2 = PluginCfgHelper.getRouterModuleName(eARFile, (EjbModule)module)) != null) {
                Module module2;
                eList = null;
                for (int i = 0; i < list.size(); ++i) {
                    moduleDeployment = (ModuleDeployment)list.get(i);
                    if (!moduleDeployment.getUri().equals(string2)) continue;
                    eList = moduleDeployment;
                    break;
                }
                if (eList != null && (module2 = application.getModule(string2, null)) != null && module2.isWebModule()) {
                    webModule = (WebModule)module2;
                }
            }
            if (webModule != null) {
                string2 = null;
                try {
                    string2 = eARFile.getDeploymentDescriptor(webModule);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.PluginCfgHelper.getWebServicesUrlPatterns", (String)"199");
                }
                if (string2 != null) {
                    eList = webServices.getWebServiceDescriptions();
                    Iterator iterator = eList.iterator();
                    while (iterator.hasNext()) {
                        moduleDeployment = (WebServiceDescription)iterator.next();
                        EList eList2 = moduleDeployment.getPortComponents();
                        Iterator iterator2 = eList2.iterator();
                        while (iterator2.hasNext()) {
                            String string3;
                            PortComponent portComponent = (PortComponent)iterator2.next();
                            String string4 = portComponent.getPortComponentName();
                            ServletLink servletLink = portComponent.getServiceImplBean().getEServletLink();
                            String string5 = servletLink != null ? servletLink.getServletLink() : string4;
                            String string6 = null;
                            Servlet servlet = string2.getServletNamed(string5);
                            ServletMapping servletMapping = string2.getServletMapping(servlet);
                            boolean bl2 = false;
                            if (servletMapping != null) {
                                string6 = servletMapping.getUrlPattern();
                                bl2 = true;
                            }
                            if (string6 == null) {
                                string6 = "services/" + string4;
                            }
                            String string7 = string3 = string6.endsWith("/") ? string6 + "wsdl/*" : string6 + "/wsdl/*";
                            if (!bl2) {
                                linkedList.add(string6);
                            }
                            linkedList.add(string3);
                        }
                    }
                }
            }
        }
        return linkedList;
    }
}

