/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.webservice.wsbnd.DefaultEndpointURIPrefix;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wsbnd.WsbndFactory;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.WSModels;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

class WSBindingsFileAccessor {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$webservices$deploy$WSBindingsFileAccessor == null ? (class$com$ibm$ws$webservices$deploy$WSBindingsFileAccessor = WSBindingsFileAccessor.class$("com.ibm.ws.webservices.deploy.WSBindingsFileAccessor")) : class$com$ibm$ws$webservices$deploy$WSBindingsFileAccessor), (String)"WebServices", (String)"com.ibm.ws.webservices.deploy.resources.deployMessages");
    private final ModuleFile theModuleBeingSearched;
    private final String moduleName;
    private final AppDeploymentTask task;
    private final String JMS_TRANSPORT_NAME = "jms";
    private final String HTTP_TRANSPORT_NAME = "http";
    private WSBinding wsb = null;
    private String pathToWebservicesBndXmiFile = null;
    static /* synthetic */ Class class$com$ibm$ws$webservices$deploy$WSBindingsFileAccessor;

    public WSBindingsFileAccessor(ModuleFile moduleFile, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        this.theModuleBeingSearched = moduleFile;
        this.moduleName = moduleFile.getName();
        this.task = appDeploymentTask;
        if (moduleFile.isWARFile()) {
            this.pathToWebservicesBndXmiFile = "WEB-INF/ibm-webservices-bnd.xmi";
        } else if (moduleFile.isEJBJarFile()) {
            this.pathToWebservicesBndXmiFile = "META-INF/ibm-webservices-bnd.xmi";
        } else {
            String string = "Constructor: SHOULD NOT HAPPEN, the module must either be an EJB or WAR module";
            Tr.error((TraceComponent)tc, (String)"WSWS0020E", (Object)string);
            throw new AppDeploymentException(string, null);
        }
        try {
            this.wsb = WSModels.getWSBinding(moduleFile.getLoadStrategy(), this.pathToWebservicesBndXmiFile);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.WSBindingsFileAccessor.getRouterModuleNames", (String)"129", (Object)this);
            Object[] objectArray = new Object[]{this.pathToWebservicesBndXmiFile, moduleFile.getName(), exception};
            String string = MessageFormat.format(util.getMessage((AppDeploymentTask)appDeploymentTask, (String)"WSWS0011E"), objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("constructor: " + string));
            }
            Tr.error((TraceComponent)tc, (String)"WSWS0011E", (Object)objectArray);
            throw new AppDeploymentException(string, (Throwable)exception);
        }
        if (this.wsb == null) {
            Object[] objectArray = new Object[]{this.moduleName, this.pathToWebservicesBndXmiFile};
            String string = MessageFormat.format(util.getMessage((AppDeploymentTask)appDeploymentTask, (String)"WSWS0018E"), objectArray);
            Tr.error((TraceComponent)tc, (String)"WSWS0018E", (Object)objectArray);
            throw new AppDeploymentException(string, null);
        }
    }

    String[] getRouterModuleNames() throws AppDeploymentException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRouterModuleNames: moduleName=" + this.moduleName));
        }
        String[] stringArray = new String[]{null, null};
        EList eList = this.wsb.getRouterModules();
        if (eList.size() == 0) {
            return stringArray;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            object = (RouterModule)iterator.next();
            String string = null;
            if (object != null && (string = object.getName()) != null) {
                if (object.getTransport().equals("http")) {
                    stringArray[0] = string;
                } else if (object.getTransport().equals("jms")) {
                    stringArray[1] = string;
                } else {
                    Object[] objectArray = new Object[]{this.moduleName, object.getTransport()};
                    String string2 = MessageFormat.format(util.getMessage((AppDeploymentTask)this.task, (String)"WSWS0042E"), objectArray);
                    Tr.error((TraceComponent)tc, (String)"WSWS0042E", (Object)objectArray);
                    throw new AppDeploymentException(string2, null);
                }
            }
            if (object != null && string != null && (stringArray[0] != null || stringArray[1] != null)) continue;
            Object[] objectArray = new Object[]{this.pathToWebservicesBndXmiFile, this.moduleName};
            String string3 = MessageFormat.format(util.getMessage((AppDeploymentTask)this.task, (String)"WSWS0023E"), objectArray);
            Tr.error((TraceComponent)tc, (String)"WSWS0023E", (Object)objectArray);
            throw new AppDeploymentException(string3, null);
        }
        if (tc.isEntryEnabled()) {
            object = "";
            for (int i = 0; i < stringArray.length; ++i) {
                object = (String)object + stringArray[0] + " ";
            }
            Tr.exit((TraceComponent)tc, (String)("getRouterModuleNames: returning routerModuleNames=" + (String)object));
        }
        return stringArray;
    }

    public void setDefaultURLInfo(Map map) throws AppDeploymentException {
        Object object;
        Object object2;
        StringBuffer stringBuffer;
        if (tc.isDebugEnabled()) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("setDefaultURLInfo(), the map being set contains:\n");
            object2 = map.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                stringBuffer.append("\t protocol=").append((String)object);
                stringBuffer.append(" url=").append(map.get(object));
            }
            object2 = stringBuffer.toString();
            Tr.debug((TraceComponent)tc, (String)object2);
        }
        if ((stringBuffer = this.wsb.getWsdescBindings()).size() > 0) {
            Object object3;
            object2 = (WSDescBinding)stringBuffer.get(0);
            object = object2.getDefaultEndpointURIPrefixes();
            WsbndFactory wsbndFactory = WsbndFactory.eINSTANCE;
            while (object.size() < 3) {
                object3 = wsbndFactory.createDefaultEndpointURIPrefix();
                object3.setText("");
                object.add(object3);
            }
            object3 = map.keySet().iterator();
            while (object3.hasNext()) {
                DefaultEndpointURIPrefix defaultEndpointURIPrefix;
                String string = (String)object3.next();
                if (string.equals("HTTP")) {
                    defaultEndpointURIPrefix = (DefaultEndpointURIPrefix)object.get(0);
                    defaultEndpointURIPrefix.setText((String)map.get(string));
                    continue;
                }
                if (string.equals("JMS")) {
                    defaultEndpointURIPrefix = (DefaultEndpointURIPrefix)object.get(1);
                    defaultEndpointURIPrefix.setText((String)map.get(string));
                    continue;
                }
                if (!string.equals("EJB")) continue;
                defaultEndpointURIPrefix = (DefaultEndpointURIPrefix)object.get(2);
                defaultEndpointURIPrefix.setText((String)map.get(string));
            }
        }
    }

    public Map getDefaultURLInfo() throws AppDeploymentException {
        Object object;
        Object object2;
        Object object3;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EList eList = this.wsb.getWsdescBindings();
        if (eList.size() > 0) {
            String string;
            object3 = (WSDescBinding)eList.get(0);
            object2 = object3.getDefaultEndpointURIPrefixes();
            if (object2.size() > 1) {
                object = (DefaultEndpointURIPrefix)object2.get(0);
                string = object.getText();
                hashMap.put("HTTP", string);
            } else {
                hashMap.put("HTTP", "");
            }
            if (object2.size() > 2) {
                object = (DefaultEndpointURIPrefix)object2.get(1);
                string = object.getText();
                hashMap.put("JMS", string);
            } else {
                hashMap.put("JMS", "");
            }
            if (object2.size() > 3) {
                object = (DefaultEndpointURIPrefix)object2.get(2);
                string = object.getText();
                hashMap.put("EJB", string);
            } else {
                hashMap.put("EJB", "");
            }
        }
        if (tc.isDebugEnabled()) {
            object3 = new StringBuffer();
            ((StringBuffer)object3).append("getDefaultURLInfo(), the map being returned contains:\n");
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                ((StringBuffer)object3).append("\t protocol=").append((String)object);
                ((StringBuffer)object3).append(" url=").append(hashMap.get(object)).append("\n");
            }
            object2 = ((StringBuffer)object3).toString();
            Tr.debug((TraceComponent)tc, (String)object2);
        }
        return hashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

