/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.environment.common.ClassPath;
import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.Status;
import com.ibm.etools.environment.console.ConsoleEnvironment;
import com.ibm.etools.environment.resource.ResourceManagerFactoryImpl;
import com.ibm.etools.webservice.deploy.core.DeployModel;
import com.ibm.etools.webservice.deploy.core.DeployWebService;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.webservices.deploy.DeployUtils;
import java.io.File;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class WSDeployTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$webservices$deploy$WSDeployTask == null ? (class$com$ibm$ws$webservices$deploy$WSDeployTask = WSDeployTask.class$("com.ibm.ws.webservices.deploy.WSDeployTask")) : class$com$ibm$ws$webservices$deploy$WSDeployTask), (String)"WebServices", (String)"com.ibm.ws.webservices.deploy.resources.deployMessages");
    static /* synthetic */ Class class$com$ibm$ws$webservices$deploy$WSDeployTask;

    public WSDeployTask() {
        this.appTaskName = "WSDeployTask";
        this.bundle = ResourceBundle.getBundle("com.ibm.ws.webservices.deploy.resources.deployMessages");
    }

    public boolean performTask() throws AdminException {
        String string;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performTask");
        }
        InstallScheduler installScheduler = (InstallScheduler)this.scheduler;
        EARFile eARFile = installScheduler.getEarFile();
        Hashtable hashtable = installScheduler.getProperties();
        Object v = hashtable.get("deployws");
        boolean bl = DeployUtils.isWebServicesEnabled(eARFile, true);
        boolean bl2 = false;
        if (bl) {
            bl2 = DeployUtils.isWebServicesSecurityEnabled(eARFile);
        }
        if (v != null && ((Boolean)v).booleanValue() && bl) {
            ClassPath classPath;
            Object object2;
            ConsoleEnvironment consoleEnvironment;
            Object object3;
            object = AppUtils.getAppTempDeployDir((Scheduler)installScheduler);
            string = (String)object + File.separator + "ws" + File.separator + AppUtils.getAppDeployFileName((String)installScheduler.getAppName());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"temp deployment ear name", (Object)string);
            }
            Hashtable hashtable2 = (Hashtable)hashtable.get("deployws.options");
            String string2 = (String)hashtable2.get("deployws.classpath");
            String string3 = (String)hashtable2.get("deployws.jardirs");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"{classpath, jardirs}", (Object)new Object[]{string2, string3});
            }
            DeployModel deployModel = new DeployModel();
            deployModel.setInputFile(installScheduler.getEarPath());
            deployModel.setOutputFile(string);
            deployModel.setCodeGenOnly(false);
            deployModel.setGenDebug(false);
            deployModel.setKeepFiles(false);
            deployModel.setIgnoreErrors_(false);
            ClassPath classPath2 = new ClassPath();
            if (string2 != null && (string2 = string2.trim()).length() > 0) {
                classPath2.appendPath(string2);
            }
            if (string3 != null && (string3 = string3.trim()).length() > 0) {
                object3 = new StringTokenizer(string3, ";");
                consoleEnvironment = new String[((StringTokenizer)object3).countTokens()];
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    object2 = ((StringTokenizer)object3).nextToken();
                    classPath = new ClassPath();
                    classPath.appendDir((String)object2);
                    classPath2.appendPath(classPath);
                }
            }
            if ((object3 = this.getWASLibDir()) != null) {
                consoleEnvironment = new ClassPath();
                consoleEnvironment.appendDir((String)object3);
                classPath2.appendPath((ClassPath)consoleEnvironment);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"can not obtain the WAS lib directory");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"class path: ", (Object)classPath2);
            }
            deployModel.setClassPath(classPath2);
            consoleEnvironment = new ConsoleEnvironment();
            object2 = ResourceManagerFactoryImpl.getInstance();
            object2.register("file", consoleEnvironment.getResourceManager());
            classPath = new DeployWebService();
            classPath.setDeployModel(deployModel);
            Status status = classPath.execute((Environment)consoleEnvironment);
            int n = status.getSeverity();
            String string4 = status.getMessage();
            switch (n) {
                case 4: {
                    Tr.error((TraceComponent)tc, (String)"WSWS0038E", (Object)string4);
                    this.iterateError(status);
                    installScheduler.propagateTaskEvent(this.createNotification("Failed", "WSWS0038E", new String[]{string4}));
                    if (status.getThrowable() != null) {
                        throw new AdminException(status.getThrowable(), string4);
                    }
                    throw new AdminException(string4);
                }
                case 2: {
                    Tr.warning((TraceComponent)tc, (String)"WSWS0039W", (Object)string4);
                    installScheduler.propagateTaskEvent(this.createNotification("Completed", "WSWS0039W", new String[]{string4}));
                    break;
                }
                case 1: {
                    Tr.info((TraceComponent)tc, (String)"WSWS0040I", (Object)string4);
                    installScheduler.propagateTaskEvent(this.createNotification("Completed", "WSWS0040I", new String[]{string4}));
                    break;
                }
                case 0: {
                    Tr.audit((TraceComponent)tc, (String)"WSWS0041I");
                    installScheduler.propagateTaskEvent(this.createNotification("Completed", "WSWS0041I", null));
                }
            }
            installScheduler.setEarPath(string);
        }
        if (bl && bl2) {
            object = ResourceBundle.getBundle("com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
            string = null;
            if (object != null) {
                string = ((ResourceBundle)object).getString("security.wssecurity.appinstall.warning");
            }
            if (string == null) {
                string = "WSEC0106W: Your application may have Web Services Security enabled. If it does, you must go to the Enterprise Application Management panels to configure the binding information for Web Services Security. The binding information for Web Services Security is not collected during application deployment. If it is not properly configured, your application may not start or be usable.";
            }
            installScheduler.propagateTaskEvent(this.createTranslatedNotification("InProgress", string, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performTask");
        }
        return true;
    }

    private String getWASLibDir() {
        String string = System.getProperty("was.install.root");
        if (string == null) {
            string = System.getProperty("user.install.root");
        }
        if (string != null) {
            string = string + "/lib";
        }
        return string;
    }

    private void iterateError(Status status) {
        Status[] statusArray = status.getChildren();
        for (int i = 0; i < statusArray.length; ++i) {
            Status status2 = statusArray[i];
            if (status2 == null) continue;
            String string = status2.getMessage();
            Tr.error((TraceComponent)tc, (String)"WSWS0038E", (Object)string);
            this.iterateError(status2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

