/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.SOAPPart;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.attachments.AttachmentsImpl;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.enum.MessageType;
import com.ibm.ws.webservices.engine.transport.http.HTTP11Sender;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;

public class Message
extends SOAPMessage
implements Serializable {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$Message == null ? (class$com$ibm$ws$webservices$engine$Message = Message.class$("com.ibm.ws.webservices.engine.Message")) : class$com$ibm$ws$webservices$engine$Message).getName());
    public static final String MIME_MULTIPART_RELATED = "multipart/related";
    public static final String MIME_APPLICATION_DIME = "application/dime";
    public static final String DEFAULT_ATTACHMENT_IMPL;
    public static final String DEFAULT_ATTACHMNET_IMPL;
    private static String mAttachmentsImplClassName;
    public static final String MIME_UNKNOWN = "  ";
    private MessageType messageType = MessageType.UNKNOWN;
    private SOAPPart mSOAPPart;
    private Attachments mAttachments = null;
    private MimeHeaders headers;
    private boolean saveRequired = true;
    private String characterEncoding = null;
    private MessageContext msgContext;
    private static Class attachImpl;
    private static Constructor attachImplConstr;
    private static boolean checkForAttchmentSupport;
    private static boolean attachmentSupportEnabled;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$Message;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$attachments$AttachmentsImpl;

    public static String getAttachmentImplClassName() {
        return mAttachmentsImplClassName;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.msgContext = messageContext;
    }

    public Message(Object object, boolean bl) {
        this.setup(object, bl, null, null, null);
    }

    public Message(Object object, boolean bl, MimeHeaders mimeHeaders) {
        this.setup(object, bl, null, null, mimeHeaders);
    }

    public Message(Object object, MimeHeaders mimeHeaders) {
        this.setup(object, true, null, null, mimeHeaders);
    }

    public Message(Object object, boolean bl, String string, String string2) {
        this.setup(object, bl, string, string2, null);
    }

    public Message(Object object) {
        this.setup(object, false, null, null, null);
    }

    private static synchronized boolean isAttachmentSupportEnabled(MessageContext messageContext) {
        if (checkForAttchmentSupport) {
            checkForAttchmentSupport = false;
            try {
                WebServicesEngine webServicesEngine;
                String string = "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl";
                if (null != messageContext && null != (webServicesEngine = messageContext.getEngine())) {
                    string = (String)webServicesEngine.getOption("attachments.implementation");
                }
                if (null == string) {
                    string = "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl";
                }
                ClassUtils.forName("javax.activation.DataHandler");
                ClassUtils.forName("javax.mail.internet.MimeMultipart");
                attachImpl = ClassUtils.forName(string);
                mAttachmentsImplClassName = attachImpl.getName();
                attachImplConstr = attachImpl.getConstructors()[0];
                attachmentSupportEnabled = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            log.debug((Object)(Messages.getMessage("attachEnabled") + MIME_UNKNOWN + attachmentSupportEnabled));
        }
        return attachmentSupportEnabled;
    }

    private void setup(Object object, boolean bl, String string, String string2, MimeHeaders mimeHeaders) {
        int n;
        Object object2;
        if (string == null && mimeHeaders != null) {
            object2 = mimeHeaders.getHeader("Content-Type");
            String string3 = string = object2 != null ? object2[0] : null;
        }
        if (string2 == null && mimeHeaders != null) {
            object2 = mimeHeaders.getHeader("Content-Location");
            String string4 = string2 = object2 != null ? object2[0] : null;
        }
        if (string != null && (n = ((String)(object2 = string.toLowerCase())).indexOf("charset=")) > 0) {
            if ((n = ((String)(object2 = ((String)object2).substring(n + "charset=".length()))).indexOf("utf-8")) == 0 || n == 1) {
                this.setCharacterEncoding("utf-8");
            }
            if ((n = ((String)object2).indexOf("utf-16")) == 0 || n == 1) {
                this.setCharacterEncoding("utf-16");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message.setup() CharacterEncoding=" + this.getCharacterEncoding()));
            log.debug((Object)("Message.setup() contentType=" + string));
        }
        if (Message.isAttachmentSupportEnabled(this.getMessageContext())) {
            if (attachImpl.equals(class$com$ibm$ws$webservices$engine$attachments$AttachmentsImpl == null ? (class$com$ibm$ws$webservices$engine$attachments$AttachmentsImpl = Message.class$("com.ibm.ws.webservices.engine.attachments.AttachmentsImpl")) : class$com$ibm$ws$webservices$engine$attachments$AttachmentsImpl)) {
                try {
                    this.mAttachments = new AttachmentsImpl(object, string, string2);
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.Message.setup", (String)"369", (Object)this);
                    log.fatal((Object)Messages.getMessage("invocationTargetException00"), (Throwable)webServicesFault);
                    throw new RuntimeException(webServicesFault.getMessage());
                }
                this.mSOAPPart = (SOAPPart)this.mAttachments.getRootPart();
            } else {
                try {
                    this.mAttachments = (Attachments)attachImplConstr.newInstance(object, string, string2);
                    this.mSOAPPart = (SOAPPart)this.mAttachments.getRootPart();
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.webservices.engine.Message.setup", (String)"360", (Object)this);
                    log.fatal((Object)Messages.getMessage("invocationTargetException00"), (Throwable)invocationTargetException);
                    throw new RuntimeException(invocationTargetException.getMessage());
                }
                catch (InstantiationException instantiationException) {
                    FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.webservices.engine.Message.setup", (String)"365", (Object)this);
                    log.fatal((Object)Messages.getMessage("instantiationException00"), (Throwable)instantiationException);
                    throw new RuntimeException(instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.webservices.engine.Message.setup", (String)"370", (Object)this);
                    log.fatal((Object)Messages.getMessage("illegalAccessException00"), (Throwable)illegalAccessException);
                    throw new RuntimeException(illegalAccessException.getMessage());
                }
            }
        }
        if (null == this.mSOAPPart) {
            this.mSOAPPart = new SOAPPart(object, bl);
        }
        this.mSOAPPart.setMessage(this);
        if (this.mAttachments != null) {
            this.mAttachments.setRootPart(this.mSOAPPart);
        }
        this.headers = mimeHeaders == null ? new MimeHeaders() : mimeHeaders;
    }

    public javax.xml.soap.SOAPPart getSOAPPart() {
        return this.mSOAPPart;
    }

    public String getSOAPPartAsString() throws WebServicesFault {
        return this.mSOAPPart.getAsString();
    }

    public byte[] getSOAPPartAsBytes() throws WebServicesFault {
        return this.mSOAPPart.getAsBytes();
    }

    public SOAPEnvelope getSOAPEnvelope() throws WebServicesFault {
        return this.mSOAPPart.getAsSOAPEnvelope();
    }

    public Attachments getAttachmentsImpl() {
        return this.mAttachments;
    }

    public String getContentType(SOAPConstants sOAPConstants) throws WebServicesFault {
        int n = 1;
        if (this.msgContext != null && this.msgContext.getPortDesc() != null) {
            n = this.msgContext.getPortDesc().getSendType();
        }
        if (n != 4) {
            this.mSOAPPart.getAsBytes();
        }
        String string = sOAPConstants.getContentType();
        if (this.mAttachments != null && 0 != this.mAttachments.getAttachmentCount()) {
            string = this.mAttachments.getContentType();
        }
        return string;
    }

    public long getContentLength() throws WebServicesFault {
        return this.mAttachments != null && 0 < this.mAttachments.getAttachmentCount() ? this.mAttachments.getContentLength() : (long)this.mSOAPPart.getContentLength();
    }

    public void writeTo(OutputStream outputStream) throws SOAPException, IOException {
        boolean bl = false;
        IOException iOException = null;
        if (this.mAttachments == null || 0 == this.mAttachments.getAttachmentCount()) {
            try {
                this.mSOAPPart.writeTo(outputStream, "UTF-8");
            }
            catch (IOException iOException2) {
                FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.webservices.engine.Message.writeTo", (String)"481", (Object)this);
                iOException = iOException2;
                bl = true;
            }
        } else {
            try {
                this.mAttachments.writeContentToStream(outputStream);
            }
            catch (IOException iOException3) {
                FFDCFilter.processException((Throwable)iOException3, (String)"com.ibm.ws.webservices.engine.Message.writeTo", (String)"5", (Object)this);
                iOException = iOException3;
                bl = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.Message.writeTo", (String)"488", (Object)this);
                log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
            }
        }
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = outputStream instanceof HTTP11Sender.HTTP11OutputStream && ((HTTP11Sender.HTTP11OutputStream)outputStream).fromPooledSocket();
            if (bl2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage("javaIOException00"), (Throwable)iOException);
                }
            } else {
                log.error((Object)Messages.getMessage("javaIOException00"), (Throwable)iOException);
            }
            throw iOException;
        }
    }

    public String getContentDescription() {
        String[] stringArray = this.headers.getHeader("Content-Description");
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public void setContentDescription(String string) {
        this.headers.setHeader("Content-Description", string);
    }

    public void saveChanges() throws SOAPException {
        this.saveRequired = false;
    }

    public boolean saveRequired() {
        return this.saveRequired;
    }

    public MimeHeaders getMimeHeaders() {
        if (this.mAttachments != null && 0 != this.mAttachments.getAttachmentCount()) {
            try {
                this.headers.setHeader("Content-Type", this.mAttachments.getContentType());
            }
            catch (Exception exception) {
                log.debug((Object)"can not get the content type for the attachment", (Throwable)exception);
            }
        }
        return this.headers;
    }

    public void removeAllAttachments() {
        this.mAttachments.removeAllAttachments();
    }

    public int countAttachments() {
        return this.mAttachments == null ? 0 : this.mAttachments.getAttachmentCount();
    }

    public Iterator getAttachments() {
        try {
            return this.mAttachments.getAttachments().iterator();
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.Message.getAttachments", (String)"601", (Object)this);
            log.error((Object)Messages.getMessage("exception00"), (Throwable)webServicesFault);
            return null;
        }
    }

    public Iterator getAttachments(MimeHeaders mimeHeaders) {
        return this.mAttachments.getAttachments(mimeHeaders);
    }

    public void addAttachmentPart(AttachmentPart attachmentPart) {
        try {
            this.mAttachments.addAttachmentPart((Part)((Object)attachmentPart));
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.Message.addAttachmentPart", (String)"636", (Object)this);
            log.error((Object)Messages.getMessage("exception00"), (Throwable)webServicesFault);
        }
    }

    public AttachmentPart createAttachmentPart() {
        try {
            return (AttachmentPart)((Object)this.mAttachments.createAttachmentPart());
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.Message.createAttachmentPart", (String)"655", (Object)this);
            log.error((Object)Messages.getMessage("exception00"), (Throwable)webServicesFault);
            return null;
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string != null && (string.startsWith("\"") || string.startsWith("'")) && (string.endsWith("\"") || string.endsWith("'")) ? (string.length() > 2 ? string.substring(1, string.length() - 1) : "") : string;
    }

    public void ifFaultThrowSelf() throws WebServicesFault {
        WebServicesFault webServicesFault = null;
        try {
            webServicesFault = this.getFault();
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.Message.ifFaultThrowSelf", (String)"722", null);
            throw WebServicesFault.makeFault(sOAPException);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.Message.ifFaultThrowSelf", (String)"757", null);
            throw WebServicesFault.makeFault(iOException);
        }
        if (webServicesFault != null) {
            throw webServicesFault;
        }
    }

    public WebServicesFault getFault() throws SOAPException, IOException {
        return this.mSOAPPart.getFault();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DEFAULT_ATTACHMNET_IMPL = DEFAULT_ATTACHMENT_IMPL = (class$com$ibm$ws$webservices$engine$attachments$AttachmentsImpl == null ? (class$com$ibm$ws$webservices$engine$attachments$AttachmentsImpl = Message.class$("com.ibm.ws.webservices.engine.attachments.AttachmentsImpl")) : class$com$ibm$ws$webservices$engine$attachments$AttachmentsImpl).getName();
        mAttachmentsImplClassName = DEFAULT_ATTACHMENT_IMPL;
        attachImpl = null;
        attachImplConstr = null;
        checkForAttchmentSupport = true;
        attachmentSupportEnabled = false;
    }
}

