/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.client.ClientXMLProcessor;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.enum.Style;
import com.ibm.ws.webservices.engine.enum.Use;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.schema.SchemaVersion;
import com.ibm.ws.webservices.engine.session.Session;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.LockableHashtable;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;

public class MessageContext
implements SOAPMessageContext,
RPCContext,
Cloneable {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$MessageContext == null ? (class$com$ibm$ws$webservices$engine$MessageContext = MessageContext.class$("com.ibm.ws.webservices.engine.MessageContext")) : class$com$ibm$ws$webservices$engine$MessageContext).getName());
    private static ThreadLocal currentThreadMessageContext = new ThreadLocal();
    private Message requestMessage;
    private Message responseMessage;
    private String targetPortName;
    private String transportName;
    private WebServicesEngine engine;
    private Session session;
    private boolean havePassedPivot = false;
    private boolean highFidelity = false;
    public static final int MESSAGE_PATH_REQUEST = 1;
    public static final int MESSAGE_PATH_RESPONSE = 2;
    public static final int MESSAGE_PATH_FALSE = 3;
    public static final int MESSAGE_PATH_FAULT = 4;
    public static final int MESSAGE_PATH_CLOSURE = 5;
    private int messagePath = 1;
    private static final Set beenDir = new HashSet();
    private static String systemTempDirName = null;
    public static final String PARAM_MINOCCURS_0 = "PARAM_MINOCCURS_0";
    public static final String PARAM_MAXOCCURS_NOT1 = "PARAM_MAXOCCURS_NOT1";
    private TypeMappingRegistry mappingRegistry = null;
    private LockableHashtable bag = new LockableHashtable();
    private SOAPConstants soapConstants = Constants.DEFAULT_SOAP_VERSION;
    private SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
    private SOAPPort _port;
    private OperationDesc currentOperation = null;
    public static String TRANS_URL;
    public static String TRANS_URL_HTTP_REDIRECTED;
    public static String QUIT_REQUESTED;
    public static String AUTHUSER;
    public static String ATTACHMENTS_DIR;
    public static String WSDLGEN_INTFNAMESPACE;
    public static String WSDLGEN_SERV_LOC_URL;
    public static String HTTP_TRANSPORT_VERSION;
    public static String SAAJ_TRANSFORMATION;
    public static String FAULT_ON_SAAJ_TRANSFORMATION;
    private List oneWayListeners = null;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$MessageContext;

    public MessageContext(WebServicesEngine webServicesEngine) {
        this.engine = webServicesEngine;
        if (null != webServicesEngine) {
            String string;
            Map map = webServicesEngine.getOptions();
            String string2 = null;
            if (null != map) {
                string2 = (String)map.get("attachments.Directory");
            }
            if (null != string2) {
                MessageContext.createDir(string2);
            } else {
                string2 = systemTempDirName;
            }
            if (string2 != null) {
                this.setProperty(ATTACHMENTS_DIR, string2);
            }
            if ((string = (String)map.get("defaultSOAPVersion")) != null && "1.2".equals(string)) {
                this.setSOAPConstants(SOAPConstants.SOAP12_CONSTANTS);
            }
        }
    }

    public static void setCurrentThreadsContext(MessageContext messageContext) {
        currentThreadMessageContext.set(messageContext);
    }

    public static MessageContext getCurrentContext() {
        return MessageContext.getCurrentThreadsContext();
    }

    public static MessageContext getCurrentThreadsContext() {
        return (MessageContext)currentThreadMessageContext.get();
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public void setRequestMessage(Message message) {
        this.requestMessage = message;
        if (this.requestMessage != null) {
            this.requestMessage.setMessageContext(this);
        }
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(Message message) {
        this.responseMessage = message;
        if (this.responseMessage != null) {
            this.responseMessage.setMessageContext(this);
            Message message2 = this.getRequestMessage();
            if (null != message2) {
                Attachments attachments = message2.getAttachmentsImpl();
                Attachments attachments2 = message.getAttachmentsImpl();
                if (null != attachments && null != attachments2 && attachments2.getSendType() == 1) {
                    attachments2.setSendType(attachments.getSendType());
                }
            }
        }
    }

    public void setOperation(OperationDesc operationDesc) {
        this.currentOperation = operationDesc;
    }

    public OperationDesc getOperation() {
        return this.currentOperation;
    }

    public OperationDesc resolveOperation() {
        OperationDesc operationDesc = this.getOperation();
        if (operationDesc == null) {
            try {
                this.getCurrentMessage().getSOAPEnvelope();
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.MessageContext.resolveOperation", (String)"420", (Object)this);
                throw new RuntimeException(webServicesFault);
            }
            operationDesc = this.getOperation();
        }
        return operationDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        if (this.getPortDesc() != null) {
            PortDesc portDesc = this.getPortDesc();
            synchronized (portDesc) {
                this.getPortDesc().setTypeMappingRegistry(typeMappingRegistry);
            }
            this.mappingRegistry = null;
        } else {
            this.mappingRegistry = typeMappingRegistry;
        }
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.getPortDesc() != null) {
            return this.getPortDesc().getTypeMappingRegistry();
        }
        if (this.mappingRegistry == null) {
            this.mappingRegistry = this.engine.getTypeMappingRegistry();
        }
        return this.mappingRegistry;
    }

    public TypeMapping getTypeMapping() {
        TypeMapping typeMapping = (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(this.getEncodingStyle());
        return typeMapping;
    }

    public SOAPConstants getSOAPConstants() {
        return this.soapConstants;
    }

    public void setSOAPConstants(SOAPConstants sOAPConstants) {
        if (this.soapConstants.getEncodingURI().equals(this.getEncodingStyle())) {
            this.setEncodingStyle(sOAPConstants.getEncodingURI());
        }
        this.soapConstants = sOAPConstants;
    }

    public SchemaVersion getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(SchemaVersion schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean isEncoded() {
        return this.getOperationUse() == Use.ENCODED;
    }

    public Message getCurrentMessage() {
        return this.havePassedPivot ? this.responseMessage : this.requestMessage;
    }

    public SOAPMessage getMessage() {
        return this.getCurrentMessage();
    }

    public void setCurrentMessage(Message message) {
        message.setMessageContext(this);
        if (this.havePassedPivot) {
            this.responseMessage = message;
        } else {
            this.requestMessage = message;
        }
    }

    public void setMessage(SOAPMessage sOAPMessage) {
        this.setCurrentMessage((Message)sOAPMessage);
    }

    public boolean getPastPivot() {
        return this.havePassedPivot;
    }

    public void setPastPivot(boolean bl) {
        this.havePassedPivot = bl;
    }

    public boolean isRequestPath() {
        return !this.havePassedPivot;
    }

    public boolean isReponsePath() {
        return this.havePassedPivot;
    }

    public String getTargetPortName() {
        return this.targetPortName;
    }

    public WebServicesEngine getEngine() {
        return this.engine;
    }

    public void setTargetPort(String string) throws WebServicesFault {
        block4: {
            log.debug((Object)("MessageContext: setTargetPort(" + string + ")"));
            if (string == null) {
                this.setPort(null);
            } else {
                try {
                    this.setPort(this.getEngine().getPort(string));
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.MessageContext.setTargetPort", (String)"626", (Object)this);
                    this.setPort(null);
                    if (this.isClient()) break block4;
                    throw webServicesFault;
                }
            }
        }
        this.targetPortName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(SOAPPort sOAPPort) throws WebServicesFault {
        log.debug((Object)("MessageContext: setPort(" + sOAPPort + ")"));
        TypeMappingRegistry typeMappingRegistry = this.getTypeMappingRegistry();
        this._port = sOAPPort;
        if (this._port != null) {
            this.targetPortName = this._port.getName();
            if (this.isClient() && this.getOperation() != null && !this._port.getPortDesc().getOperations().contains(this.getOperation())) {
                PortDesc portDesc = this.getPortDesc();
                synchronized (portDesc) {
                    this.getPortDesc().addOperationDesc(this.getOperation());
                    this.getPortDesc().setTypeMappingRegistry(typeMappingRegistry);
                    this.getPortDesc().setStyle(this.getOperationStyle());
                    this.getPortDesc().setUse(this.getOperationUse());
                }
            } else {
                this.setOperationStyle(this.getPortDesc().getStyle());
                this.setOperationUse(this.getPortDesc().getUse());
            }
            this.setEncodingStyle(this.getPortDesc().getUse().getEncoding());
            this.bag.setParent(sOAPPort.getOptions());
            if (this.getPortDesc().needsHighFidelityRecording()) {
                this.highFidelity = true;
            }
            sOAPPort.getInitializedPortDesc(this);
        }
        this.patchProperties();
    }

    private void patchProperties() {
        ParameterDesc parameterDesc;
        QName qName;
        Iterator iterator;
        Object object = this.getProperty(PARAM_MINOCCURS_0);
        if (object != null && this.currentOperation != null) {
            iterator = ((Set)object).iterator();
            while (iterator.hasNext()) {
                qName = (QName)iterator.next();
                parameterDesc = this.currentOperation.getParamByQName(qName);
                if (parameterDesc != null) {
                    parameterDesc.setMinOccursIs0(true);
                }
                if ((parameterDesc = this.currentOperation.getReturnParamDesc()) == null || !qName.equals(parameterDesc.getQName())) continue;
                parameterDesc.setMinOccursIs0(true);
            }
        }
        if ((object = this.getProperty(PARAM_MAXOCCURS_NOT1)) != null && this.currentOperation != null) {
            iterator = ((Set)object).iterator();
            while (iterator.hasNext()) {
                qName = (QName)iterator.next();
                parameterDesc = this.currentOperation.getParamByQName(qName);
                if (parameterDesc != null) {
                    parameterDesc.setMaxOccursIs1(false);
                }
                if ((parameterDesc = this.currentOperation.getReturnParamDesc()) == null || !qName.equals(parameterDesc.getQName())) continue;
                parameterDesc.setMaxOccursIs1(false);
            }
        }
    }

    public SOAPPort getPort() {
        return this._port;
    }

    public PortDesc getPortDesc() {
        return this.getPort() == null ? null : this.getPort().getPortDesc();
    }

    public boolean isClient() {
        return !this.isServer();
    }

    public boolean isServer() {
        return this.getEngine().isServer();
    }

    public String getStrProp(String string) {
        return (String)this.getProperty(string);
    }

    public boolean isPropertyTrue(String string) {
        return this.isPropertyTrue(string, false);
    }

    public boolean isPropertyTrue(String string, boolean bl) {
        return JavaUtils.isTrue(this.getProperty(string), bl);
    }

    public void setProperty(String string, Object threadLocal) {
        if (string == null || threadLocal == null) {
            throw new JAXRPCException(Messages.getMessage(string == null ? "badProp03" : "badProp04"));
        }
        if ((string = string.intern()) == "javax.xml.rpc.security.auth.username" || string == "javax.xml.rpc.security.auth.password" || string == "http.proxyHost" || string == "http.proxyPort" || string == "http.proxyUser" || string == "http.proxyPassword" || string == "https.proxyHost" || string == "https.proxyPort" || string == "https.proxyUser" || string == "https.proxyPassword" || string == "ssl.configName" || string == "javax.xml.rpc.soap.http.soapaction.uri" || string == "transport_name") {
            if (!(threadLocal instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", threadLocal.getClass().getName()}));
            }
        } else if (string == "javax.xml.rpc.session.maintain" || string == "http.redirect.enabled" || string == "javax.xml.rpc.soap.http.soapaction.use" || string == "tcp.noDelay") {
            if (!(threadLocal instanceof Boolean)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.Boolean", threadLocal.getClass().getName()}));
            }
        } else if (string == "javax.xml.rpc.soap.operation.style") {
            if (!(threadLocal instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", threadLocal.getClass().getName()}));
            }
            if ((threadLocal = Style.getStyle((String)((Object)threadLocal), Style.DEFAULT)) == Style.DOCUMENT || threadLocal == Style.WRAPPED) {
                this.setProperty("operation_use", "literal");
            } else if (threadLocal == Style.RPC) {
                this.setProperty("operation_use", "encoded");
            }
        } else if (string == "operation_use") {
            if (!(threadLocal instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", threadLocal.getClass().getName()}));
            }
            threadLocal = Use.getUse((String)((Object)threadLocal), Use.DEFAULT);
        } else if (string == "javax.xml.rpc.encodingstyle.namespace.uri") {
            if (!(threadLocal instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", threadLocal.getClass().getName()}));
            }
            if (Constants.isSOAP_ENC((String)((Object)threadLocal))) {
                threadLocal = this.soapConstants.getEncodingURI();
            }
        } else if (string == "javax.xml.rpc.service.endpoint.address") {
            if (!(threadLocal instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", threadLocal.getClass().getName()}));
            }
            try {
                threadLocal = new URL((String)((Object)threadLocal));
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.webservices.engine.MessageContext.setProperty", (String)"874", (Object)this);
                throw new JAXRPCException(malformedURLException);
            }
        } else if (string == "attachment_encapsulation_format") {
            if (!(threadLocal instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", threadLocal.getClass().getName()}));
            }
            if (!threadLocal.equals("webservices.attachment.style.mime") && !threadLocal.equals("webservices.attachment.style.dime")) {
                throw new JAXRPCException(Messages.getMessage("badattachmenttypeerr", new String[]{(String)((Object)threadLocal), "webservices.attachment.style.mime webservices.attachment.style.dime"}));
            }
        } else if (string == SAAJ_TRANSFORMATION) {
            if (!(threadLocal instanceof RuntimeException)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.RuntimeException", threadLocal.getClass().getName()}));
            }
        } else if (string == "com.ibm.ws.webservices.engine.session.context") {
            if (!(threadLocal instanceof ThreadLocal)) {
                ThreadLocal threadLocal2 = (ThreadLocal)this.bag.get(string);
                if (threadLocal2 == null) {
                    threadLocal2 = new ThreadLocal();
                }
                threadLocal2.set(threadLocal);
                threadLocal = threadLocal2;
            }
        } else if (string.startsWith("java.") || string.startsWith("javax.")) {
            throw new JAXRPCException(Messages.getMessage("badProp05", string));
        }
        this.bag.put(string, threadLocal);
    }

    public boolean containsProperty(String string) {
        Object object = this.getProperty(string);
        return object != null;
    }

    public Iterator getPropertyNames() {
        return this.bag.keySet().iterator();
    }

    public Object getProperty(String string) {
        Object object = null;
        if (string != null && (object = this.bag.get(string = string.intern())) != null) {
            if (string == "javax.xml.rpc.soap.operation.style") {
                object = ((Style)object).getName();
            } else if (string == "operation_use") {
                object = ((Use)object).getName();
            } else if (string == "javax.xml.rpc.service.endpoint.address") {
                object = ((URL)object).toString();
            } else if (string == "com.ibm.ws.webservices.engine.session.context") {
                object = ((ThreadLocal)object).get();
            }
        }
        return object;
    }

    public void setUsername(String string) {
        if (string != null) {
            this.setProperty("javax.xml.rpc.security.auth.username", string);
        }
    }

    public String getUsername() {
        return (String)this.getProperty("javax.xml.rpc.security.auth.username");
    }

    public void setPassword(String string) {
        if (string != null) {
            this.setProperty("javax.xml.rpc.security.auth.password", string);
        }
    }

    public String getPassword() {
        return (String)this.getProperty("javax.xml.rpc.security.auth.password");
    }

    public void setMaintainSession(boolean bl) {
        this.setProperty("javax.xml.rpc.session.maintain", new Boolean(bl));
    }

    public boolean getMaintainSession() {
        Boolean bl = (Boolean)this.getProperty("javax.xml.rpc.session.maintain");
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void setOperationStyle(String string) {
        if (string != null) {
            this.setProperty("javax.xml.rpc.soap.operation.style", string);
            if (this.currentOperation != null) {
                this.currentOperation.setStyle(this.getOperationStyle());
            }
        }
    }

    public void setOperationStyle(Style style) {
        if (style != null) {
            this.bag.put("javax.xml.rpc.soap.operation.style", style);
            if (this.currentOperation != null) {
                this.currentOperation.setStyle(style);
            }
        }
    }

    public Style getOperationStyle() {
        Style style = (Style)this.bag.get("javax.xml.rpc.soap.operation.style");
        if (style == null) {
            style = Style.RPC;
        }
        return style;
    }

    public void setOperationUse(String string) {
        if (string != null) {
            this.setProperty("operation_use", string);
            if (this.currentOperation != null) {
                this.currentOperation.setUse(this.getOperationUse());
            }
        }
    }

    public void setOperationUse(Use use) {
        if (use != null) {
            this.bag.put("operation_use", use);
            if (this.currentOperation != null) {
                this.currentOperation.setUse(use);
            }
        }
    }

    public Use getOperationUse() {
        Use use = (Use)this.bag.get("operation_use");
        return use == null ? Use.ENCODED : use;
    }

    public void setUseSOAPAction(boolean bl) {
        this.setProperty("javax.xml.rpc.soap.http.soapaction.use", new Boolean(bl));
    }

    public boolean useSOAPAction() {
        Boolean bl = (Boolean)this.getProperty("javax.xml.rpc.soap.http.soapaction.use");
        return bl != null && bl != false;
    }

    public void setSOAPActionURI(String string) {
        if (string != null) {
            this.setProperty("javax.xml.rpc.soap.http.soapaction.uri", string);
        }
    }

    public String getSOAPActionURI() {
        return (String)this.getProperty("javax.xml.rpc.soap.http.soapaction.uri");
    }

    public void setEncodingStyle(String string) {
        if (string == null) {
            string = "";
        } else if (Constants.isSOAP_ENC(string)) {
            string = this.soapConstants.getEncodingURI();
        }
        this.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", string);
    }

    public String getEncodingStyle() {
        String string = (String)this.getProperty("javax.xml.rpc.encodingstyle.namespace.uri");
        string = string == null ? Use.ENCODED.getEncoding() : string;
        return string;
    }

    public int getTimeout() {
        Integer n = (Integer)this.getProperty("timeout");
        return n == null ? 0 : n;
    }

    public void setTimeout(Integer n) {
        if (n != null) {
            this.setProperty("timeout", n);
        }
    }

    public void setTimeout(int n) {
        this.setProperty("timeout", new Integer(n));
    }

    public QName getPortName() {
        return (QName)this.getProperty("wsdl.portName");
    }

    public void setPortName(QName qName) {
        if (qName != null) {
            this.setProperty("wsdl.portName", qName);
        }
    }

    public String getTransportName() {
        return (String)this.getProperty("transport_name");
    }

    public void setTransportName(String string) {
        if (string != null) {
            this.setProperty("transport_name", string);
        }
    }

    public void setTargetEndpointAddress(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.webservices.engine.MessageContext.setTargetEndpointAddress", (String)"1364", (Object)this);
            throw new JAXRPCException(malformedURLException);
        }
        this.setTargetEndpointAddress(uRL);
    }

    public void setTargetEndpointAddress(URL uRL) {
        if (uRL != null) {
            this.bag.put("javax.xml.rpc.service.endpoint.address", uRL);
        }
    }

    public String getTargetEndpointAddress() {
        return (String)this.getProperty("javax.xml.rpc.service.endpoint.address");
    }

    public URL getTargetEndpointAddressAsURL() {
        return (URL)this.bag.get("javax.xml.rpc.service.endpoint.address");
    }

    public void removeProperty(String string) {
        if (this.bag != null) {
            if ("com.ibm.ws.webservices.engine.session.context".equals(string)) {
                ThreadLocal threadLocal = (ThreadLocal)this.bag.get(string);
                if (threadLocal != null) {
                    threadLocal.set(null);
                }
            } else {
                this.bag.remove(string);
            }
        }
    }

    public boolean isClientFlow() {
        return !this.isServer();
    }

    public boolean isServerFlow() {
        return this.isServer();
    }

    public boolean isHighFidelity() {
        return this.highFidelity;
    }

    public void setHighFidelity(boolean bl) {
        this.highFidelity = bl;
    }

    public String[] getRoles() {
        Collection collection;
        String[] stringArray = null;
        if (this.getPort() != null && this.getPort().getHandlerChain() != null && (collection = this.getPort().getHandlerChain().getRoles()) != null) {
            stringArray = new String[collection.size()];
            stringArray = collection.toArray(stringArray);
        }
        return stringArray;
    }

    public Object clone() throws CloneNotSupportedException {
        MessageContext messageContext = (MessageContext)super.clone();
        messageContext.bag = (LockableHashtable)this.bag.clone();
        return messageContext;
    }

    public boolean isOneWay() {
        return this.getOperation() == null ? false : this.getOperation().isOneway();
    }

    public void addOneWayListener(OneWayListener oneWayListener) {
        if (this.oneWayListeners == null) {
            this.oneWayListeners = new ArrayList();
        }
        this.oneWayListeners.add(oneWayListener);
    }

    public void removeOneWayListener(OneWayListener oneWayListener) {
        if (this.oneWayListeners != null) {
            this.oneWayListeners.remove(oneWayListener);
        }
    }

    public void oneWayEvent() {
        if (this.oneWayListeners != null) {
            for (int i = 0; i < this.oneWayListeners.size(); ++i) {
                ((OneWayListener)this.oneWayListeners.get(i)).oneWay(this);
            }
        }
    }

    public int getMessagePath() {
        return this.messagePath;
    }

    public void setMessagePath(int n) {
        this.messagePath = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createDir(final String string) {
        Set set = beenDir;
        synchronized (set) {
            if (string != null && !beenDir.contains(string)) {
                beenDir.add(string);
                AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        try {
                            File file = new File(string);
                            if (!file.isDirectory()) {
                                file.mkdirs();
                            }
                            return string;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webservices.engine.MessageContext", (String)"318");
                            return null;
                        }
                    }
                });
            }
        }
    }

    public RPCContext getRPCContext() {
        return this;
    }

    public QName[] getWSDLParameters() {
        OperationDesc operationDesc = this.resolveOperation();
        ArrayList arrayList = operationDesc.getParameters();
        QName[] qNameArray = new QName[arrayList.size()];
        for (int i = 0; i < qNameArray.length; ++i) {
            qNameArray[i] = ((ParameterDesc)arrayList.get(i)).getQName();
        }
        return qNameArray;
    }

    public QName getWSDLPort() {
        QName qName;
        QName qName2 = null;
        if (this.getPort() != null) {
            qName2 = this.getPort().getPortDesc().getWSDLPort();
        }
        if (qName2 == null && (qName = this.getPortName()) != null) {
            qName2 = QNameTable.createQName(qName.getNamespaceURI(), ClientXMLProcessor.unravelPortName(qName.getLocalPart()));
        }
        return qName2;
    }

    public String getWSDLOperation() {
        OperationDesc operationDesc = this.resolveOperation();
        return operationDesc != null ? operationDesc.getName() : null;
    }

    public QName getWSDLPortType() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            return (QName)operationDesc.getOption(OperationDesc.PORT_TYPE_QNAME);
        }
        return null;
    }

    public String getWSDLTargetNamespace() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            return (String)operationDesc.getOption(OperationDesc.TARGET_NAMESPACE);
        }
        return null;
    }

    public QName getWSDLInputMessageName() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            return (QName)operationDesc.getOption(OperationDesc.INPUT_MESSAGE_QNAME);
        }
        return null;
    }

    public QName getWSDLOutputMessageName() {
        OperationDesc operationDesc = this.resolveOperation();
        if (operationDesc != null) {
            return (QName)operationDesc.getOption(OperationDesc.OUTPUT_MESSAGE_QNAME);
        }
        return null;
    }

    public String getWSDLLocation() {
        return this.getPort() != null ? this.getPort().getPortDesc().getWSDLFile() : null;
    }

    public String getPortPath() {
        return this.getTargetPortName();
    }

    public String getServiceRefName() {
        QName qName;
        if (this.isClient() && (qName = this.getPortName()) != null) {
            return ClientXMLProcessor.unravelServiceRefName(qName.getLocalPart());
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        systemTempDirName = WebServicesProperties.getProperty("webservices.attachments.Directory");
        if (systemTempDirName == null) {
            systemTempDirName = WebServicesProperties.getProperty("java.io.tmpdir");
        }
        if (systemTempDirName != null) {
            MessageContext.createDir(systemTempDirName);
        }
        TRANS_URL = "transport.url";
        TRANS_URL_HTTP_REDIRECTED = "transport.url.http.redirected";
        QUIT_REQUESTED = "quit.requested";
        AUTHUSER = "authenticatedUser";
        ATTACHMENTS_DIR = "attachments.directory";
        WSDLGEN_INTFNAMESPACE = "webservices.wsdlgen.intfnamespace";
        WSDLGEN_SERV_LOC_URL = "webservices.wsdlgen.serv.loc.url";
        HTTP_TRANSPORT_VERSION = "webservices.transport.version";
        SAAJ_TRANSFORMATION = "webservices.not.optimal.saaj.transformation";
        FAULT_ON_SAAJ_TRANSFORMATION = "webservices.fault.on.saaj.transformation";
    }

    public static interface OneWayListener {
        public void oneWay(MessageContext var1);
    }
}

