/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WSDDEngineConfiguration;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.ConfigurableImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.session.Session;
import com.ibm.ws.webservices.engine.session.SimpleSession;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.server.ServiceLifecycle;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public abstract class WebServicesEngine
extends ConfigurableImpl {
    private static String binaryCopyright = Version.getBinaryCopyright();
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$WebServicesEngine == null ? (class$com$ibm$ws$webservices$engine$WebServicesEngine = WebServicesEngine.class$("com.ibm.ws.webservices.engine.WebServicesEngine")) : class$com$ibm$ws$webservices$engine$WebServicesEngine).getName());
    public static final String PROP_XML_DECL = "sendXMLDeclaration";
    public static final String PROP_DEBUG_LEVEL = "debugLevel";
    public static final String PROP_DEBUG_FILE = "debugFile";
    public static final String PROP_DOMULTIREFS = "sendMultiRefs";
    public static final String PROP_PASSWORD = "adminPassword";
    public static final String PROP_SYNC_CONFIG = "syncConfiguration";
    public static final String PROP_SEND_XSI = "sendXsiTypes";
    public static final String PROP_ATTACHMENT_DIR = "attachments.Directory";
    public static final String PROP_ATTACHMENT_IMPLEMENTATION = "attachments.implementation";
    public static final String PROP_ATTACHMENT_CLEANUP = "attachment.DirectoryCleanUp";
    public static final String PROP_SOAP_VERSION = "defaultSOAPVersion";
    public static final String DEFAULT_ATTACHMENT_IMPL = "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl";
    public static final String ENV_ATTACHMENT_DIR = "webservices.attachments.Directory";
    public static final String ENV_SERVLET_REALPATH = "servlet.realpath";
    public static final String ENV_SERVLET_CONTEXT = "servletContext";
    public static final String ENV_TEMP_DIR = "java.io.tmpdir";
    private final EngineConfiguration config;
    private Session session = new SimpleSession();
    private static final Set booleanOptions = new HashSet<String>(Arrays.asList("sendMultiRefs", "sendXsiTypes", "sendXMLDeclaration"));
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$WebServicesEngine;

    protected WebServicesEngine(EngineConfiguration engineConfiguration) {
        this.config = engineConfiguration;
        this.init();
    }

    private void init() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: WebServicesEngine::init");
        }
        this.config.init();
        this.setOptions(this.config.getGlobalOptions());
        this.setOptionDefault(PROP_ATTACHMENT_IMPLEMENTATION, WebServicesProperties.getProperty("webservices.attachments.implementation"));
        this.setOptionDefault(PROP_ATTACHMENT_IMPLEMENTATION, DEFAULT_ATTACHMENT_IMPL);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: WebServicesEngine::init");
        }
    }

    public void destroy() {
        Enumeration enumeration = this.session.getKeys();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = this.session.get(string);
                if (object != null && object instanceof ServiceLifecycle) {
                    ((ServiceLifecycle)object).destroy();
                }
                this.session.remove(string);
            }
        }
        this.config.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: WebServicesEngine::invoke");
        }
        MessageContext messageContext2 = MessageContext.getCurrentThreadsContext();
        try {
            try {
                MessageContext.setCurrentThreadsContext(messageContext);
                messageContext.setResponseMessage(null);
                Handler handler2 = this.getMessageFlow(messageContext);
                if (handler2.getOwner() == null) {
                    handler2.init();
                }
                try {
                    messageContext.setPastPivot(false);
                    handler2.invoke(messageContext);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (handler2.getOwner() != null) throw throwable;
                    handler2.destroy();
                    throw throwable;
                }
                if (handler2.getOwner() == null) {
                    handler2.destroy();
                }
                Object var7_9 = null;
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.WebServicesEngine.invoke", (String)"265", (Object)this);
                throw webServicesFault;
            }
            catch (ConfigurationException configurationException) {
                FFDCFilter.processException((Throwable)configurationException, (String)"com.ibm.ws.webservices.engine.WebServicesEngine.invoke", (String)"268", (Object)this);
                throw WebServicesFault.makeFault(configurationException);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            MessageContext.setCurrentThreadsContext(messageContext2);
            if (!log.isDebugEnabled()) throw throwable;
            log.debug((Object)"Exit: WebServicesEngine::invoke");
            throw throwable;
        }
        MessageContext.setCurrentThreadsContext(messageContext2);
        if (!log.isDebugEnabled()) return;
        log.debug((Object)"Exit: WebServicesEngine::invoke");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateWSDL(MessageContext messageContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: WebServicesEngine::generateWSDL");
        }
        MessageContext messageContext2 = MessageContext.getCurrentThreadsContext();
        try {
            try {
                MessageContext.setCurrentThreadsContext(messageContext);
                Handler handler2 = this.getMessageFlow(messageContext);
                if (handler2.getOwner() == null) {
                    handler2.init();
                }
                try {
                    messageContext.setPastPivot(false);
                    handler2.generateWSDL(messageContext);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (handler2.getOwner() != null) throw throwable;
                    handler2.destroy();
                    throw throwable;
                }
                if (handler2.getOwner() == null) {
                    handler2.destroy();
                }
                Object var7_9 = null;
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.WebServicesEngine.generateWSDL", (String)"315", (Object)this);
                throw webServicesFault;
            }
            catch (ConfigurationException configurationException) {
                FFDCFilter.processException((Throwable)configurationException, (String)"com.ibm.ws.webservices.engine.WebServicesEngine.generateWSDL", (String)"318", (Object)this);
                throw WebServicesFault.makeFault(configurationException);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            MessageContext.setCurrentThreadsContext(messageContext2);
            if (!log.isDebugEnabled()) throw throwable;
            log.debug((Object)"Exit: WebServicesEngine::generateWSDL");
            throw throwable;
        }
        MessageContext.setCurrentThreadsContext(messageContext2);
        if (!log.isDebugEnabled()) return;
        log.debug((Object)"Exit: WebServicesEngine::generateWSDL");
    }

    protected Handler getMessageFlow(MessageContext messageContext) throws WebServicesFault, ConfigurationException {
        Handler handler2;
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("defaultLogic00"));
        }
        if ((handler2 = this.createMessageFlow(messageContext)) == null) {
            throw new WebServicesFault("Server.error", Messages.getMessage("noHandler00", "(engine message flow)"), null, null);
        }
        return handler2;
    }

    protected abstract Handler createMessageFlow(MessageContext var1) throws WebServicesFault, ConfigurationException;

    public static MessageContext getCurrentMessageContext() {
        return MessageContext.getCurrentThreadsContext();
    }

    public SOAPPort getPort(QName qName) throws WebServicesFault {
        try {
            return this.config.getPort(qName);
        }
        catch (ConfigurationException configurationException) {
            FFDCFilter.processException((Throwable)configurationException, (String)"com.ibm.ws.webservices.engine.WebServicesEngine.getPort", (String)"378", (Object)this);
            throw new WebServicesFault(configurationException);
        }
    }

    public SOAPPort getPort(String string) throws WebServicesFault {
        return this.getPort(QNameTable.createQName(null, string));
    }

    public SOAPPort getPortByNamespaceURI(String string) throws WebServicesFault {
        try {
            return this.config.getPortByNamespaceURI(string);
        }
        catch (ConfigurationException configurationException) {
            FFDCFilter.processException((Throwable)configurationException, (String)"com.ibm.ws.webservices.engine.WebServicesEngine.getPortByNamespaceURI", (String)"393", (Object)this);
            throw new WebServicesFault(configurationException);
        }
    }

    public Iterator getDeployedPorts() throws WebServicesFault {
        try {
            return this.config.getDeployedPorts();
        }
        catch (ConfigurationException configurationException) {
            FFDCFilter.processException((Throwable)configurationException, (String)"com.ibm.ws.webservices.engine.WebServicesEngine.getDeployedPorts", (String)"403", (Object)this);
            throw new WebServicesFault(configurationException);
        }
    }

    public Handler getTransport(String string) throws WebServicesFault {
        if (string == null) {
            return null;
        }
        try {
            return this.config.getTransport(QNameTable.createQName(null, string));
        }
        catch (ConfigurationException configurationException) {
            FFDCFilter.processException((Throwable)configurationException, (String)"com.ibm.ws.webservices.engine.WebServicesEngine.getTransport", (String)"417", (Object)this);
            throw new WebServicesFault(configurationException);
        }
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        TypeMappingRegistry typeMappingRegistry = null;
        try {
            typeMappingRegistry = this.config.getTypeMappingRegistry();
        }
        catch (ConfigurationException configurationException) {
            FFDCFilter.processException((Throwable)configurationException, (String)"com.ibm.ws.webservices.engine.WebServicesEngine.getTypeMappingRegistry", (String)"428", (Object)this);
            log.error((Object)Messages.getMessage("webServicesConfigurationException00"), (Throwable)configurationException);
        }
        return typeMappingRegistry;
    }

    public SimpleTargetedChain getGlobalHandler() throws ConfigurationException {
        return this.config.getGlobalHandler();
    }

    public Document getConfigurationDocument() {
        if (this.config instanceof WSDDEngineConfiguration) {
            try {
                return ((WSDDEngineConfiguration)this.config).getDocument();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract WebServicesEngine getClientEngine();

    public Session getApplicationSession() {
        return this.session;
    }

    public boolean isContainerManaged() {
        return this.config.isContainerManaged();
    }

    public abstract boolean isServer();

    public Set getOptionsBooleanNames() {
        return booleanOptions;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

