/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.SessionUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class AttachmentPart
extends javax.xml.soap.AttachmentPart
implements Part {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$attachments$AttachmentPart == null ? (class$com$ibm$ws$webservices$engine$attachments$AttachmentPart = AttachmentPart.class$("com.ibm.ws.webservices.engine.attachments.AttachmentPart")) : class$com$ibm$ws$webservices$engine$attachments$AttachmentPart).getName());
    DataHandler datahandler = null;
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private String contentId;
    private String contentLocation;
    private Object contentObject;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$attachments$AttachmentPart;

    public AttachmentPart() {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
    }

    public AttachmentPart(DataHandler dataHandler) {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
        this.datahandler = dataHandler;
        if (dataHandler != null) {
            this.setMimeHeader("Content-Type", dataHandler.getContentType());
        }
    }

    public DataHandler getActivationDataHandler() {
        return this.datahandler;
    }

    public String getContentType() {
        return this.getFirstMimeHeader("Content-Type");
    }

    public void addMimeHeader(String string, String string2) {
        this.mimeHeaders.addHeader(string, string2);
    }

    public String getFirstMimeHeader(String string) {
        String[] stringArray = this.mimeHeaders.getHeader(string.toLowerCase());
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public boolean matches(MimeHeaders mimeHeaders) {
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            String[] stringArray = this.mimeHeaders.getHeader(mimeHeader.getName());
            boolean bl = false;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!mimeHeader.getValue().equalsIgnoreCase(stringArray[i])) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public String getContentLocation() {
        return this.getFirstMimeHeader("Content-Location");
    }

    public void setContentLocation(String string) {
        this.setMimeHeader("Content-Location", string);
    }

    public void setContentId(String string) {
        this.setMimeHeader("Content-Id", string);
    }

    public String getContentId() {
        return this.getFirstMimeHeader("Content-Id");
    }

    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getMatchingHeaders(stringArray);
    }

    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getNonMatchingHeaders(stringArray);
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public void setMimeHeader(String string, String string2) {
        this.mimeHeaders.setHeader(string, string2);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String string) {
        this.mimeHeaders.removeHeader(string);
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.datahandler == null) {
            throw new SOAPException(Messages.getMessage("noContent"));
        }
        return this.datahandler;
    }

    public void setDataHandler(DataHandler dataHandler) {
        if (dataHandler == null) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        this.datahandler = dataHandler;
        this.setMimeHeader("Content-Type", dataHandler.getContentType());
    }

    public Object getContent() throws SOAPException {
        if (this.contentObject != null) {
            return this.contentObject;
        }
        if (this.datahandler == null) {
            throw new SOAPException(Messages.getMessage("noContent"));
        }
        DataSource dataSource = this.datahandler.getDataSource();
        if (dataSource instanceof ManagedMemoryDataSource) {
            ManagedMemoryDataSource managedMemoryDataSource = (ManagedMemoryDataSource)dataSource;
            if (dataSource.getContentType().equals("text/plain")) {
                try {
                    InputStream inputStream = dataSource.getInputStream();
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    return new String(byArray);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.attachments.AttachmentPart.getContent", (String)"377", (Object)this);
                    log.error((Object)Messages.getMessage("javaIOException00"), (Throwable)iOException);
                }
            }
        }
        return null;
    }

    public void setContent(Object object, String string) {
        if (object instanceof String) {
            try {
                String string2 = (String)object;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
                this.datahandler = new DataHandler((DataSource)new ManagedMemoryDataSource(byteArrayInputStream, 1024, string, true));
                this.contentObject = object;
                return;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.attachments.AttachmentPart.setContent", (String)"414", (Object)this);
                log.error((Object)Messages.getMessage("javaIOException00"), (Throwable)iOException);
                throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
            }
        }
        if (object instanceof InputStream) {
            try {
                this.datahandler = new DataHandler((DataSource)new ManagedMemoryDataSource((InputStream)object, 1024, string, true));
                this.contentObject = object;
                return;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.attachments.AttachmentPart.setContent", (String)"426", (Object)this);
                log.error((Object)Messages.getMessage("javaIOException00"), (Throwable)iOException);
                throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
            }
        }
        throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
    }

    public void clearContent() {
        this.datahandler = null;
        this.contentObject = null;
    }

    public int getSize() throws SOAPException {
        if (this.datahandler == null) {
            return 0;
        }
        ByteBuffer byteBuffer = new ByteBuffer();
        try {
            this.datahandler.writeTo((OutputStream)byteBuffer);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.attachments.AttachmentPart.getSize", (String)"463", (Object)this);
            log.error((Object)Messages.getMessage("javaIOException00"), (Throwable)iOException);
            throw new SOAPException(Messages.getMessage("javaIOException01", iOException.getMessage()), iOException);
        }
        byte[] byArray = byteBuffer.getBytes();
        if (byArray != null) {
            return byArray.length;
        }
        return -1;
    }

    public String[] getMimeHeader(String string) {
        return this.mimeHeaders.getHeader(string);
    }

    public String getContentIdRef() {
        return "cid:" + this.getContentId();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ByteBuffer
    extends ByteArrayOutputStream {
        private ByteBuffer() {
        }

        byte[] getBytes() {
            return this.buf;
        }
    }
}

