/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.SOAPPart;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.attachments.AttachmentUtils;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.attachments.DimeBodyPart;
import com.ibm.ws.webservices.engine.attachments.DimeMultiPart;
import com.ibm.ws.webservices.engine.attachments.DimeTypeNameFormat;
import com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource;
import com.ibm.ws.webservices.engine.attachments.MimeUtils;
import com.ibm.ws.webservices.engine.attachments.MultiPartDimeInputStream;
import com.ibm.ws.webservices.engine.attachments.MultiPartInputStream;
import com.ibm.ws.webservices.engine.attachments.MultiPartRelatedInputStream;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.Messages;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import javax.xml.soap.MimeHeaders;
import org.apache.commons.logging.Log;

public class AttachmentsImpl
implements Attachments {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$attachments$AttachmentsImpl == null ? (class$com$ibm$ws$webservices$engine$attachments$AttachmentsImpl = AttachmentsImpl.class$("com.ibm.ws.webservices.engine.attachments.AttachmentsImpl")) : class$com$ibm$ws$webservices$engine$attachments$AttachmentsImpl).getName());
    private HashMap attachments = new HashMap();
    private LinkedList orderedAttachments = new LinkedList();
    protected SOAPPart soapPart = null;
    protected MultiPartInputStream mpartStream = null;
    protected int sendtype = 1;
    protected String contentLocation = null;
    MimeMultipart multipart = null;
    DimeMultiPart dimemultipart = null;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$attachments$AttachmentsImpl;
    static /* synthetic */ Class class$javax$activation$DataHandler;

    public AttachmentsImpl(Object object, String string, String string2) throws WebServicesFault {
        StringTokenizer stringTokenizer;
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        this.contentLocation = string2;
        if (string != null && !string.equals("  ") && (stringTokenizer = new StringTokenizer(string, " \t;")).hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equalsIgnoreCase("multipart/related")) {
                this.sendtype = 2;
                this.mpartStream = new MultiPartRelatedInputStream(string, (InputStream)object);
                if (null == string2 && (string2 = this.mpartStream.getContentLocation()) != null && (string2 = string2.trim()).length() == 0) {
                    string2 = null;
                }
                this.soapPart = new SOAPPart(this.mpartStream, false);
            } else if (string3.equalsIgnoreCase("application/dime")) {
                try {
                    this.mpartStream = new MultiPartDimeInputStream((InputStream)object);
                    this.soapPart = new SOAPPart(this.mpartStream, false);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.attachments.AttachmentsImpl.AttachmentsImpl", (String)"176", (Object)this);
                    throw WebServicesFault.makeFault(exception);
                }
                this.sendtype = 3;
            }
        }
    }

    private void mergeinAttachments() throws WebServicesFault {
        if (this.mpartStream != null) {
            Collection collection = this.mpartStream.getAttachments();
            if (this.contentLocation == null) {
                this.contentLocation = this.mpartStream.getContentLocation();
            }
            this.mpartStream = null;
            this.setAttachmentParts(collection);
        }
    }

    public Part removeAttachmentPart(String string) throws WebServicesFault {
        this.multipart = null;
        this.dimemultipart = null;
        this.mergeinAttachments();
        Part part = this.getAttachmentByReference(string);
        if (part != null) {
            this.attachments.remove(part.getContentId());
            this.attachments.remove(part.getContentLocation());
            this.orderedAttachments.remove(part);
        }
        return part;
    }

    public Part addAttachmentPart(Part part) throws WebServicesFault {
        this.multipart = null;
        this.dimemultipart = null;
        this.mergeinAttachments();
        Part part2 = this.attachments.put(part.getContentId(), part);
        if (part2 != null) {
            this.orderedAttachments.remove(part2);
            this.attachments.remove(part2.getContentLocation());
        }
        this.orderedAttachments.add(part);
        if (part.getContentLocation() != null) {
            this.attachments.put(part.getContentLocation(), part);
        }
        return part2;
    }

    public Part createAttachmentPart(Object object) throws WebServicesFault {
        this.multipart = null;
        this.dimemultipart = null;
        this.mergeinAttachments();
        if (!(object instanceof DataHandler)) {
            throw new WebServicesFault(Messages.getMessage("unsupportedAttach", object.getClass().getName(), (class$javax$activation$DataHandler == null ? (class$javax$activation$DataHandler = AttachmentsImpl.class$("javax.activation.DataHandler")) : class$javax$activation$DataHandler).getName()));
        }
        AttachmentPart attachmentPart = new AttachmentPart((DataHandler)object);
        this.addAttachmentPart(attachmentPart);
        return attachmentPart;
    }

    public void setAttachmentParts(Collection collection) throws WebServicesFault {
        this.removeAllAttachments();
        if (collection != null && !collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Part part = (Part)iterator.next();
                if (null == part) continue;
                this.addAttachmentPart(part);
            }
        }
    }

    public Part getAttachmentByReference(String string) throws WebServicesFault {
        if (null == string) {
            return null;
        }
        if (0 == (string = string.trim()).length()) {
            return null;
        }
        this.mergeinAttachments();
        Part part = (Part)this.attachments.get(string);
        if (null != part) {
            return part;
        }
        if (!string.startsWith("cid:") && null != this.contentLocation) {
            String string2 = this.contentLocation;
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            string2 = string.startsWith("/") ? string2 + string.substring(1) : string2 + string;
            part = (AttachmentPart)this.attachments.get(string2);
        }
        if (null == part && string.startsWith("cid:")) {
            part = (Part)this.attachments.get(string.substring(4));
        }
        return part;
    }

    public Collection getAttachments() throws WebServicesFault {
        this.mergeinAttachments();
        return new LinkedList(this.orderedAttachments);
    }

    public Part getRootPart() {
        return this.soapPart;
    }

    public void setRootPart(Part part) {
        try {
            this.soapPart = (SOAPPart)part;
            this.multipart = null;
            this.dimemultipart = null;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.webservices.engine.attachments.AttachmentsImpl.setRootPart", (String)"423", (Object)this);
            throw new ClassCastException(Messages.getMessage("onlySOAPParts"));
        }
    }

    public long getContentLength() throws WebServicesFault {
        this.mergeinAttachments();
        int n = this.sendtype == 1 ? 2 : this.sendtype;
        try {
            if (n == 2) {
                return MimeUtils.getContentLength((Multipart)(this.multipart != null ? this.multipart : (this.multipart = MimeUtils.createMP(this.soapPart.getAsString(), this.orderedAttachments))));
            }
            if (n == 3) {
                return this.createDimeMessage().getTransmissionSize();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.attachments.AttachmentsImpl.getContentLength", (String)"451", (Object)this);
            throw WebServicesFault.makeFault(exception);
        }
        return 0L;
    }

    protected DimeMultiPart createDimeMessage() throws WebServicesFault {
        int n;
        int n2 = n = this.sendtype == 1 ? 2 : this.sendtype;
        if (n == 3 && this.dimemultipart == null) {
            this.dimemultipart = new DimeMultiPart();
            this.dimemultipart.addBodyPart(new DimeBodyPart(this.soapPart.getAsBytes(), DimeTypeNameFormat.URI, "http://schemas.xmlsoap.org/soap/envelope/", "uuid:714C6C40-4531-442E-A498-3AC614200295"));
            Iterator iterator = this.orderedAttachments.iterator();
            while (iterator.hasNext()) {
                AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
                DataHandler dataHandler = AttachmentUtils.getActivationDataHandler(attachmentPart);
                this.dimemultipart.addBodyPart(new DimeBodyPart(dataHandler, attachmentPart.getContentId()));
            }
        }
        return this.dimemultipart;
    }

    public void writeContentToStream(OutputStream outputStream) throws WebServicesFault {
        int n = this.sendtype == 1 ? 2 : this.sendtype;
        try {
            this.mergeinAttachments();
            if (n == 2) {
                MimeUtils.writeToMultiPartStream(outputStream, this.multipart != null ? this.multipart : (this.multipart = MimeUtils.createMP(this.soapPart.getAsString(), this.orderedAttachments)));
                Iterator iterator = this.orderedAttachments.iterator();
                while (iterator.hasNext()) {
                    AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
                    DataHandler dataHandler = AttachmentUtils.getActivationDataHandler(attachmentPart);
                    DataSource dataSource = dataHandler.getDataSource();
                    if (dataSource == null || !(dataSource instanceof ManagedMemoryDataSource)) continue;
                    ((ManagedMemoryDataSource)dataSource).delete();
                }
            } else if (n == 3) {
                this.createDimeMessage().write(outputStream);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.attachments.AttachmentsImpl.writeContentToStream", (String)"523", (Object)this);
            throw WebServicesFault.makeFault(exception);
        }
    }

    public String getContentType() throws WebServicesFault {
        int n;
        this.mergeinAttachments();
        int n2 = n = this.sendtype == 1 ? 2 : this.sendtype;
        if (n == 2) {
            return MimeUtils.getContentType(this.multipart != null ? this.multipart : (this.multipart = MimeUtils.createMP(this.soapPart.getAsString(), this.orderedAttachments)));
        }
        return "application/dime";
    }

    public int getAttachmentCount() {
        try {
            this.mergeinAttachments();
            return this.orderedAttachments.size();
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.attachments.AttachmentsImpl.getAttachmentCount", (String)"563", (Object)this);
            return 0;
        }
    }

    public boolean isAttachment(Object object) {
        return AttachmentUtils.isAttachment(object);
    }

    public void removeAllAttachments() {
        try {
            this.multipart = null;
            this.dimemultipart = null;
            this.mergeinAttachments();
            this.attachments.clear();
            this.orderedAttachments.clear();
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.attachments.AttachmentsImpl.removeAllAttachments", (String)"595", (Object)this);
            log.warn((Object)Messages.getMessage("exception00"), (Throwable)webServicesFault);
        }
    }

    public Iterator getAttachments(MimeHeaders mimeHeaders) {
        Vector<Part> vector = new Vector<Part>();
        Iterator iterator = this.attachments.values().iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            if (!(part instanceof AttachmentPart) || !((AttachmentPart)part).matches(mimeHeaders)) continue;
            vector.add(part);
        }
        return vector.iterator();
    }

    public Part createAttachmentPart() throws WebServicesFault {
        return new AttachmentPart();
    }

    public void setSendType(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("");
        }
        if (n > 4) {
            throw new IllegalArgumentException("");
        }
        this.sendtype = n;
    }

    public int getSendType() {
        return this.sendtype;
    }

    public static int getSendType(String string) {
        if (string.equalsIgnoreCase("MIME")) {
            return 2;
        }
        if (string.equalsIgnoreCase("DIME")) {
            return 3;
        }
        if (string.equalsIgnoreCase("NONE")) {
            return 4;
        }
        return 1;
    }

    public static String getSendTypeString(int n) {
        if (n == 2) {
            return "MIME";
        }
        if (n == 3) {
            return "DIME";
        }
        if (n == 4) {
            return "NONE";
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

