/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.attachments.DimeBodyPart;
import com.ibm.ws.webservices.engine.attachments.DimeTypeNameFormat;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.Messages;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;

public class DimeDelimitedInputStream
extends FilterInputStream {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$attachments$DimeDelimitedInputStream == null ? (class$com$ibm$ws$webservices$engine$attachments$DimeDelimitedInputStream = DimeDelimitedInputStream.class$("com.ibm.ws.webservices.engine.attachments.DimeDelimitedInputStream")) : class$com$ibm$ws$webservices$engine$attachments$DimeDelimitedInputStream).getName());
    InputStream is = null;
    volatile boolean closed = true;
    boolean theEnd = false;
    boolean moreChunks = false;
    boolean MB = false;
    boolean ME = false;
    DimeTypeNameFormat tnf = null;
    String type = null;
    String id = null;
    long recordLength = 0L;
    long bytesRead = 0L;
    int dataPadLength = 0;
    private static byte[] trash = new byte[4];
    protected int streamNo = 0;
    protected IOException streamInError = null;
    protected static int streamCount = 0;
    static boolean isDebugEnabled = false;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$attachments$DimeDelimitedInputStream;

    protected static synchronized int newStreamNo() {
        log.debug((Object)Messages.getMessage("streamNo", "" + (streamCount + 1)));
        return ++streamCount;
    }

    synchronized DimeDelimitedInputStream getNextStream() throws IOException {
        if (null != this.streamInError) {
            throw this.streamInError;
        }
        if (this.theEnd) {
            return null;
        }
        if (this.bytesRead < this.recordLength || this.moreChunks) {
            throw new RuntimeException(Messages.getMessage("attach.dimeReadFullyError"));
        }
        this.dataPadLength -= this.readPad(this.dataPadLength);
        return new DimeDelimitedInputStream(this.is);
    }

    DimeDelimitedInputStream(InputStream inputStream) throws IOException {
        super(null);
        isDebugEnabled = log.isDebugEnabled();
        this.streamNo = DimeDelimitedInputStream.newStreamNo();
        this.closed = false;
        this.is = inputStream;
        this.readHeader(false);
    }

    private final int readPad(int n) throws IOException {
        if (0 == n) {
            return 0;
        }
        int n2 = this.readFromStream(trash, 0, n);
        if (n != n2) {
            this.streamInError = new IOException(Messages.getMessage("attach.dimeNotPaddedCorrectly"));
            throw this.streamInError;
        }
        return n2;
    }

    private final int readFromStream(byte[] byArray) throws IOException {
        return this.readFromStream(byArray, 0, byArray.length);
    }

    private final int readFromStream(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        do {
            try {
                n3 = this.is.read(byArray, n4 + n, n2 - n4);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.attachments.DimeDelimitedInputStream.readFromStream", (String)"188", (Object)this);
                this.streamInError = iOException;
                throw iOException;
            }
            if (n3 <= 0) continue;
            n4 += n3;
        } while (n3 > -1 && n4 < n2);
        return n3 > -1 ? n4 : n3;
    }

    public String getContentId() {
        return this.id;
    }

    public DimeTypeNameFormat getDimeTypeNameFormat() {
        return this.tnf;
    }

    public String getType() {
        return this.type;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            this.dataPadLength -= this.readPad(this.dataPadLength);
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        return this._read(byArray, n, n2);
    }

    protected int _read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException(Messages.getMessage("attach.readLengthError", "" + n2));
        }
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getMessage("attach.readOffsetError", "" + n));
        }
        if (byArray == null) {
            throw new IllegalArgumentException(Messages.getMessage("attach.readArrayNullError"));
        }
        if (byArray.length < n + n2) {
            throw new IllegalArgumentException(Messages.getMessage("attach.readArraySizeError", "" + byArray.length, "" + n2, "" + n));
        }
        if (null != this.streamInError) {
            throw this.streamInError;
        }
        if (0 == n2) {
            return 0;
        }
        if (this.recordLength == 0L && this.bytesRead == 0L && !this.moreChunks) {
            ++this.bytesRead;
            if (this.ME) {
                this.finalClose();
            }
            return 0;
        }
        if (this.bytesRead >= this.recordLength && !this.moreChunks) {
            this.dataPadLength -= this.readPad(this.dataPadLength);
            if (this.ME) {
                this.finalClose();
            }
            return -1;
        }
        int n3 = 0;
        int n4 = 0;
        do {
            if (this.bytesRead >= this.recordLength && this.moreChunks) {
                this.readHeader(true);
            }
            n4 = (int)Math.min(this.recordLength - this.bytesRead, (long)n2 - (long)n3);
            n4 = (int)Math.min(this.recordLength - this.bytesRead, (long)n2 - (long)n3);
            try {
                n4 = this.is.read(byArray, n + n3, n4);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.attachments.DimeDelimitedInputStream._read", (String)"293", (Object)this);
                this.streamInError = iOException;
                throw iOException;
            }
            if (0 >= n4) continue;
            n3 += n4;
            this.bytesRead += (long)n4;
        } while (n4 > -1 && n3 < n2 && (this.bytesRead < this.recordLength || this.moreChunks));
        if (0 > n4) {
            if (this.moreChunks) {
                this.streamInError = new IOException(Messages.getMessage("attach.DimeStreamError0"));
                throw this.streamInError;
            }
            if (this.bytesRead < this.recordLength) {
                this.streamInError = new IOException(Messages.getMessage("attach.DimeStreamError1", "" + (this.recordLength - this.bytesRead)));
                throw this.streamInError;
            }
            if (!this.ME) {
                this.streamInError = new IOException(Messages.getMessage("attach.DimeStreamError0"));
                throw this.streamInError;
            }
            this.dataPadLength = 0;
        } else if (this.bytesRead >= this.recordLength) {
            try {
                this.dataPadLength -= this.readPad(this.dataPadLength);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.attachments.DimeDelimitedInputStream._read", (String)"333", (Object)this);
                if (!this.ME) {
                    throw iOException;
                }
                this.dataPadLength = 0;
                this.streamInError = null;
            }
        }
        if (this.bytesRead >= this.recordLength && this.ME) {
            this.finalClose();
        }
        return n3 >= 0 ? n3 : -1;
    }

    void readHeader(boolean bl) throws IOException {
        int n;
        byte[] byArray;
        byte[] byArray2;
        this.bytesRead = 0L;
        if (bl) {
            if (!this.moreChunks) {
                throw new RuntimeException(Messages.getMessage("attach.DimeStreamError2"));
            }
            this.dataPadLength -= this.readPad(this.dataPadLength);
        }
        if ((byArray2 = new byte[12]).length != this.readFromStream(byArray2)) {
            this.streamInError = new IOException(Messages.getMessage("attach.DimeStreamError3", "" + byArray2.length));
            throw this.streamInError;
        }
        byte by = (byte)(byArray2[0] >>> 3 & 0x1F);
        if (by > 1) {
            this.streamInError = new IOException(Messages.getMessage("attach.DimeStreamError4", "" + by, "1"));
            throw this.streamInError;
        }
        this.MB = 0 != (4 & byArray2[0]);
        this.ME = 0 != (2 & byArray2[0]);
        boolean bl2 = this.moreChunks = 0 != (1 & byArray2[0]);
        if (!bl) {
            this.tnf = DimeTypeNameFormat.parseByte((byte)(byArray2[1] >>> 4 & 0xF));
        }
        int n2 = byArray2[2] << 8 & 0xFF00 | byArray2[3];
        int n3 = byArray2[4] << 8 & 0xFF00 | byArray2[5];
        int n4 = byArray2[6] << 8 & 0xFF00 | byArray2[7];
        this.recordLength = (long)byArray2[8] << 24 & 0xFF000000L | (long)byArray2[9] << 16 & 0xFF0000L | (long)byArray2[10] << 8 & 0xFF00L | (long)byArray2[11] & 0xFFL;
        if (0 != n2) {
            byArray = new byte[n2];
            if (n2 != this.readFromStream(byArray)) {
                this.streamInError = new IOException(Messages.getMessage("attach.DimeStreamError5", "" + n2));
                throw this.streamInError;
            }
            byArray = null;
            n = DimeBodyPart.dimePadding(n2);
            if (n != this.readFromStream(byArray2, 0, n)) {
                this.streamInError = new IOException(Messages.getMessage("attach.DimeStreamError7"));
                throw this.streamInError;
            }
        }
        if (0 < n3) {
            byArray = new byte[n3];
            if (n3 != this.readFromStream(byArray)) {
                this.streamInError = new IOException(Messages.getMessage("attach.DimeStreamError8"));
                throw this.streamInError;
            }
            if (n3 != 0 && !bl) {
                this.id = new String(byArray);
            }
            if ((n = DimeBodyPart.dimePadding(n3)) != this.readFromStream(byArray2, 0, n)) {
                this.streamInError = new IOException(Messages.getMessage("attach.DimeStreamError9"));
                throw this.streamInError;
            }
        }
        if (0 < n4) {
            byArray = new byte[n4];
            if (n4 != this.readFromStream(byArray)) {
                this.streamInError = new IOException(Messages.getMessage("attach.DimeStreamError10"));
                throw this.streamInError;
            }
            if (n4 != 0 && !bl) {
                this.type = new String(byArray);
            }
            if ((n = DimeBodyPart.dimePadding(n4)) != this.readFromStream(byArray2, 0, n)) {
                this.streamInError = new IOException(Messages.getMessage("attach.DimeStreamError11"));
                throw this.streamInError;
            }
        }
        log.debug((Object)("MB:" + this.MB + ", ME:" + this.ME + ", CF:" + this.moreChunks + "Option length:" + n2 + ", ID length:" + n3 + ", typeLength:" + n4 + ", TYPE_T:" + this.tnf));
        log.debug((Object)("id:\"" + this.id + "\""));
        log.debug((Object)("type:\"" + this.type + "\""));
        log.debug((Object)("recordlength:\"" + this.recordLength + "\""));
        this.dataPadLength = DimeBodyPart.dimePadding(this.recordLength);
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n < 0) {
            return -1;
        }
        return byArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        log.debug((Object)Messages.getMessage("bStreamClosed", "" + this.streamNo));
        if (this.bytesRead < this.recordLength || this.moreChunks) {
            object = new byte[16384];
            int n = 0;
            while ((n = this._read((byte[])object, 0, ((Object)object).length)) > -1) {
            }
        }
        this.dataPadLength -= this.readPad(this.dataPadLength);
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        this.streamInError = new IOException(Messages.getMessage("attach.bounday.mns"));
        throw this.streamInError;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized int available() throws IOException {
        if (null != this.streamInError) {
            throw this.streamInError;
        }
        int n = (int)Math.min(Integer.MAX_VALUE, this.recordLength - this.bytesRead);
        int n2 = 0;
        try {
            n2 = this.is.available();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.attachments.DimeDelimitedInputStream.available", (String)"560", (Object)this);
            this.streamInError = iOException;
            throw iOException;
        }
        if (n == 0 && this.moreChunks && 12 + this.dataPadLength <= n2) {
            this.dataPadLength -= this.readPad(this.dataPadLength);
            this.readHeader(true);
            return this.available();
        }
        return Math.min(n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalClose() throws IOException {
        try {
            this.theEnd = true;
            if (null != this.is) {
                this.is.close();
            }
        }
        finally {
            this.is = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

