/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.configuration.DefaultEngineConfigurationFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.configuration.SimpleEngineConfigurationProvider;
import java.net.URL;
import java.util.HashMap;
import javax.naming.Reference;
import javax.xml.namespace.QName;

public class ClientEngineFactory {
    private static HashMap managedEngines = new HashMap(6);
    private static HashMap unmanagedEngines = new HashMap(6);
    private static ClientEngine anonymousManagedEngine;
    private static ClientEngine anonymousUnmanagedEngine;
    private static int CACHE_THRESHOLD;

    private static synchronized void checkCache() {
        if (managedEngines.size() > CACHE_THRESHOLD) {
            managedEngines.clear();
        }
        if (unmanagedEngines.size() > CACHE_THRESHOLD) {
            unmanagedEngines.clear();
        }
    }

    public static synchronized ClientEngine getEngine(Reference reference) {
        ClientEngine clientEngine = (ClientEngine)managedEngines.get(reference);
        if (clientEngine == null) {
            clientEngine = new ClientEngine();
            managedEngines.put(reference, clientEngine);
        } else {
            ClientEngineFactory.checkCache();
        }
        return clientEngine;
    }

    public static synchronized ClientEngine getEngine(boolean bl) {
        ClientEngine clientEngine;
        ClientEngine clientEngine2 = clientEngine = bl ? anonymousManagedEngine : anonymousUnmanagedEngine;
        if (clientEngine == null) {
            if (bl) {
                EngineConfiguration engineConfiguration = EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig();
                if (engineConfiguration.isContainerManaged()) {
                    anonymousManagedEngine = clientEngine = new ClientEngine(engineConfiguration);
                }
            } else {
                anonymousUnmanagedEngine = clientEngine = ClientEngineFactory.createUnmanagedClientEngine();
            }
        }
        return clientEngine;
    }

    public static synchronized ClientEngine getEngine(QName qName, boolean bl) {
        if (qName == null) {
            return ClientEngineFactory.getEngine(bl);
        }
        String string = qName.toString();
        ClientEngine clientEngine = (ClientEngine)(bl ? managedEngines.get(string) : unmanagedEngines.get(string));
        if (clientEngine == null) {
            clientEngine = new ClientEngine();
            if (bl) {
                managedEngines.put(string, clientEngine);
            } else {
                unmanagedEngines.put(string, clientEngine);
            }
        } else {
            ClientEngineFactory.checkCache();
        }
        return clientEngine;
    }

    public static synchronized ClientEngine getEngine(URL uRL, QName qName, boolean bl) {
        if (uRL == null && qName == null) {
            return ClientEngineFactory.getEngine(bl);
        }
        String string = uRL == null ? qName.toString() : (qName == null ? uRL.toExternalForm() : uRL.toExternalForm() + ":" + qName.toString());
        ClientEngine clientEngine = (ClientEngine)(bl ? managedEngines.get(string) : unmanagedEngines.get(string));
        if (clientEngine == null) {
            clientEngine = new ClientEngine();
            if (bl) {
                managedEngines.put(string, clientEngine);
            } else {
                unmanagedEngines.put(string, clientEngine);
            }
        } else {
            ClientEngineFactory.checkCache();
        }
        return clientEngine;
    }

    public static synchronized ClientEngine getEngine(EngineConfiguration engineConfiguration) {
        boolean bl = engineConfiguration.isContainerManaged();
        ClientEngine clientEngine = (ClientEngine)(bl ? managedEngines.get(engineConfiguration) : unmanagedEngines.get(engineConfiguration));
        if (clientEngine == null) {
            clientEngine = new ClientEngine(engineConfiguration);
            if (bl) {
                managedEngines.put(engineConfiguration, clientEngine);
            } else {
                unmanagedEngines.put(engineConfiguration, clientEngine);
            }
        } else {
            ClientEngineFactory.checkCache();
        }
        return clientEngine;
    }

    private static ClientEngine createUnmanagedClientEngine() {
        EngineConfiguration engineConfiguration = DefaultEngineConfigurationFactory.newFactory(null).getClientEngineConfig();
        SimpleEngineConfigurationProvider simpleEngineConfigurationProvider = new SimpleEngineConfigurationProvider(engineConfiguration);
        return ClientEngineFactory.getEngine(simpleEngineConfigurationProvider);
    }

    static {
        CACHE_THRESHOLD = 5;
    }
}

