/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.client.Transport;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.enum.MessageType;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import java.io.BufferedWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class Connection {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$client$Connection == null ? (class$com$ibm$ws$webservices$engine$client$Connection = Connection.class$("com.ibm.ws.webservices.engine.client.Connection")) : class$com$ibm$ws$webservices$engine$client$Connection).getName());
    protected static Log entLog = LogFactory.getLog("com.ibm.ws.webservices.engine.enterprise");
    private Service service = null;
    private Transport transport = null;
    private URL url = null;
    public static final boolean FAULT_ON_NO_RESPONSE = false;
    private static Hashtable transports = new Hashtable();
    private Vector myHeaderParams = null;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$client$Connection;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$transport$java$JavaTransport;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$transport$local$LocalTransport;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$transport$http$HTTPTransport;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$transport$jms$JMSTransport;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$client$Transport;

    public static void initProtocols() {
    }

    Connection(Service service, URL uRL) {
        this.service = service;
        this.transport = this.getTransportForURL(uRL);
        this.url = uRL;
    }

    Connection(Service service, Transport transport2, URL uRL) {
        this.service = service;
        this.transport = transport2;
        this.url = uRL;
    }

    private Transport getTransportForURL(URL uRL) {
        Transport transport2 = null;
        if (uRL != null) {
            String string = uRL.getProtocol();
            transport2 = this.getTransportForProtocol(string);
            if (transport2 == null) {
                String string2 = Messages.getMessage("noTransport01", string);
                JAXRPCException jAXRPCException = new JAXRPCException(string2);
                log.error((Object)string2);
                throw jAXRPCException;
            }
            transport2.setUrl(uRL.toString());
        }
        return transport2;
    }

    private Transport getTransportForProtocol(String string) {
        Class clazz = (Class)transports.get(string);
        Transport transport2 = null;
        if (clazz != null) {
            try {
                transport2 = (Transport)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return transport2;
    }

    public static void setTransportForProtocol(String string, Class clazz) {
        if (!(class$com$ibm$ws$webservices$engine$client$Transport == null ? (class$com$ibm$ws$webservices$engine$client$Transport = Connection.class$("com.ibm.ws.webservices.engine.client.Transport")) : class$com$ibm$ws$webservices$engine$client$Transport).isAssignableFrom(clazz)) {
            throw new InternalException(clazz.toString());
        }
        transports.put(string, clazz);
    }

    private Object[] getParamList(OperationDesc operationDesc, Object[] objectArray, Vector vector) {
        int n = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("operation=" + operationDesc));
            if (operationDesc != null) {
                log.debug((Object)("operation.getNumParams()=" + operationDesc.getNumParams()));
            }
        }
        if (operationDesc.getNumParams() == 0) {
            return objectArray;
        }
        n = operationDesc.getNumInParams();
        if (objectArray == null || n != objectArray.length) {
            throw new JAXRPCException(Messages.getMessage("parmMismatch00", "" + objectArray.length, "" + n));
        }
        log.debug((Object)("getParamList number of params: " + objectArray.length));
        Vector<ParamValue> vector2 = new Vector<ParamValue>();
        int n2 = 0;
        ArrayList arrayList = operationDesc.getParameters();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            ParameterDesc parameterDesc = (ParameterDesc)arrayList.get(i);
            if (parameterDesc.getMode() == 2) continue;
            QName qName = parameterDesc.getQName();
            ParamValue paramValue = null;
            paramValue = (object = objectArray[n2++]) instanceof ParamValue ? (ParamValue)object : new ParamValue(qName.getNamespaceURI(), qName.getLocalPart(), object);
            paramValue.setParamDesc(parameterDesc);
            if (parameterDesc.isInHeader()) {
                this.addHeaderParam(paramValue);
                continue;
            }
            vector2.add(paramValue);
        }
        return vector2.toArray();
    }

    public Vector invoke(MessageContext messageContext, Object[] objectArray, Vector vector, Vector vector2) throws WebServicesFault {
        OperationDesc operationDesc;
        if (vector == null) {
            vector = new Vector();
        }
        if ((operationDesc = messageContext.getOperation()) == null) {
            throw new WebServicesFault(Messages.getMessage("mustSpecifyOperation"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: Connection::invoke(msgCtx, args)");
        }
        QName qName = operationDesc.getElementQName();
        SOAPFactory sOAPFactory = new SOAPFactory(messageContext.getSOAPConstants());
        SOAPEnvelope sOAPEnvelope = null;
        SOAPBody sOAPBody = null;
        try {
            sOAPEnvelope = sOAPFactory.createSOAPEnvelope(true);
            sOAPBody = (SOAPBody)sOAPEnvelope.getBody();
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"408", (Object)this);
            throw WebServicesFault.makeFault(sOAPException);
        }
        RequestResponse requestResponse = null;
        try {
            requestResponse = new RequestResponse(qName.getNamespaceURI(), qName.getLocalPart(), sOAPBody, false);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"418", (Object)this);
            throw WebServicesFault.makeFault(sOAPException);
        }
        requestResponse.addParams(this.getParamList(operationDesc, objectArray, vector));
        SOAPEnvelope sOAPEnvelope2 = null;
        Message message = new Message(sOAPEnvelope);
        Message message2 = null;
        Vector vector3 = null;
        try {
            sOAPBody.setEncodingStyle(messageContext.getEncodingStyle());
            messageContext.setRequestMessage(message);
            sOAPEnvelope.getSOAPFactory().setMessageType(MessageType.REQUEST);
            this.invoke(messageContext, vector, vector2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"438", (Object)this);
            entLog.info((Object)Messages.getMessage("toWebServicesFault00"), (Throwable)exception);
            throw WebServicesFault.makeFault(exception);
        }
        message2 = messageContext.getResponseMessage();
        if (!this.isRPCOneway(messageContext)) {
            if (message2 == null) {
                return null;
            }
            sOAPEnvelope2 = message2.getSOAPEnvelope();
            RequestResponse requestResponse2 = null;
            try {
                requestResponse2 = ((SOAPBody)sOAPEnvelope2.getBody()).getRequestResponse();
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"460", (Object)this);
                throw WebServicesFault.makeFault(sOAPException);
            }
            if (requestResponse2 != null) {
                try {
                    vector3 = requestResponse2.getParams();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"468", (Object)this);
                    log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                    throw WebServicesFault.makeFault(exception);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: Connection::invoke(msgCtx, args)");
            }
        }
        return vector3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext messageContext, Vector vector, Vector vector2) throws WebServicesFault {
        Object object;
        Object object2;
        Serializable serializable;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: Connection::invoke(MessageContext)");
        }
        if (messageContext.getTargetEndpointAddress() == null && this.url != null) {
            messageContext.setTargetEndpointAddress(this.url);
        }
        Message message = null;
        SOAPEnvelope sOAPEnvelope = null;
        QName qName = messageContext.getPortName();
        if (qName != null) {
            messageContext.setTargetPort(qName.getLocalPart());
        } else {
            message = messageContext.getRequestMessage();
            if (message != null) {
                try {
                    sOAPEnvelope = message.getSOAPEnvelope();
                    if (((SOAPBody)sOAPEnvelope.getBody()).getRequestResponse() != null) {
                        serializable = ((SOAPBody)sOAPEnvelope.getBody()).getRequestResponse().getQName();
                    } else {
                        object2 = (SOAPBodyElement)((SOAPBody)sOAPEnvelope.getBody()).getChildElement(0);
                        serializable = QNameTable.createQName(((SOAPElement)object2).getNamespaceURI(), ((SOAPElement)object2).getLocalPart());
                    }
                    if (((QName)serializable).getNamespaceURI() == null) {
                        throw new WebServicesFault("Connection.invoke", Messages.getMessage("cantInvoke00", ((QName)serializable).getLocalPart()), null, null);
                    }
                    messageContext.setTargetPort(((QName)serializable).getNamespaceURI());
                }
                catch (SOAPException sOAPException) {
                    FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"541", (Object)this);
                    throw WebServicesFault.makeFault(sOAPException);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("targetService", messageContext.getTargetPortName()));
        }
        serializable = messageContext.getRequestMessage();
        this.addAttachments((Message)serializable, vector2);
        if (serializable != null) {
            sOAPEnvelope = ((Message)serializable).getSOAPEnvelope();
            sOAPEnvelope.getSOAPFactory().setMessageContext(messageContext);
            try {
                int n;
                for (n = 0; vector != null && n < vector.size(); ++n) {
                    sOAPEnvelope.getHeader().addChildElement((SOAPHeaderElement)vector.get(n));
                }
                for (n = 0; this.myHeaderParams != null && n < this.myHeaderParams.size(); ++n) {
                    object = sOAPEnvelope.getSOAPFactory().createSOAPHeaderElement("", "");
                    ((SOAPElement)object).setAlternateContent((ParamValue)this.myHeaderParams.get(n));
                    sOAPEnvelope.getHeader().addChildElement((javax.xml.soap.SOAPElement)object);
                }
                this.myHeaderParams = null;
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.client.Connection.invoke", (String)"575", (Object)this);
                throw WebServicesFault.makeFault(sOAPException);
            }
        }
        if (this.transport != null) {
            this.transport.setupMessageContext(messageContext, this.service.getEngine());
        }
        if (log.isDebugEnabled()) {
            object2 = new StringWriter();
            object = new BufferedWriter((Writer)object2);
            try {
                SerializationContextImpl serializationContextImpl = new SerializationContextImpl((Writer)object, messageContext);
                sOAPEnvelope.output(serializationContextImpl);
                ((Writer)object).close();
            }
            catch (Exception exception) {
                log.debug((Object)Messages.getMessage("exceptionPrinting"), (Throwable)exception);
            }
            finally {
                log.debug((Object)((StringWriter)object2).getBuffer().toString());
            }
        }
        if (this.isRPCOneway(messageContext)) {
            this.invokeEngineOneWay(messageContext);
        } else {
            this.invokeEngine(messageContext);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: Call::invoke()");
        }
    }

    private void addAttachments(Message message, Vector vector) {
        if (vector != null && !vector.isEmpty()) {
            try {
                Attachments attachments = message.getAttachmentsImpl();
                if (attachments == null) {
                    throw new RuntimeException(Messages.getMessage("noAttachments"));
                }
                attachments.setAttachmentParts(vector);
                vector.clear();
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.client.Connection.addAttachments", (String)"1564", (Object)this);
                log.info((Object)Messages.getMessage("webServicesFault00"), (Throwable)webServicesFault);
                throw new RuntimeException(webServicesFault.getMessage());
            }
        }
    }

    private boolean isRPCOneway(MessageContext messageContext) {
        return messageContext.getOperation().isOneway();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setTimeout(MessageContext messageContext) {
        String string;
        QName qName;
        block12: {
            qName = messageContext.getPortName();
            string = null;
            try {
                try {
                    SOAPPort sOAPPort = this.service.getEngine().getPort(qName);
                    if (sOAPPort != null) {
                        string = (String)sOAPPort.getOption("SyncTimeout");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Connection.setTimeout", (String)"660", (Object)this);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage("exceptionPrinting"), (Throwable)exception);
                    }
                    Object var6_7 = null;
                    if (string == null) {
                        string = "300";
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("PortComponent: " + qName + "  Timeout: " + string));
                    }
                    messageContext.setTimeout(Integer.parseInt(string) * 1000);
                    return;
                }
                Object var6_6 = null;
                if (string != null) break block12;
                string = "300";
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (string == null) {
                    string = "300";
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PortComponent: " + qName + "  Timeout: " + string));
                }
                messageContext.setTimeout(Integer.parseInt(string) * 1000);
                throw throwable;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("PortComponent: " + qName + "  Timeout: " + string));
        }
        messageContext.setTimeout(Integer.parseInt(string) * 1000);
    }

    private void invokeEngine(MessageContext messageContext) throws WebServicesFault {
        Message message;
        if (messageContext.getTimeout() == 0) {
            this.setTimeout(messageContext);
        }
        this.service.getEngine().invoke(messageContext);
        if (this.transport != null) {
            this.transport.processReturnedMessageContext(messageContext);
        }
        if ((message = messageContext.getResponseMessage()) == null) {
            return;
        }
        message.setMessageType(MessageType.RESPONSE);
        message.ifFaultThrowSelf();
    }

    private void invokeEngineOneWay(MessageContext messageContext) throws WebServicesFault {
        log.info((Object)Messages.getMessage("onewayOperation", messageContext.getOperation().getName()));
        try {
            this.service.getEngine().invoke(messageContext);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.client.Connection.invokeEngineOneWay", (String)"734", (Object)this);
            throw WebServicesFault.makeFault(exception);
        }
    }

    public Service getService() {
        return this.service;
    }

    private void addHeaderParam(ParamValue paramValue) {
        if (this.myHeaderParams == null) {
            this.myHeaderParams = new Vector();
        }
        this.myHeaderParams.add(paramValue);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Protocols.init();
        Connection.setTransportForProtocol("java", class$com$ibm$ws$webservices$engine$transport$java$JavaTransport == null ? (class$com$ibm$ws$webservices$engine$transport$java$JavaTransport = Connection.class$("com.ibm.ws.webservices.engine.transport.java.JavaTransport")) : class$com$ibm$ws$webservices$engine$transport$java$JavaTransport);
        Connection.setTransportForProtocol("local", class$com$ibm$ws$webservices$engine$transport$local$LocalTransport == null ? (class$com$ibm$ws$webservices$engine$transport$local$LocalTransport = Connection.class$("com.ibm.ws.webservices.engine.transport.local.LocalTransport")) : class$com$ibm$ws$webservices$engine$transport$local$LocalTransport);
        Connection.setTransportForProtocol("http", class$com$ibm$ws$webservices$engine$transport$http$HTTPTransport == null ? (class$com$ibm$ws$webservices$engine$transport$http$HTTPTransport = Connection.class$("com.ibm.ws.webservices.engine.transport.http.HTTPTransport")) : class$com$ibm$ws$webservices$engine$transport$http$HTTPTransport);
        Connection.setTransportForProtocol("https", class$com$ibm$ws$webservices$engine$transport$http$HTTPTransport == null ? (class$com$ibm$ws$webservices$engine$transport$http$HTTPTransport = Connection.class$("com.ibm.ws.webservices.engine.transport.http.HTTPTransport")) : class$com$ibm$ws$webservices$engine$transport$http$HTTPTransport);
        Connection.setTransportForProtocol("jms", class$com$ibm$ws$webservices$engine$transport$jms$JMSTransport == null ? (class$com$ibm$ws$webservices$engine$transport$jms$JMSTransport = Connection.class$("com.ibm.ws.webservices.engine.transport.jms.JMSTransport")) : class$com$ibm$ws$webservices$engine$transport$jms$JMSTransport);
    }
}

