/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.components.net;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.SSLConfig;
import com.ibm.ws.webservices.component.WSServerImpl;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Messages;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;

public class SSLConfiguration {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$components$net$SSLConfiguration == null ? (class$com$ibm$ws$webservices$engine$components$net$SSLConfiguration = SSLConfiguration.class$("com.ibm.ws.webservices.engine.components.net.SSLConfiguration")) : class$com$ibm$ws$webservices$engine$components$net$SSLConfiguration).getName());
    public static final String configURLProperty = "com.ibm.CORBA.ConfigURL";
    public static final String wsSSLconfigURLProperty = "com.ibm.webservices.sslConfigURL";
    private String sslAliasConfigured = null;
    private SSLConfig sslConfigured = null;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$components$net$SSLConfiguration;

    public SSLConfiguration(boolean bl) {
        this.sslConfigured = new SSLConfig(bl);
    }

    public SSLSocketFactory getSocketFactoryByPropFile(final String string) {
        SSLSocketFactory sSLSocketFactory = null;
        Properties properties = null;
        try {
            properties = (Properties)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    InputStream inputStream = null;
                    Properties properties = null;
                    try {
                        URL uRL = new URL(string);
                        inputStream = uRL.openStream();
                        if (inputStream != null) {
                            properties = new Properties();
                            properties.load(inputStream);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.run", (String)"88", (Object)this);
                        throw exception;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    return properties;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.getSocketFactoryByPropFile", (String)"109", (Object)this);
            log.debug((Object)Messages.getMessage("exception01", this.exceptionToString(privilegedActionException.getException() == null ? privilegedActionException : privilegedActionException.getException())));
        }
        if (properties != null) {
            this.sslConfigured.init(properties);
            try {
                if (log.isDebugEnabled()) {
                    String string2 = this.sslConfigured.getKeyFileName();
                    String string3 = this.sslConfigured.getTrustFileName();
                    String string4 = this.sslConfigured.getTokenLibraryFile();
                    if (JavaUtils.hasValue(string2) && JavaUtils.hasValue(string3) && JavaUtils.hasValue(string4)) {
                        log.debug((Object)Messages.getMessage("keyStoresUsed00", string2, string3, null));
                    } else {
                        log.debug((Object)Messages.getMessage("keyStoresUsed00", string2, string3, string4));
                    }
                }
                sSLSocketFactory = this.sslConfigured.getSocketFactory();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.getSocketFactoryByPropFile", (String)"137", (Object)this);
                log.debug((Object)Messages.getMessage("exception01", this.exceptionToString(exception)));
            }
        } else {
            log.debug((Object)("SSL Properties: " + properties));
        }
        return sSLSocketFactory;
    }

    public SSLSocketFactory getSocketFactoryBySSLAlias(String string) {
        SSLSocketFactory sSLSocketFactory = null;
        Properties properties = null;
        if (string != null) {
            this.sslAliasConfigured = new String(string);
            try {
                SecurityService securityService = WSServerImpl.getSecurityService();
                if (securityService != null) {
                    properties = securityService.getSecureSocketLayer(this.sslAliasConfigured);
                    if (properties != null) {
                        this.sslConfigured.init(properties);
                        String string2 = this.sslConfigured.getKeyFileName();
                        String string3 = this.sslConfigured.getTrustFileName();
                        String string4 = this.sslConfigured.getTokenLibraryFile();
                        if (JavaUtils.hasValue(string2) && JavaUtils.hasValue(string3) && JavaUtils.hasValue(string4)) {
                            log.debug((Object)Messages.getMessage("keyStoresUsed00", string2, string3, null));
                        } else {
                            log.debug((Object)Messages.getMessage("keyStoresUsed00", string2, string3, string4));
                        }
                        sSLSocketFactory = this.sslConfigured.getSocketFactory();
                    } else {
                        log.debug((Object)("SSL Properties: " + properties));
                    }
                } else {
                    log.debug((Object)("SecurityService: " + securityService));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.components.net.SSLConfiguration.getSocketFactoryBySSLAlias", (String)"196", (Object)this);
                log.debug((Object)Messages.getMessage("exception01", this.exceptionToString(exception)));
            }
        }
        return sSLSocketFactory;
    }

    private String exceptionToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

