/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.configuration;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WSDDEngineConfiguration;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.NullEngineConfigurationProvider;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDocument;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class FileEngineConfigurationProvider
extends NullEngineConfigurationProvider
implements WSDDEngineConfiguration {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$configuration$FileEngineConfigurationProvider == null ? (class$com$ibm$ws$webservices$engine$configuration$FileEngineConfigurationProvider = FileEngineConfigurationProvider.class$("com.ibm.ws.webservices.engine.configuration.FileEngineConfigurationProvider")) : class$com$ibm$ws$webservices$engine$configuration$FileEngineConfigurationProvider).getName());
    public static final int MODE_CS_CLIENT = 1;
    public static final int MODE_CS_SERVER = 2;
    private String _filename;
    private File _configFile;
    private InputStream _inputStream = null;
    private WSDDDeployment _deployment = null;
    private boolean _searchClasspath = true;
    private boolean _readOnly = true;
    private final int _modeClientServer;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$configuration$FileEngineConfigurationProvider;

    protected FileEngineConfigurationProvider(int n) {
        this._modeClientServer = n;
    }

    public FileEngineConfigurationProvider(int n, String string) {
        this._modeClientServer = n;
        this._filename = string;
        this._configFile = new File(string);
        this.check();
    }

    public FileEngineConfigurationProvider(int n, String string, String string2) throws ConfigurationException {
        this._modeClientServer = n;
        this._filename = string2;
        File file = new File(string);
        if (!file.isDirectory() || !file.canRead()) {
            throw new ConfigurationException(Messages.getMessage("invalidConfigFilePath", string));
        }
        this._configFile = new File(string, this._filename);
        this.check();
    }

    private void check() {
        this._readOnly = this._configFile.canRead() & !this._configFile.canWrite();
        if (this._readOnly) {
            log.info((Object)Messages.getMessage("readOnlyConfigFile"));
        }
    }

    public FileEngineConfigurationProvider(int n, InputStream inputStream) {
        this._modeClientServer = n;
        this.setInputStream(inputStream);
    }

    public void setSearchClasspath(boolean bl) {
        this.verifyInactive();
        this._searchClasspath = bl;
    }

    protected void setInputStream(InputStream inputStream) {
        this.verifyInactive();
        this._inputStream = inputStream;
    }

    protected InputStream getInputStream() throws ConfigurationException {
        if (this._inputStream == null) {
            this._inputStream = this.createInputStream();
        }
        if (this._inputStream == null) {
            throw new ConfigurationException(Messages.getMessage("noConfigFile"));
        }
        return this._inputStream;
    }

    public static boolean canGetInputStream(String string) {
        File file = new File(string);
        if (file.canRead()) {
            return true;
        }
        return ClassUtils.getResource(class$com$ibm$ws$webservices$engine$configuration$FileEngineConfigurationProvider == null ? (class$com$ibm$ws$webservices$engine$configuration$FileEngineConfigurationProvider = FileEngineConfigurationProvider.class$("com.ibm.ws.webservices.engine.configuration.FileEngineConfigurationProvider")) : class$com$ibm$ws$webservices$engine$configuration$FileEngineConfigurationProvider, string) != null;
    }

    protected InputStream createInputStream() {
        block3: {
            if (this._configFile != null) {
                try {
                    return new FileInputStream(this._configFile);
                }
                catch (Exception exception) {
                    if (!this._searchClasspath || this.getClass() == null) break block3;
                    return ClassUtils.getResourceAsStream(this.getClass(), this._filename);
                }
            }
        }
        return null;
    }

    private WSDDDeployment getDeployment() throws ConfigurationException {
        if (this._deployment == null) {
            try {
                InputStream inputStream = this.getInputStream();
                this.setInputStream(null);
                WSDDDocument wSDDDocument = new WSDDDocument(this._modeClientServer, XMLUtils.newDocument(inputStream));
                this._deployment = wSDDDocument.getDeployment();
                this._deployment.setContainerManaged(this.isContainerManaged());
                inputStream.close();
                this.manageLifeCycleOf(this._deployment);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.configuration.FileEngineConfigurationProvider.configureEngine", (String)"220", (Object)this);
                throw ConfigurationException.makeConfigurationException(exception);
            }
        }
        return this._deployment;
    }

    public Document getDocument() throws ConfigurationException {
        return this.getDeployment().getDocument();
    }

    public SOAPPort getPort(QName qName) throws ConfigurationException {
        return this.getDeployment().getPort(qName);
    }

    public SOAPPort getPortByNamespaceURI(String string) throws ConfigurationException {
        return this.getDeployment().getPortByNamespaceURI(string);
    }

    public Handler getTransport(QName qName) throws ConfigurationException {
        return this.getDeployment().getTransport(qName);
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        return this.getDeployment().getTypeMappingRegistry();
    }

    public SimpleTargetedChain getGlobalHandler() throws ConfigurationException {
        return this.getDeployment().getGlobalHandler();
    }

    public Map getGlobalOptions() {
        try {
            return this.getDeployment().getGlobalOptions();
        }
        catch (ConfigurationException configurationException) {
            return null;
        }
    }

    public Iterator getDeployedPorts() throws ConfigurationException {
        return this.getDeployment().getDeployedPorts();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

