/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.tools.WSDLQuery;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDGen
extends WSDDElement {
    protected String wsdlFile = null;
    protected String wsdlContext = null;
    protected InputStream wsdlInputStream = null;
    private ArrayList namespaces = new ArrayList();
    private ArrayList packages = new ArrayList();
    private HashMap namespaceMap = new HashMap();
    private MappingMetaData inputMapping = null;

    public WSDDGen() {
    }

    public WSDDGen(Element element) throws WSDDException {
        this.wsdlFile = element.getAttribute("wsdl");
        Element[] elementArray = this.getChildElements(element, "pair");
        for (int i = 0; i < elementArray.length; ++i) {
            this.setNamespacePackagePair(elementArray[i].getAttribute("namespace"), elementArray[i].getAttribute("package"));
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "wsdl", "wsdl", "CDATA", this.wsdlFile);
        QName qName = new QName("", "Gen");
        serializationContext.getSerializationWriter().startElement(qName, attributesImpl);
        for (int i = 0; i < this.namespaces.size(); ++i) {
            qName = new QName("", "pair");
            attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "namespace", "namespace", "CDATA", (String)this.namespaces.get(i));
            attributesImpl.addAttribute("", "package", "package", "CDATA", (String)this.packages.get(i));
            serializationContext.getSerializationWriter().startElement(qName, attributesImpl);
            serializationContext.getSerializationWriter().endElement();
        }
        serializationContext.getSerializationWriter().endElement();
    }

    protected QName getElementName() {
        return new QName("", "Gen");
    }

    public void setWSDLFile(String string) {
        this.wsdlFile = string;
    }

    public void setWSDLFile(String string, InputStream inputStream) {
        this.wsdlContext = string;
        this.wsdlInputStream = inputStream;
    }

    public void setNamespacePackagePair(String string, String string2) {
        if (string != null && string2 != null) {
            this.namespaces.add(string);
            this.packages.add(string2);
            this.namespaceMap.put(string, string2);
        }
    }

    public void setInputMapping(MappingMetaData mappingMetaData) {
        this.inputMapping = mappingMetaData;
    }

    public WSDLQuery getWSDLQuery() throws Exception {
        WSDLQuery wSDLQuery = new WSDLQuery(this.namespaceMap);
        if (this.inputMapping != null) {
            wSDLQuery.setInputMapping(this.inputMapping);
        }
        if (this.wsdlFile != null) {
            wSDLQuery.parse(this.wsdlFile);
        } else {
            wSDLQuery.parse(this.wsdlContext, this.wsdlInputStream);
        }
        return wSDLQuery;
    }
}

