/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployableItem;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfo;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfoChain;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public abstract class WSDDTargetedChain
extends WSDDDeployableItem {
    private WSDDChain requestFlow;
    private WSDDChain responseFlow;
    private QName pivotQName;
    private WSDDJAXRPCHandlerInfoChain jaxrpcChain;
    public static final int MODE_CS_CLIENT = 1;
    public static final int MODE_CS_SERVER = 2;
    private int _modeClientServer = 0;
    protected Handler _cachedPort = null;

    protected WSDDTargetedChain(int n) {
        this._modeClientServer = n;
    }

    protected WSDDTargetedChain(int n, Element element) throws WSDDException {
        super(element);
        String string;
        Element element2;
        this._modeClientServer = n;
        Element element3 = this.getChildElement(element, "requestFlow");
        if (element3 != null && element3.getElementsByTagName("*").getLength() > 0) {
            this.setRequestFlow(new WSDDChain(n == 1, element3));
        }
        if ((element2 = this.getChildElement(element, "responseFlow")) != null && element2.getElementsByTagName("*").getLength() > 0) {
            this.setResponseFlow(new WSDDChain(n == 1, element2));
        }
        if ((string = element.getAttribute("pivot")) != null && !string.equals("")) {
            this.pivotQName = XMLUtils.getQNameFromString(string, element);
        }
    }

    protected WSDDChain getRequestFlow() {
        return this.requestFlow;
    }

    public void setRequestFlow(WSDDChain wSDDChain) {
        if (this.requestFlow != null && this.releaseLifeCycleManagementOf(this.requestFlow) && this.requestFlow.isActive()) {
            this.requestFlow.destroy();
        }
        this.requestFlow = wSDDChain;
        this._cachedPort = null;
        if (this.requestFlow != null) {
            this.manageLifeCycleOf(this.requestFlow);
        }
    }

    protected WSDDChain getResponseFlow() {
        return this.responseFlow;
    }

    public void setResponseFlow(WSDDChain wSDDChain) {
        if (this.responseFlow != null && this.releaseLifeCycleManagementOf(this.responseFlow) && this.responseFlow.isActive()) {
            this.responseFlow.destroy();
        }
        this.responseFlow = wSDDChain;
        this._cachedPort = null;
        if (this.responseFlow != null) {
            this.manageLifeCycleOf(this.responseFlow);
        }
    }

    public HandlerChain getHandlerChain() {
        return this.jaxrpcChain != null && this.jaxrpcChain.size() > 0 ? this.jaxrpcChain.getHandlerChain() : null;
    }

    public WSDDJAXRPCHandlerInfoChain getHandlerInfoChain() {
        return this.jaxrpcChain;
    }

    public void setHandlerInfoChain(WSDDJAXRPCHandlerInfoChain wSDDJAXRPCHandlerInfoChain) {
        if (this.jaxrpcChain != null && this.releaseLifeCycleManagementOf(this.jaxrpcChain) && this.jaxrpcChain.isActive()) {
            this.jaxrpcChain.destroy();
        }
        this.jaxrpcChain = wSDDJAXRPCHandlerInfoChain;
        this._cachedPort = null;
        if (this.jaxrpcChain != null) {
            this.manageLifeCycleOf(this.jaxrpcChain);
        }
    }

    public void addHandlerInfo(WSDDJAXRPCHandlerInfo wSDDJAXRPCHandlerInfo) {
        if (this.jaxrpcChain == null) {
            this.jaxrpcChain = new WSDDJAXRPCHandlerInfoChain(this._modeClientServer == 1);
        }
        this.jaxrpcChain.addHandlerInfo(wSDDJAXRPCHandlerInfo);
        this._cachedPort = null;
    }

    public void addHandlerInfo(WSDDJAXRPCHandlerInfoChain wSDDJAXRPCHandlerInfoChain) {
        if (this.jaxrpcChain == null) {
            this.jaxrpcChain = new WSDDJAXRPCHandlerInfoChain(this._modeClientServer == 1);
        }
        this.jaxrpcChain.addHandlerInfoList(wSDDJAXRPCHandlerInfoChain.getHandlerInfoList());
        this._cachedPort = null;
    }

    public QName getPivotQName() {
        return this.pivotQName;
    }

    public void setPivotQName(QName qName) {
        this.pivotQName = qName;
        this._cachedPort = null;
    }

    public int getModeClientServer() {
        return this._modeClientServer;
    }

    protected Handler makeNewInstance(EngineConfiguration engineConfiguration) throws ConfigurationException {
        if (this._cachedPort == null) {
            Handler handler2 = null;
            WSDDChain wSDDChain = this.getRequestFlow();
            if (wSDDChain != null) {
                handler2 = wSDDChain.getInstance(engineConfiguration);
            }
            Handler handler3 = null;
            if (this.pivotQName != null) {
                if ("http://websphere.ibm.com/webservices/wsdd/providers/java".equals(this.pivotQName.getNamespaceURI())) {
                    try {
                        handler3 = (Handler)ClassUtils.forName(this.pivotQName.getLocalPart()).newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTargetedChain.makeNewInstance", (String)"199", (Object)this);
                        throw WSDDException.makeWSDDException(instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTargetedChain.makeNewInstance", (String)"202", (Object)this);
                        throw WSDDException.makeWSDDException(illegalAccessException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTargetedChain.makeNewInstance", (String)"205", (Object)this);
                        throw WSDDException.makeWSDDException(classNotFoundException);
                    }
                } else {
                    throw new WSDDException(Messages.getMessage("badTypeNamespace00", this.pivotQName.getNamespaceURI(), "http://websphere.ibm.com/webservices/wsdd/providers/java"));
                }
            }
            Handler handler4 = null;
            WSDDChain wSDDChain2 = this.getResponseFlow();
            if (wSDDChain2 != null) {
                handler4 = wSDDChain2.getInstance(engineConfiguration);
            }
            this._cachedPort = JAXRPCHandler.factory(handler2, handler3, handler4, this.getHandlerChain(), this.getModeClientServer());
        }
        return this._cachedPort;
    }

    public final void writeFlowsToContext(SerializationContext serializationContext) throws IOException {
        if (this.requestFlow != null) {
            this.requestFlow.writeToContext(serializationContext);
        }
        if (this.responseFlow != null) {
            this.responseFlow.writeToContext(serializationContext);
        }
    }
}

