/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDTypeMapping
extends WSDDElement {
    protected QName qname = null;
    protected String serializer = null;
    protected String deserializer = null;
    protected QName typeQName = null;
    protected String ref = null;
    protected String encodingStyle = null;

    public WSDDTypeMapping() {
    }

    public WSDDTypeMapping(Element element) throws WSDDException {
        this.serializer = element.getAttribute("serializer");
        this.deserializer = element.getAttribute("deserializer");
        Attr attr = element.getAttributeNode("encodingStyle");
        this.encodingStyle = attr == null ? Constants.URI_DEFAULT_SOAP_ENC : attr.getValue();
        String string = element.getAttribute("qname");
        this.qname = XMLUtils.getQNameFromString(string, element);
        String string2 = element.getAttribute("type");
        this.typeQName = XMLUtils.getQNameFromString(string2, element);
        if (string2 == null || string2.equals("")) {
            string2 = element.getAttribute("languageSpecificType");
            this.typeQName = XMLUtils.getQNameFromString(string2, element);
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "encodingStyle", "encodingStyle", "CDATA", this.encodingStyle);
        attributesImpl.addAttribute("", "serializer", "serializer", "CDATA", this.serializer);
        attributesImpl.addAttribute("", "deserializer", "deserializer", "CDATA", this.deserializer);
        String string = serializationContext.getSerializationWriter().qName2String(this.typeQName);
        attributesImpl.addAttribute("", "type", "type", "CDATA", string);
        String string2 = serializationContext.getSerializationWriter().qName2String(this.qname);
        attributesImpl.addAttribute("", "qname", "qname", "CDATA", string2);
        serializationContext.getSerializationWriter().simpleElement(QNAME_TYPEMAPPING, attributesImpl, null);
    }

    protected QName getElementName() {
        return QNAME_TYPEMAPPING;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String string) {
        this.ref = string;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void setEncodingStyle(String string) {
        this.encodingStyle = string;
    }

    public QName getQName() {
        return this.qname;
    }

    public void setQName(QName qName) {
        this.qname = qName;
    }

    public Class getLanguageSpecificType() throws ClassNotFoundException {
        if (this.typeQName != null) {
            if (!"http://websphere.ibm.com/webservices/wsdd/providers/java".equals(this.typeQName.getNamespaceURI())) {
                throw new ClassNotFoundException(Messages.getMessage("badTypeNamespace00", this.typeQName.getNamespaceURI(), "http://websphere.ibm.com/webservices/wsdd/providers/java"));
            }
            String string = JavaUtils.getLoadableClassName(this.typeQName.getLocalPart());
            if (JavaUtils.getWrapper(string) != null) {
                // empty if block
            }
            return ClassUtils.forName(string);
        }
        throw new ClassNotFoundException(Messages.getMessage("noTypeQName00"));
    }

    public void setLanguageSpecificType(Class clazz) {
        String string = clazz.getName();
        this.typeQName = QNameTable.createQName("http://websphere.ibm.com/webservices/wsdd/providers/java", string);
    }

    public void setLanguageSpecificType(String string) {
        this.typeQName = QNameTable.createQName("http://websphere.ibm.com/webservices/wsdd/providers/java", string);
    }

    public Class getSerializer() throws ClassNotFoundException {
        return ClassUtils.forName(this.serializer);
    }

    public String getSerializerName() {
        return this.serializer;
    }

    public void setSerializer(Class clazz) {
        this.serializer = clazz.getName();
    }

    public void setSerializer(String string) {
        this.serializer = string;
    }

    public Class getDeserializer() throws ClassNotFoundException {
        return ClassUtils.forName(this.deserializer);
    }

    public String getDeserializerName() {
        return this.deserializer;
    }

    public void setDeserializer(Class clazz) {
        this.deserializer = clazz.getName();
    }

    public void setDeserializer(String string) {
        this.deserializer = string;
    }
}

