/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.description;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.configurable.ConfigurableImpl;
import com.ibm.ws.webservices.engine.configurable.Configured;
import com.ibm.ws.webservices.engine.description.FaultDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.enum.Style;
import com.ibm.ws.webservices.engine.enum.Use;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;

public class OperationDesc
implements Configurable {
    public static String TARGET_NAMESPACE = "targetNamespace";
    public static String INPUT_MESSAGE_QNAME = "inputMessageQName";
    public static String OUTPUT_MESSAGE_QNAME = "outputMessageQName";
    public static String INPUT_NAME = "inputName";
    public static String OUTPUT_NAME = "outputName";
    public static String PORT_TYPE_QNAME = "portTypeQName";
    public static final int MSG_METHOD_BODYARRAY = 1;
    public static final int MSG_METHOD_SOAPENVELOPE = 2;
    public static final int MSG_METHOD_ELEMENTARRAY = 3;
    public static final int MSG_METHOD_DOCUMENT = 4;
    public static final int MSG_METHOD_NONCONFORMING = -4;
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$description$OperationDesc == null ? (class$com$ibm$ws$webservices$engine$description$OperationDesc = OperationDesc.class$("com.ibm.ws.webservices.engine.description.OperationDesc")) : class$com$ibm$ws$webservices$engine$description$OperationDesc).getName());
    private PortDesc parent;
    private ArrayList parameters = new ArrayList();
    private String name;
    private QName elementQName;
    private Method method;
    private Style style = null;
    private Use use = null;
    private int numInParams = 0;
    private String soapAction = null;
    private ArrayList faults = null;
    private ParameterDesc returnDesc = null;
    private boolean hasOutParams = false;
    private Configurable _configurable = null;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$description$OperationDesc;

    public OperationDesc() {
    }

    public OperationDesc(String string, ParameterDesc[] parameterDescArray, QName qName) {
        this.name = string;
        if (qName != null) {
            this.initReturnDesc();
            this.returnDesc.setQName(qName);
            this.returnDesc.setMode((byte)2);
            this.returnDesc.setIsReturn(true);
        }
        for (int i = 0; i < parameterDescArray.length; ++i) {
            this.addParameter(parameterDescArray[i]);
            if (parameterDescArray[i].getMode() == 1) continue;
            this.hasOutParams = true;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        OperationDesc operationDesc = (OperationDesc)object;
        if (this.name != null && !this.name.equals(operationDesc.name) || this.name == null && operationDesc.name != null) {
            return false;
        }
        if (this.returnDesc != null && !this.returnDesc.equals(operationDesc.returnDesc) || this.returnDesc == null && operationDesc.returnDesc != null) {
            return false;
        }
        if (this.parameters != null && operationDesc.parameters == null || this.parameters == null && operationDesc.parameters != null) {
            return false;
        }
        if (this.parameters != null) {
            if (this.parameters.size() != operationDesc.parameters.size()) {
                return false;
            }
            for (int i = 0; i < this.parameters.size(); ++i) {
                if ((this.parameters.get(i) == null || this.parameters.get(i).equals(operationDesc.parameters.get(i))) && (this.parameters.get(i) != null || operationDesc.parameters.get(i) == null)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        if (this.name != null) {
            n += this.name.hashCode();
        }
        if (this.returnDesc != null) {
            n += this.returnDesc.hashCode();
        }
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (this.parameters.get(i) == null) continue;
                n += this.parameters.get(i).hashCode();
            }
        }
        return n;
    }

    private void initReturnDesc() {
        if (this.returnDesc == null) {
            this.returnDesc = new ParameterDesc();
            this.returnDesc.setMode((byte)2);
            this.returnDesc.setIsReturn(true);
            this.hasOutParams = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public QName getReturnQName() {
        return this.returnDesc == null ? null : this.returnDesc.getQName();
    }

    public void setReturnQName(QName qName) {
        if (qName != null) {
            this.initReturnDesc();
            this.returnDesc.setQName(qName);
        }
    }

    public QName getReturnType() {
        return this.returnDesc == null ? null : this.returnDesc.getTypeQName();
    }

    public void setReturnType(QName qName) {
        log.debug((Object)("@" + Integer.toHexString(this.hashCode()) + "setReturnType(" + qName + ")"));
        if (qName != null) {
            this.initReturnDesc();
            this.returnDesc.setTypeQName(qName);
        }
    }

    public Class getReturnClass() {
        return this.returnDesc == null ? null : this.returnDesc.getJavaType();
    }

    public void setReturnClass(Class clazz) {
        if (clazz != null) {
            this.initReturnDesc();
            this.returnDesc.setJavaType(clazz);
        }
    }

    public QName getElementQName() {
        return this.elementQName;
    }

    public void setElementQName(QName qName) {
        this.elementQName = qName;
    }

    public PortDesc getParent() {
        return this.parent;
    }

    public void setParent(PortDesc portDesc) {
        this.parent = portDesc;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String string) {
        this.soapAction = string;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        if (this.style == null) {
            if (this.parent != null) {
                return this.parent.getStyle();
            }
            return Style.DEFAULT;
        }
        return this.style;
    }

    public void setUse(Use use) {
        this.use = use;
    }

    public Use getUse() {
        if (this.use == null) {
            if (this.parent != null) {
                return this.parent.getUse();
            }
            return Use.DEFAULT;
        }
        return this.use;
    }

    public void addParameter(ParameterDesc parameterDesc) {
        this.parameters.add(parameterDesc);
        if (parameterDesc.getMode() != 1) {
            this.hasOutParams = true;
        }
        if (parameterDesc.getMode() == 1 || parameterDesc.getMode() == 3) {
            parameterDesc.setOrder(this.numInParams++);
        }
        log.debug((Object)("@" + Integer.toHexString(this.hashCode()) + " added parameter >" + parameterDesc + "@" + Integer.toHexString(parameterDesc.hashCode()) + "<total parameters:" + this.getNumParams()));
    }

    public ParameterDesc getParameter(int n) {
        if (this.parameters.size() <= n) {
            return null;
        }
        return (ParameterDesc)this.parameters.get(n);
    }

    public ArrayList getParameters() {
        return this.parameters;
    }

    void setParameters(ArrayList arrayList) {
        arrayList = new ArrayList();
        ListIterator listIterator = this.parameters.listIterator();
        while (listIterator.hasNext()) {
            ParameterDesc parameterDesc = (ParameterDesc)listIterator.next();
            this.addParameter(parameterDesc);
            if (parameterDesc.getMode() == 1) continue;
            this.hasOutParams = true;
        }
    }

    public int getNumInParams() {
        return this.numInParams;
    }

    public int getNumParams() {
        return this.parameters.size();
    }

    public int getNumInParams(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)this.parameters.get(i);
            if (parameterDesc.getMode() == 2 || (!bl || parameterDesc.isInHeader()) && (bl || !parameterDesc.isInHeader())) continue;
            ++n;
        }
        return n;
    }

    public int getNumOutParams(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)this.parameters.get(i);
            if (parameterDesc.getMode() == 1 || (!bl || parameterDesc.isOutHeader()) && (bl || !parameterDesc.isOutHeader())) continue;
            ++n;
        }
        return n;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public boolean isReturnHeader() {
        return this.returnDesc == null ? false : this.returnDesc.isOutHeader();
    }

    public void setReturnHeader(boolean bl) {
        this.initReturnDesc();
        this.returnDesc.setOutHeader(bl);
    }

    public ParameterDesc getParamByQName(QName qName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)this.parameters.get(i);
            if (!parameterDesc.getQName().equals(qName)) continue;
            return parameterDesc;
        }
        ParameterDesc parameterDesc = this.getInputAnyParam();
        if (parameterDesc == null) {
            parameterDesc = this.getOutputAnyParam();
        }
        return parameterDesc;
    }

    public ParameterDesc getInputParamByQName(QName qName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)this.parameters.get(i);
            if (parameterDesc.getMode() == 2 || !parameterDesc.getQName().equals(qName)) continue;
            return parameterDesc;
        }
        return this.getInputAnyParam();
    }

    public ParameterDesc getOutputParamByQName(QName qName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)this.parameters.get(i);
            if (parameterDesc.getMode() == 1 || !parameterDesc.getQName().equals(qName)) continue;
            return parameterDesc;
        }
        ParameterDesc parameterDesc = this.getOutputAnyParam();
        if (this.returnDesc != null && this.returnDesc.getQName() == null) {
            parameterDesc = new ParameterDesc(this.returnDesc);
            parameterDesc.setQName(qName);
        } else if (this.returnDesc != null && qName.equals(this.returnDesc.getQName())) {
            parameterDesc = this.returnDesc;
        }
        return parameterDesc;
    }

    public ArrayList getOutParams() {
        ArrayList<ParameterDesc> arrayList = new ArrayList<ParameterDesc>();
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            ParameterDesc parameterDesc = (ParameterDesc)iterator.next();
            if (parameterDesc.getMode() != 2) continue;
            arrayList.add(parameterDesc);
        }
        return arrayList;
    }

    public final ParameterDesc getInputAnyParam() {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)this.parameters.get(i);
            if (parameterDesc.getMode() == 2 || !Constants.equals(parameterDesc.getQName(), Constants.XSD_ANY) && !Constants.equals(parameterDesc.getTypeQName(), Constants.XSD_ANY)) continue;
            return parameterDesc;
        }
        return null;
    }

    public final ParameterDesc getOutputAnyParam() {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)this.parameters.get(i);
            if (parameterDesc.getMode() == 1 || !Constants.equals(parameterDesc.getQName(), Constants.XSD_ANY) && !Constants.equals(parameterDesc.getTypeQName(), Constants.XSD_ANY)) continue;
            return parameterDesc;
        }
        if (this.returnDesc != null && (Constants.equals(this.returnDesc.getQName(), Constants.XSD_ANY) || Constants.equals(this.returnDesc.getTypeQName(), Constants.XSD_ANY))) {
            return this.returnDesc;
        }
        return null;
    }

    public void addFault(FaultDesc faultDesc) {
        if (this.faults == null) {
            this.faults = new ArrayList();
        }
        this.faults.add(faultDesc);
    }

    public ArrayList getFaults() {
        return this.faults;
    }

    public FaultDesc getFaultByClass(Class clazz) {
        if (this.faults == null || clazz == null) {
            return null;
        }
        while (clazz != null) {
            Iterator iterator = this.faults.iterator();
            while (iterator.hasNext()) {
                FaultDesc faultDesc = (FaultDesc)iterator.next();
                if (!clazz.getName().equals(faultDesc.getClassName())) continue;
                return faultDesc;
            }
            if ((clazz = clazz.getSuperclass()) == null || !clazz.getName().startsWith("java.") && !clazz.getName().startsWith("javax.")) continue;
            clazz = null;
        }
        return null;
    }

    public FaultDesc getFaultByFaultCode(QName qName) {
        if (this.faults != null) {
            Iterator iterator = this.faults.iterator();
            while (iterator.hasNext()) {
                FaultDesc faultDesc = (FaultDesc)iterator.next();
                if (!qName.equals(faultDesc.getFaultCode())) continue;
                return faultDesc;
            }
        }
        return null;
    }

    public ParameterDesc getReturnParamDesc() {
        return this.returnDesc;
    }

    public boolean isOneway() {
        return this.returnDesc == null && !this.hasOutParams;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        int n;
        String string2 = "";
        string2 = string2 + string + "name:        " + this.getName() + "\n";
        string2 = string2 + string + "returnQName: " + this.getReturnQName() + "\n";
        string2 = string2 + string + "returnType:  " + this.getReturnType() + "\n";
        string2 = string2 + string + "returnClass: " + this.getReturnClass() + "\n";
        string2 = string2 + string + "elementQName:" + this.getElementQName() + "\n";
        string2 = string2 + string + "soapAction:  " + this.getSoapAction() + "\n";
        string2 = string2 + string + "style:       " + this.getStyle().getName() + "\n";
        string2 = string2 + string + "use:         " + this.getUse().getName() + "\n";
        string2 = string2 + string + "numInParams: " + this.getNumInParams() + "\n";
        string2 = string2 + string + "properties: \n";
        string2 = string2 + this.toStringConfigurable(string + " ");
        string2 = string2 + string + "method:" + this.getMethod() + "\n";
        for (n = 0; n < this.parameters.size(); ++n) {
            string2 = string2 + string + " ParameterDesc[" + n + "]:\n";
            string2 = string2 + string + ((ParameterDesc)this.parameters.get(n)).toString("  ") + "\n";
        }
        if (this.faults != null) {
            for (n = 0; n < this.faults.size(); ++n) {
                string2 = string2 + string + " FaultDesc[" + n + "]:\n";
                string2 = string2 + string + ((FaultDesc)this.faults.get(n)).toString("  ") + "\n";
            }
        }
        return string2;
    }

    private void makeConfigurable() {
        if (this._configurable == null) {
            this._configurable = new ConfigurableImpl();
        }
    }

    private String toStringConfigurable(String string) {
        Iterator iterator;
        String string2 = "";
        if (this._configurable != null && (iterator = this.getOptions().entrySet().iterator()) != null) {
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                string2 = string2 + string + "KEY(" + entry.getKey() + ")\n";
                string2 = string2 + string + " VALUE(" + entry.getValue() + ")\n";
            }
        }
        return string2;
    }

    public final void setOptionsDefault(Configured configured) {
        this.makeConfigurable();
        this._configurable.setOptionsDefault(configured);
    }

    public final void setOption(String string, Object object) {
        this.makeConfigurable();
        this._configurable.setOption(string, object);
    }

    public final boolean setOptionDefault(String string, Object object) {
        this.makeConfigurable();
        return this._configurable.setOptionDefault(string, object);
    }

    public final void setOptions(Map map) {
        this.makeConfigurable();
        this._configurable.setOptions(map);
    }

    public final Object getOption(String string) {
        this.makeConfigurable();
        return this._configurable.getOption(string);
    }

    public final Map getOptions() {
        this.makeConfigurable();
        return this._configurable.getOptions();
    }

    public Set getOptionsBooleanNames() {
        this.makeConfigurable();
        return this._configurable.getOptionsBooleanNames();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

