/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.description;

import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.configurable.ConfigurableImpl;
import com.ibm.ws.webservices.engine.configurable.Configured;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class ParameterDesc
implements Serializable,
Configurable {
    public static final byte IN = 1;
    public static final byte OUT = 2;
    public static final byte INOUT = 3;
    private transient QName name;
    public TypeEntry typeEntry;
    private byte mode = 1;
    private QName typeQName;
    private Class javaType = null;
    private int order = -1;
    private boolean isReturn = false;
    private boolean inHeader = false;
    private boolean outHeader = false;
    private boolean minOccursIs0 = false;
    private boolean maxOccursIs1 = true;
    private Configurable _configurable = null;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;

    public ParameterDesc() {
    }

    public ParameterDesc(ParameterDesc parameterDesc) {
        this.name = parameterDesc.name;
        this.typeEntry = parameterDesc.typeEntry;
        this.mode = parameterDesc.mode;
        this.typeQName = parameterDesc.typeQName;
        this.javaType = parameterDesc.javaType;
        this.order = parameterDesc.order;
        this.isReturn = parameterDesc.isReturn;
    }

    public ParameterDesc(QName qName, byte by, QName qName2) {
        this.name = qName;
        this.mode = by;
        this.typeQName = qName2;
    }

    public ParameterDesc(QName qName, byte by, QName qName2, Class clazz, boolean bl, boolean bl2) {
        this(qName, by, qName2);
        this.javaType = clazz;
        this.inHeader = bl;
        this.outHeader = bl2;
    }

    public ParameterDesc(QName qName, byte by, QName qName2, Class clazz, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(qName, by, qName2);
        this.javaType = clazz;
        this.inHeader = bl;
        this.outHeader = bl2;
        this.minOccursIs0 = bl3;
        this.maxOccursIs1 = bl4;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ParameterDesc parameterDesc = (ParameterDesc)object;
        if (this.name != null && !this.name.equals(parameterDesc.name) || this.name == null && parameterDesc.name != null) {
            return false;
        }
        if (this.mode != parameterDesc.mode) {
            return false;
        }
        if (this.typeQName != null && !this.typeQName.equals(parameterDesc.typeQName) || this.typeQName == null && parameterDesc.typeQName != null) {
            return false;
        }
        if (this.javaType != parameterDesc.javaType) {
            return false;
        }
        if (this.inHeader != parameterDesc.inHeader) {
            return false;
        }
        if (this.outHeader != parameterDesc.outHeader) {
            return false;
        }
        if (this.minOccursIs0 != parameterDesc.minOccursIs0) {
            return false;
        }
        return this.maxOccursIs1 == parameterDesc.maxOccursIs1;
    }

    public int hashCode() {
        int n = 0;
        if (this.name != null) {
            n += this.name.hashCode();
        }
        if (this.typeQName != null) {
            n += this.typeQName.hashCode();
        }
        if (this.javaType != null) {
            n += this.javaType.hashCode();
        }
        return n;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + "name:        " + this.name + "\n";
        string2 = string2 + string + "typeEntry:   " + this.typeEntry + "\n";
        string2 = string2 + string + "mode:        " + (this.mode == 1 ? "IN" : (this.mode == 3 ? "INOUT" : "OUT:  position:" + this.order)) + "\n";
        string2 = string2 + string + "isReturn:    " + this.isReturn + "\n";
        string2 = string2 + string + "typeQName:   " + this.typeQName + "\n";
        string2 = string2 + string + "javaType:    " + this.javaType + "\n";
        string2 = string2 + string + "inHeader:    " + this.inHeader + "\n";
        string2 = string2 + string + "outHeader:   " + this.outHeader + "\n";
        string2 = string2 + string + "minOccursIs0:" + this.minOccursIs0 + "\n";
        string2 = string2 + string + "maxOccursIs1:" + this.maxOccursIs1 + "\n";
        string2 = string2 + string + "properties: \n";
        string2 = string2 + this.toStringConfigurable(string + " ");
        return string2;
    }

    public static byte modeFromString(String string) {
        int n = 1;
        if (string == null) {
            return 1;
        }
        if (string.equalsIgnoreCase("out")) {
            n = 2;
        } else if (string.equalsIgnoreCase("inout")) {
            n = 3;
        }
        return (byte)n;
    }

    public static String getModeAsString(byte by) {
        if (by == 3) {
            return "inout";
        }
        if (by == 2) {
            return "out";
        }
        if (by == 1) {
            return "in";
        }
        throw new IllegalArgumentException(Messages.getMessage("badParameterMode", Byte.toString(by)));
    }

    public QName getQName() {
        return this.name;
    }

    public String getName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getLocalPart();
    }

    public void setName(String string) {
        this.name = new QName("", string);
    }

    public void setQName(QName qName) {
        this.name = qName;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public void setTypeQName(QName qName) {
        this.typeQName = qName;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class clazz) {
        if (clazz != null && ((this.mode == 1 || this.isReturn) && (class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = ParameterDesc.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder).isAssignableFrom(clazz) || this.mode != 1 && !this.isReturn && !(class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = ParameterDesc.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder).isAssignableFrom(clazz))) {
            throw new IllegalArgumentException(Messages.getMessage("setJavaTypeErr00", clazz.getName(), ParameterDesc.getModeAsString(this.mode)));
        }
        this.javaType = clazz;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte by) {
        this.mode = by;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public void setInHeader(boolean bl) {
        this.inHeader = bl;
    }

    public boolean isInHeader() {
        return this.inHeader;
    }

    public void setOutHeader(boolean bl) {
        this.outHeader = bl;
    }

    public boolean isOutHeader() {
        return this.outHeader;
    }

    public boolean getIsReturn() {
        return this.isReturn;
    }

    public void setIsReturn(boolean bl) {
        this.isReturn = bl;
    }

    public boolean isMinOccursIs0() {
        return this.minOccursIs0;
    }

    public void setMinOccursIs0(boolean bl) {
        this.minOccursIs0 = bl;
    }

    public boolean isMaxOccursIs1() {
        return this.maxOccursIs1;
    }

    public void setMaxOccursIs1(boolean bl) {
        this.maxOccursIs1 = bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.name == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.name.getNamespaceURI());
            objectOutputStream.writeObject(this.name.getLocalPart());
        }
        if (this.typeQName == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.typeQName.getNamespaceURI());
            objectOutputStream.writeObject(this.typeQName.getLocalPart());
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = objectInputStream.readBoolean() ? new QName((String)objectInputStream.readObject(), (String)objectInputStream.readObject()) : null;
        this.typeQName = objectInputStream.readBoolean() ? new QName((String)objectInputStream.readObject(), (String)objectInputStream.readObject()) : null;
        objectInputStream.defaultReadObject();
    }

    private void makeConfigurable() {
        if (this._configurable == null) {
            this._configurable = new ConfigurableImpl();
        }
    }

    private String toStringConfigurable(String string) {
        Iterator iterator;
        String string2 = "";
        if (this._configurable != null && (iterator = this.getOptions().entrySet().iterator()) != null) {
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                string2 = string2 + string + "KEY(" + entry.getKey() + ")\n";
                string2 = string2 + string + " VALUE(" + entry.getValue() + ")\n";
            }
        }
        return string2;
    }

    public final void setOptionsDefault(Configured configured) {
        this.makeConfigurable();
        this._configurable.setOptionsDefault(configured);
    }

    public final void setOption(String string, Object object) {
        this.makeConfigurable();
        this._configurable.setOption(string, object);
    }

    public final boolean setOptionDefault(String string, Object object) {
        this.makeConfigurable();
        return this._configurable.setOptionDefault(string, object);
    }

    public final void setOptions(Map map) {
        this.makeConfigurable();
        this._configurable.setOptions(map);
    }

    public final Object getOption(String string) {
        this.makeConfigurable();
        return this._configurable.getOption(string);
    }

    public final Map getOptions() {
        this.makeConfigurable();
        return this._configurable.getOptions();
    }

    public Set getOptionsBooleanNames() {
        this.makeConfigurable();
        return this._configurable.getOptionsBooleanNames();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

