/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.enum.MessageType;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.transport.http.SocketInputStream;
import com.ibm.ws.webservices.engine.utils.HrefTable;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPEnvelopeBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DeserializationContextImpl
implements DeserializationContext {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$encoding$DeserializationContextImpl == null ? (class$com$ibm$ws$webservices$engine$encoding$DeserializationContextImpl = DeserializationContextImpl.class$("com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl")) : class$com$ibm$ws$webservices$engine$encoding$DeserializationContextImpl).getName());
    private SOAPEnvelope envelope;
    protected MessageContext msgContext;
    protected P2DConverter eventConverter;
    private HrefTable hrefTable = null;
    private TypeMappingRegistry tmr = null;
    private TypeMapping tm = null;
    private String encodingStyle = null;
    protected InputSource inputSource = null;
    private SAXParser parser = null;
    private static final boolean LAZYPARSEWORKAROUND = false;
    private boolean isLazyParseSOAPElement = true;
    private InputStream bodyStream = null;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$encoding$DeserializationContextImpl;

    public DeserializationContextImpl(MessageContext messageContext, DEventProcessor dEventProcessor) {
        this.msgContext = messageContext;
        if (dEventProcessor instanceof SOAPEnvelopeBuilder) {
            this.envelope = ((SOAPEnvelopeBuilder)dEventProcessor).getEnvelope();
        }
        this.eventConverter = new P2DConverter(new WrapperProcessor(dEventProcessor), this);
    }

    public DeserializationContextImpl(InputSource inputSource, MessageContext messageContext, MessageType messageType) {
        this.msgContext = messageContext;
        SOAPFactory sOAPFactory = new SOAPFactory(this.getSOAPConstants());
        sOAPFactory.setMessageType(messageType);
        try {
            this.envelope = sOAPFactory.createSOAPEnvelope(false);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.DeserializationContextImpl", (String)"211", (Object)this);
            throw new InternalException(sOAPException);
        }
        SOAPEnvelopeBuilder sOAPEnvelopeBuilder = new SOAPEnvelopeBuilder(this.envelope);
        sOAPEnvelopeBuilder.setMyElement(this.envelope);
        this.eventConverter = new P2DConverter(new WrapperProcessor(sOAPEnvelopeBuilder), this);
        this.inputSource = inputSource;
    }

    public DeserializationContextImpl(InputSource inputSource, MessageContext messageContext, MessageType messageType, SOAPEnvelope sOAPEnvelope) {
        this.envelope = sOAPEnvelope;
        SOAPEnvelopeBuilder sOAPEnvelopeBuilder = new SOAPEnvelopeBuilder(sOAPEnvelope);
        sOAPEnvelope.getSOAPFactory().setMessageType(messageType);
        this.msgContext = messageContext;
        this.eventConverter = new P2DConverter(new WrapperProcessor(sOAPEnvelopeBuilder), this);
        this.inputSource = inputSource;
    }

    public void parse() throws SAXException {
        if (this.inputSource != null) {
            this.parser = XMLUtils.getSAXParser();
            try {
                this.parser.parse(this.inputSource, (DefaultHandler)this.eventConverter);
                XMLUtils.releaseSAXParser(this.parser);
                InputStream inputStream = this.inputSource.getByteStream();
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.parse", (String)"269", (Object)this);
                throw new SAXException(iOException);
            }
            finally {
                this.parser = null;
            }
            this.inputSource = null;
        }
    }

    public InputStream getLazyParse() throws SAXException {
        if (this.parser == null) {
            return null;
        }
        try {
            InputStream inputStream = null;
            inputStream = (InputStream)this.parser.getProperty("http://w3.xml.ibm.com/b2b/properties/subtree-as-stream");
            if (inputStream != null) {
                try {
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    String string = new String(byArray);
                    inputStream = new ByteArrayInputStream(string.getBytes("utf-8"));
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.getLazyParse", (String)"316", (Object)this);
                    throw new SAXException(iOException);
                }
            }
            return inputStream;
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, (String)"com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.getLazyParse", (String)"323", (Object)this);
            return null;
        }
    }

    public P2DConverter getEventConverter() {
        return this.eventConverter;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    public HrefTable getHrefTable() {
        if (this.hrefTable == null) {
            this.hrefTable = new HrefTable(this);
        }
        return this.hrefTable;
    }

    public final Deserializer getDeserializer(Class clazz, QName qName) {
        if (qName == null) {
            return null;
        }
        DeserializerFactory deserializerFactory = null;
        Deserializer deserializer = null;
        try {
            deserializerFactory = (DeserializerFactory)this.getTypeMapping().getDeserializer(clazz, qName);
        }
        catch (JAXRPCException jAXRPCException) {
            FFDCFilter.processException((Throwable)jAXRPCException, (String)"com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.getDeserializer", (String)"390", (Object)this);
            log.error((Object)Messages.getMessage("noFactory00", qName.toString()));
        }
        if (deserializerFactory != null) {
            try {
                deserializer = (Deserializer)deserializerFactory.getDeserializerAs("WebServices SAX Mechanism");
            }
            catch (JAXRPCException jAXRPCException) {
                FFDCFilter.processException((Throwable)jAXRPCException, (String)"com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.getDeserializer", (String)"397", (Object)this);
                TypeMappingRegistry typeMappingRegistry = this.getTypeMappingRegistry();
                if (typeMappingRegistry.getRegisteredEncodingStyleURIs().length == 0) {
                    log.error((Object)Messages.getMessage("noDSerErr02", qName.toString()));
                }
                log.error((Object)Messages.getMessage("noDSerErr02", qName.toString()));
            }
        }
        return deserializer;
    }

    public TypeMapping getTypeMapping() {
        if (this.tm == null) {
            this.tm = (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(this.getEncodingStyle());
        }
        return this.tm;
    }

    public String getEncodingStyle() {
        if (this.encodingStyle == null) {
            this.encodingStyle = this.msgContext.getEncodingStyle();
        }
        return this.encodingStyle;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.tmr == null) {
            this.tmr = this.msgContext.getTypeMappingRegistry();
        }
        return this.tmr;
    }

    private SOAPConstants getSOAPConstants() {
        SOAPConstants sOAPConstants = null;
        if (this.msgContext != null) {
            sOAPConstants = this.msgContext.getSOAPConstants();
        }
        if (sOAPConstants == null) {
            sOAPConstants = SOAPConstants.SOAP11_CONSTANTS;
        }
        return sOAPConstants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getBodyStream() throws IOException {
        int n;
        int n2;
        Object object;
        Object object2;
        String string;
        block13: {
            block12: {
                if (this.msgContext == null || this.msgContext.getPort() == null) {
                    return;
                }
                if (this.msgContext.getPort().getOption("lazyParseQNames") == null) {
                    return;
                }
                List list = (List)this.msgContext.getPort().getOption("lazyParseQNames");
                QName qName = QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", "Body");
                QName qName2 = QNameTable.createQName("http://www.w3.org/2002/06/soap-envelope", "Body");
                if (!list.contains(qName) && !list.contains(qName2)) {
                    return;
                }
                InputStream inputStream = this.inputSource.getByteStream();
                string = null;
                if (inputStream == null) break block12;
                try {
                    object2 = null;
                    object = new ByteArrayOutputStream();
                    object2 = new byte[4096];
                    while ((n2 = inputStream.read((byte[])object2, 0, 4096)) != -1) {
                        ((ByteArrayOutputStream)object).write((byte[])object2, 0, n2);
                    }
                    object2 = ((ByteArrayOutputStream)object).toByteArray();
                    string = new String((byte[])object2, "utf-8");
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (inputStream != null && inputStream instanceof SocketInputStream) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                if (inputStream != null && inputStream instanceof SocketInputStream) {
                    inputStream.close();
                }
                break block13;
            }
            object2 = this.inputSource.getCharacterStream();
            if (object2 == null) {
                return;
            }
            object = null;
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            object = new char[4096];
            while ((n = ((Reader)object2).read((char[])object, 0, 4096)) != -1) {
                charArrayWriter.write((char[])object, 0, n);
            }
            string = charArrayWriter.toString();
        }
        object2 = "";
        object = "";
        n2 = string.indexOf("Body");
        n2 = string.indexOf(">", n2);
        n = string.lastIndexOf("Body");
        n = string.lastIndexOf("<", n);
        object2 = string.substring(0, n2 + 1) + string.substring(n);
        object = string.substring(n2 + 1, n);
        this.inputSource = new InputSource(new StringReader((String)object2));
        this.inputSource.setEncoding("utf-8");
        this.bodyStream = new ByteArrayInputStream(((String)object).getBytes("utf-8"));
    }

    public void enableLazyParseSOAPElement() {
        this.isLazyParseSOAPElement = true;
        this.eventConverter.disableSimpleEvent();
    }

    public void disableLazyParseSOAPElement() {
        this.isLazyParseSOAPElement = false;
        this.eventConverter.enableSimpleEvent();
    }

    public boolean isLazyParseSOAPElement() {
        return this.isLazyParseSOAPElement && !this.eventConverter.isSimpleEventEnabled();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

