/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.Callback;
import com.ibm.ws.webservices.engine.encoding.utils.CallbackTarget;
import com.ibm.ws.webservices.engine.encoding.utils.Target;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import java.util.HashSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class Deserializer
extends DEventProcessor
implements javax.xml.rpc.encoding.Deserializer,
Callback {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$encoding$Deserializer == null ? (class$com$ibm$ws$webservices$engine$encoding$Deserializer = Deserializer.class$("com.ibm.ws.webservices.engine.encoding.Deserializer")) : class$com$ibm$ws$webservices$engine$encoding$Deserializer).getName());
    protected QName xmlType;
    protected Class javaType;
    protected Object value = null;
    protected Vector targets = null;
    protected QName defaultType = null;
    private boolean componentsReadyFlag = false;
    protected boolean isEnded = false;
    protected boolean isHref = false;
    protected boolean isNil = false;
    protected String id = null;
    private HashSet activeDeserializers = null;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$encoding$Deserializer;

    public Deserializer(Class clazz, QName qName) {
        this.javaType = clazz;
        this.xmlType = qName;
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public Object getValue(Object object) {
        return null;
    }

    public void setValue(Object object, Object object2) throws SAXException {
        if (object2 instanceof Deserializer) {
            if (this.activeDeserializers != null) {
                this.activeDeserializers.remove(object2);
            }
            if (this.componentsReady()) {
                this.valueComplete();
            }
        }
    }

    public void setDefaultType(QName qName) {
        this.defaultType = qName;
    }

    public QName getDefaultType() {
        return this.defaultType;
    }

    public void registerValueTarget(Target target) {
        if (this.targets == null) {
            this.targets = new Vector();
        }
        this.targets.addElement(target);
    }

    public Vector getValueTargets() {
        return this.targets;
    }

    public void removeValueTargets() {
        if (this.targets != null) {
            this.targets.clear();
            this.targets = null;
        }
    }

    public void moveValueTargets(Deserializer deserializer) {
        Vector vector;
        if (deserializer == null || deserializer.getValueTargets() == null) {
            return;
        }
        if (this.targets == null) {
            this.targets = new Vector();
        }
        if ((vector = deserializer.getValueTargets()) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.targets.addElement(vector.get(i));
            }
        }
        deserializer.removeValueTargets();
    }

    public boolean componentsReady() {
        return this.componentsReadyFlag || !this.isHref && this.isEnded && (this.activeDeserializers == null || this.activeDeserializers.isEmpty());
    }

    public void valueComplete() throws SAXException {
        if (this.componentsReady() && this.targets != null) {
            for (int i = 0; i < this.targets.size(); ++i) {
                Target target = (Target)this.targets.get(i);
                target.set(this.value);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)Messages.getMessage("setValueInTarget00", JavaUtils.objectToString(this.value), "" + target));
            }
            this.removeValueTargets();
        }
        this.inUse = false;
    }

    public void addChildDeserializer(Deserializer deserializer, String string) {
        if (string != null || !(deserializer instanceof SimpleDeserializer)) {
            if (this.activeDeserializers == null) {
                this.activeDeserializers = new HashSet();
            }
            this.activeDeserializers.add(deserializer);
            deserializer.registerValueTarget(new CallbackTarget(this, deserializer));
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        String string4;
        if (AttributeUtils.isNil(attributes)) {
            this.value = null;
            this.isNil = true;
            return;
        }
        this.id = attributes.getValue("id");
        if (this.id != null) {
            deserializationContext.getHrefTable().addObjectByID(this.id, this.value);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("deserInitPutValueDebug00", JavaUtils.objectToString(this.value), this.id));
            }
            deserializationContext.getHrefTable().registerFixupByHref("#" + this.id, this);
        }
        if ((string4 = attributes.getValue("href")) != null) {
            this.isHref = true;
            Object object = deserializationContext.getHrefTable().getObjectByHref(string4);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("gotForID00", new String[]{JavaUtils.objectToString(object), string4, object == null ? "*null*" : object.getClass().toString()}));
            }
            if (object == null) {
                deserializationContext.getHrefTable().registerFixupByHref(string4, this);
                return;
            }
            if (object instanceof SOAPElement) {
                deserializationContext.getEventConverter().popDEventProcessor();
                deserializationContext.getEventConverter().pushDEventProcessor(new WrapperProcessor(this));
                ((SOAPElement)object).toEvents(deserializationContext.getEventConverter());
                return;
            }
            if (!string4.startsWith("#") && this.defaultType != null && object instanceof Part) {
                Deserializer deserializer = deserializationContext.getDeserializer(null, this.defaultType);
                if (null != deserializer) {
                    deserializer.startElement(string, string2, string3, attributes, mappingScope, deserializationContext);
                    object = deserializer.getValue();
                }
                this.value = object;
                this.componentsReadyFlag = true;
                this.valueComplete();
                return;
            }
            this.value = object;
            this.componentsReadyFlag = true;
            this.valueComplete();
            return;
        }
        this.isHref = false;
        this.onStartElement(string, string2, string3, attributes, mappingScope, deserializationContext);
    }

    public void onStartElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
    }

    public abstract DEventProcessor onStartChild(String var1, String var2, String var3, Attributes var4, MappingScope var5, DeserializationContext var6) throws SAXException;

    public final void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        this.isEnded = true;
        if (!this.isHref) {
            this.onEndElement(string, string2, deserializationContext);
        }
        if (this.componentsReady()) {
            this.valueComplete();
        }
        if (this.id != null) {
            deserializationContext.getHrefTable().addObjectByID(this.id, this.value);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("deserPutValueDebug00", JavaUtils.objectToString(this.value), this.id));
            }
        }
    }

    public void onEndElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

