/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SerializationWriter {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$encoding$SerializationWriter == null ? (class$com$ibm$ws$webservices$engine$encoding$SerializationWriter = SerializationWriter.class$("com.ibm.ws.webservices.engine.encoding.SerializationWriter")) : class$com$ibm$ws$webservices$engine$encoding$SerializationWriter).getName());
    private Scopes scopes = new Scopes();
    private boolean writingStartTag = false;
    private boolean startOfDocument = true;
    private int indent = 0;
    private boolean onlyXML = true;
    private boolean pretty = false;
    private Stack stack = new Stack();
    private Writer writer;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$encoding$SerializationWriter;

    SerializationWriter(Writer writer, boolean bl) {
        this.writer = writer;
        this.startOfDocument = bl;
    }

    public boolean getPretty() {
        return this.pretty;
    }

    public void setPretty(boolean bl) {
        this.pretty = bl;
    }

    public void startElement(QName qName, Attributes attributes, MappingScope mappingScope) throws IOException {
        if (mappingScope != null) {
            this.scopes.replaceMappingScope(mappingScope);
        }
        this.startElement(qName, attributes);
    }

    public void startElement(QName qName, Attributes attributes) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("startElem00", "[" + qName.getNamespaceURI() + "]:" + qName.getLocalPart()));
        }
        if (this.startOfDocument) {
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.startOfDocument = false;
        }
        if (this.writingStartTag) {
            this.writer.write(62);
            if (this.pretty) {
                this.writer.write(10);
            }
            ++this.indent;
        }
        if (this.pretty) {
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write(32);
            }
        }
        this.writer.write(60);
        MappingScope mappingScope = this.scopes.getMappingScope();
        String string = mappingScope.getOrCreatePrefix(qName.getNamespaceURI(), null, false);
        this.stack.push(qName.getLocalPart());
        this.stack.push(string);
        if (string.length() > 0) {
            this.writer.write(string);
            this.writer.write(58);
        }
        this.writer.write(qName.getLocalPart());
        ArrayList arrayList = null;
        if (attributes != null && attributes.getLength() > 0) {
            this.writeAttributes(attributes);
        }
        if (mappingScope.size() > 0) {
            this.writePrefixMappings(mappingScope, arrayList);
        }
        this.scopes.push();
        this.writingStartTag = true;
        this.onlyXML = true;
    }

    private ArrayList writeAttributes(Attributes attributes) throws IOException {
        ArrayList<String> arrayList = null;
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                int n;
                this.writer.write(32);
                String string = attributes.getURI(i);
                String string2 = "";
                String string3 = attributes.getQName(i);
                if (string3.length() == 0) {
                    string3 = attributes.getLocalName(i);
                }
                if (string != null && string.length() > 0 && (n = string3.indexOf(58)) > -1) {
                    String string4 = null;
                    string2 = string3.substring(0, n);
                    if (!string2.equals("xmlns")) {
                        string4 = this.getOrCreatePrefix(string, string2, true);
                    }
                    if (string4 != null && !string4.equals(string2)) {
                        string3 = string4.length() > 0 ? string4 + ':' + attributes.getLocalName(i) : attributes.getLocalName(i);
                    }
                }
                if (string3.startsWith("xmlns")) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    if (arrayList.indexOf(attributes.getLocalName(i)) >= 0) continue;
                    arrayList.add(attributes.getLocalName(i));
                }
                this.writer.write(string3);
                this.writer.write("=\"");
                this.writer.write(XMLUtils.xmlEncodeString(attributes.getValue(i)));
                this.writer.write(34);
            }
        }
        return arrayList;
    }

    private void writePrefixMappings(MappingScope mappingScope, ArrayList arrayList) throws IOException {
        for (int i = 0; i < mappingScope.size(); ++i) {
            Mapping mapping = mappingScope.get(i);
            if ("http://www.w3.org/XML/1998/namespace".equals(mapping.getNamespaceURI()) || arrayList != null && arrayList.indexOf(mapping.getPrefix()) >= 0) continue;
            this.writer.write(" xmlns");
            if (mapping.getPrefix().length() > 0) {
                this.writer.write(58);
                this.writer.write(mapping.getPrefix());
            }
            this.writer.write("=\"");
            this.writer.write(mapping.getNamespaceURI());
            this.writer.write(34);
        }
    }

    public void endElement() throws IOException {
        String string = (String)this.stack.pop();
        String string2 = (String)this.stack.pop();
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("endElem00", "" + string + ":" + string2));
        }
        this.scopes.pop();
        if (this.writingStartTag) {
            this.writer.write("/>");
            if (this.pretty) {
                this.writer.write(10);
            }
            this.writingStartTag = false;
        } else {
            if (this.onlyXML) {
                --this.indent;
                if (this.pretty) {
                    for (int i = 0; i < this.indent; ++i) {
                        this.writer.write(32);
                    }
                }
            }
            this.writer.write("</");
            if (string.length() > 0) {
                this.writer.write(string);
                this.writer.write(58);
            }
            this.writer.write(string2);
            this.writer.write(62);
            if (this.pretty && this.indent > 0) {
                this.writer.write(10);
            }
        }
        this.onlyXML = true;
    }

    public void simpleElement(QName qName, Attributes attributes, MappingScope mappingScope, String string) throws IOException {
        if (mappingScope != null) {
            this.scopes.replaceMappingScope(mappingScope);
        }
        this.simpleElement(qName, attributes, string);
    }

    public void simpleElement(QName qName, Attributes attributes, String string) throws IOException {
        if (this.startOfDocument) {
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.startOfDocument = false;
        }
        if (this.writingStartTag) {
            this.writer.write(62);
            if (this.pretty) {
                this.writer.write(10);
            }
            ++this.indent;
        }
        if (this.pretty) {
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write(32);
            }
        }
        this.writer.write(60);
        MappingScope mappingScope = this.scopes.getMappingScope();
        String string2 = this.scopes.getPrefix(qName.getNamespaceURI());
        if (string2.length() > 0) {
            this.writer.write(string2);
            this.writer.write(58);
        }
        this.writer.write(qName.getLocalPart());
        ArrayList arrayList = null;
        if (attributes != null && attributes.getLength() > 0) {
            this.writeAttributes(attributes);
        }
        if (mappingScope.size() > 0) {
            this.writePrefixMappings(mappingScope, arrayList);
        }
        this.writingStartTag = true;
        this.onlyXML = true;
        if (string != null && string.length() > 0) {
            this.writeSafeString(string);
        }
        mappingScope.clear();
        if (this.writingStartTag) {
            this.writer.write("/>");
            if (this.pretty) {
                this.writer.write(10);
            }
            this.writingStartTag = false;
        } else {
            if (this.onlyXML) {
                --this.indent;
                if (this.pretty) {
                    for (int i = 0; i < this.indent; ++i) {
                        this.writer.write(32);
                    }
                }
            }
            this.writer.write("</");
            if (string2.length() > 0) {
                this.writer.write(string2);
                this.writer.write(58);
            }
            this.writer.write(qName.getLocalPart());
            this.writer.write(62);
            if (this.pretty && this.indent > 0) {
                this.writer.write(10);
            }
        }
        this.onlyXML = true;
    }

    public void writeChars(char[] cArray, int n, int n2) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writeSafeString(String.valueOf(cArray, n, n2));
        this.onlyXML = false;
    }

    public void writeString(String string) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writer.write(string);
        this.onlyXML = false;
    }

    public void writeSnippet(String string, MappingScope mappingScope) throws IOException {
        int n = string.indexOf(">");
        if (mappingScope == null || mappingScope.size() == 0 || n <= 0) {
            this.writeString(string);
            return;
        }
        if (string.charAt(n - 1) == '/') {
            --n;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        for (int i = 0; i < mappingScope.size(); ++i) {
            Mapping mapping = mappingScope.get(i);
            String string4 = "xmlns:" + mapping.getPrefix() + "=";
            int n2 = string2.indexOf(string4);
            if (n2 >= 0) continue;
            string2 = string2 + " " + string4 + "\"" + mapping.getNamespaceURI() + "\"";
        }
        this.writeString(string2 + string3);
    }

    public void writeSafeString(String string) throws IOException {
        if (string.length() > 9 && string.substring(0, 9).toUpperCase().equals("<![CDATA[")) {
            this.writeString(string);
        } else {
            this.writeString(XMLUtils.xmlEncodeString(string));
        }
    }

    public void writeDOMElement(Element element) throws IOException {
        Object object;
        Object object2;
        Object object3;
        AttributesImpl attributesImpl = null;
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap.getLength() > 0) {
            attributesImpl = new AttributesImpl();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                object3 = (Attr)namedNodeMap.item(i);
                object2 = object3.getNamespaceURI();
                if (object2 != null && ((String)object2).equals("http://www.w3.org/2000/xmlns/")) {
                    object = object3.getLocalName();
                    if (object == null) continue;
                    if (((String)object).equals("xmlns")) {
                        object = "";
                    }
                    String string = object3.getValue();
                    this.addMapping((String)object, string);
                    continue;
                }
                attributesImpl.addAttribute(object3.getNamespaceURI(), object3.getLocalName(), object3.getName(), "CDATA", object3.getValue());
            }
        }
        String string = element.getNamespaceURI();
        object3 = element.getLocalName();
        if (string == null || string.length() == 0) {
            object3 = element.getNodeName();
        }
        object2 = QNameTable.createQName(string, (String)object3);
        this.startElement((QName)object2, attributesImpl);
        object = element.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            if (node instanceof Element) {
                this.writeDOMElement((Element)node);
                continue;
            }
            if (node instanceof CDATASection) {
                this.writeString("<![CDATA[");
                this.writeString(((Text)node).getData());
                this.writeString("]]>");
                continue;
            }
            if (node instanceof Comment) {
                this.writeString("<!--");
                this.writeString(((CharacterData)node).getData());
                this.writeString("-->");
                continue;
            }
            if (!(node instanceof Text)) continue;
            this.writeSafeString(((Text)node).getData());
        }
        this.endElement();
    }

    public String getOrCreatePrefix(String string, String string2, boolean bl) {
        return this.scopes.getMappingScope().getOrCreatePrefix(string, string2, bl);
    }

    public void addMapping(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "prefix"));
        }
        if (string2 == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "namespaceURI"));
        }
        if (string2.length() == 0 && string.length() > 0) {
            throw new IllegalArgumentException(Messages.getMessage("mapUnqualNamespace00", string));
        }
        this.scopes.getMappingScope().addMapping(string2, string);
    }

    public String qName2String(QName qName) {
        return this.qName2String(qName, true);
    }

    public String qName2String(QName qName, boolean bl) {
        String string = this.getOrCreatePrefix(qName.getNamespaceURI(), null, bl);
        if (string.length() == 0) {
            return qName.getLocalPart();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(':');
        stringBuffer.append(qName.getLocalPart());
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Scopes {
        private MappingScope[] mArray = new MappingScope[10];
        int top = -1;
        boolean cacheValid = false;
        String cachePrefix = null;
        String cacheNamespaceURI = null;

        public Scopes() {
            this.push();
        }

        public MappingScope getMappingScope() {
            if (this.top < 0) {
                return null;
            }
            MappingScope mappingScope = this.mArray[this.top];
            if (mappingScope == null) {
                mappingScope = new MappingScope();
                if (this.top > 0) {
                    mappingScope.setParent(this.mArray[this.top - 1]);
                }
                this.mArray[this.top] = mappingScope;
            }
            return mappingScope;
        }

        public void replaceMappingScope(MappingScope mappingScope) {
            if (mappingScope != this.mArray[this.top]) {
                if (mappingScope.size() == 0) {
                    this.getMappingScope().clear();
                    if (this.top > 0) {
                        this.getMappingScope().setParent(this.mArray[this.top - 1]);
                    }
                } else {
                    this.cacheValid = false;
                    this.mArray[this.top] = (MappingScope)mappingScope.clone();
                    if (this.top > 0) {
                        this.getMappingScope().setParent(this.mArray[this.top - 1]);
                    }
                }
            }
        }

        public void push() {
            this.cacheValid = false;
            ++this.top;
            if (this.top >= this.mArray.length) {
                MappingScope[] mappingScopeArray = new MappingScope[this.mArray.length * 2];
                System.arraycopy(this.mArray, 0, mappingScopeArray, 0, this.mArray.length);
                this.mArray = mappingScopeArray;
            }
            this.getMappingScope().clear();
        }

        public void pop() {
            this.cacheValid = false;
            --this.top;
            if (this.top >= 0) {
                this.getMappingScope().clear();
            }
        }

        public String getPrefix(String string) {
            MappingScope mappingScope = this.getMappingScope();
            if (this.cacheValid && string == this.cacheNamespaceURI && mappingScope.size() == 0) {
                return this.cachePrefix;
            }
            this.cacheNamespaceURI = string;
            this.cachePrefix = mappingScope.getOrCreatePrefix(this.cacheNamespaceURI, null, false);
            this.cacheValid = mappingScope.size() == 0;
            return this.cachePrefix;
        }
    }
}

